/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.logging;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class Log4jConfigurator {
    private static final Logger logging = Logger.getLogger(Log4jConfigurator.class);
    private static final String ROOT = "root";
    private static Log4jConfigurator instance;
    public static final String SYS_PROP_SHOW_ALL = "org.swisspush.gateleen.logging.log4j.showall";

    private Log4jConfigurator() {
    }

    public static synchronized Log4jConfigurator getInstance() {
        if (instance == null) {
            logging.trace((Object)"Creating new Log4jConfigurator instance");
            instance = new Log4jConfigurator();
        }
        return instance;
    }

    public synchronized List<String> getLoggers() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getLoggerName(LogManager.getRootLogger()));
        Enumeration enumer = LogManager.getCurrentLoggers();
        while (enumer.hasMoreElements()) {
            Logger logger = (Logger)enumer.nextElement();
            if (logger.getLevel() == null) continue;
            list.add(this.getLoggerName(logger));
        }
        if (logging.isDebugEnabled()) {
            logging.debug((Object)("getLoggers() returns totally " + list.size() + " loggers"));
        }
        return list;
    }

    public synchronized List<String> getLoggersSorted() {
        List<String> loggers = this.getLoggers();
        LoggerComparator comp = new LoggerComparator();
        loggers.sort(comp);
        return loggers;
    }

    public synchronized List<String> getAppenders(String logger) throws IllegalArgumentException {
        Logger logobj = this.getLoggerFromName(logger);
        ArrayList<String> list = new ArrayList<String>();
        Enumeration e = logobj.getAllAppenders();
        while (e.hasMoreElements()) {
            list.add(((Appender)e.nextElement()).getName());
        }
        if (logging.isDebugEnabled()) {
            logging.debug((Object)("getAppenders(" + logger + ") found " + list.size() + " appenders"));
        }
        return list;
    }

    public synchronized Level getLevel(String logger) throws IllegalArgumentException {
        Logger logobj = this.getLoggerFromName(logger);
        if (logging.isTraceEnabled()) {
            logging.trace((Object)("getLevel(" + logger + ") returns " + logobj.getLevel()));
        }
        return logobj.getLevel();
    }

    public synchronized Level getEffectiveLevel(String logger) throws IllegalArgumentException {
        Logger logobj = this.getLoggerFromName(logger);
        if (logging.isTraceEnabled()) {
            logging.trace((Object)("getEffectiveLevel(" + logger + ") returns " + logobj.getEffectiveLevel()));
        }
        return logobj.getEffectiveLevel();
    }

    public synchronized void setLoggerLevel(String logger, String level) throws IllegalArgumentException {
        Logger logobj = this.getLoggerFromName(logger);
        logobj.setLevel(Level.toLevel((String)level));
        logging.info((Object)("New level for looger '" + logger + "': " + level));
    }

    private String getLoggerName(Logger logger) {
        if (logger == null) {
            return null;
        }
        if (logger.getParent() == null) {
            return ROOT;
        }
        return logger.getName();
    }

    private Logger getLoggerFromName(String name) throws IllegalArgumentException {
        Logger logger = null;
        logger = name.equals(ROOT) ? Logger.getRootLogger() : Logger.getLogger((String)name);
        if (logger == null) {
            throw new IllegalArgumentException("Unknown logger 'null'");
        }
        return logger;
    }

    private class LoggerComparator
    implements Comparator<String> {
        private LoggerComparator() {
        }

        @Override
        public int compare(String l1, String l2) {
            if (l1 == null) {
                l1 = "";
            }
            if (l2 == null) {
                l2 = "";
            }
            if (l1.equals(Log4jConfigurator.ROOT)) {
                if (l2.equals(Log4jConfigurator.ROOT)) {
                    return 0;
                }
                return -1;
            }
            if (l2.equals(Log4jConfigurator.ROOT)) {
                return 1;
            }
            return l1.compareTo(l2);
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof LoggerComparator;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

