/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.logging;

import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import org.swisspush.gateleen.core.http.DummyHttpServerRequest;
import org.swisspush.gateleen.core.util.Address;
import org.swisspush.gateleen.core.util.JsonObjectUtils;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.logging.LoggingHandler;
import org.swisspush.gateleen.logging.LoggingResourceManager;

public class RequestLoggingConsumer {
    private final Vertx vertx;
    private final LoggingResourceManager loggingResourceManager;

    public RequestLoggingConsumer(Vertx vertx, LoggingResourceManager loggingResourceManager) {
        this.vertx = vertx;
        this.loggingResourceManager = loggingResourceManager;
        vertx.eventBus().localConsumer(Address.requestLoggingConsumerAddress(), event -> {
            try {
                JsonObject body = (JsonObject)event.body();
                String uri = body.getString("request_uri");
                String method = body.getString("request_method");
                HttpMethod httpMethod = HttpMethod.valueOf((String)method);
                JsonObject requestHeaders = body.getJsonObject("request_headers");
                JsonObject responseHeaders = body.getJsonObject("response_headers");
                MultiMap requestHeadersMap = JsonObjectUtils.jsonObjectToMultiMap((JsonObject)requestHeaders);
                MultiMap responseHeadersMap = JsonObjectUtils.jsonObjectToMultiMap((JsonObject)responseHeaders);
                Integer status = body.getInteger("request_status");
                String payloadStr = body.getString("body");
                JsonObject payloadObject = new JsonObject(payloadStr);
                Buffer payloadBuffer = Buffer.buffer((String)payloadObject.encode());
                RequestLoggingRequest req = new RequestLoggingRequest(uri, httpMethod, requestHeadersMap);
                this.logRequest((HttpServerRequest)req, status, payloadBuffer, responseHeadersMap);
                event.reply((Object)new JsonObject().put("status", (Object)"ok"));
            }
            catch (Exception ex) {
                event.reply((Object)new JsonObject().put("status", (Object)"error").put("message", (Object)ex.getMessage()));
            }
        });
    }

    private void logRequest(HttpServerRequest request, int status, Buffer data, MultiMap responseHeaders) {
        LoggingHandler loggingHandler = new LoggingHandler(this.loggingResourceManager, request, this.vertx.eventBus());
        if (HttpMethod.PUT == request.method() || HttpMethod.POST == request.method()) {
            loggingHandler.appendRequestPayload(data);
        } else if (HttpMethod.GET == request.method()) {
            loggingHandler.appendResponsePayload(data, responseHeaders);
        }
        StatusCode statusCode = StatusCode.fromCode((int)status);
        String statusMessage = statusCode != null ? statusCode.getStatusMessage() : "";
        this.vertx.runOnContext(event -> loggingHandler.log(request.uri(), request.method(), status, statusMessage, request.headers(), responseHeaders));
    }

    private class RequestLoggingRequest
    extends DummyHttpServerRequest {
        private String uri;
        private HttpMethod method;
        private MultiMap headers;

        public RequestLoggingRequest(String uri, HttpMethod method, MultiMap headers) {
            this.uri = uri;
            this.method = method;
            this.headers = headers;
        }

        public HttpMethod method() {
            return this.method;
        }

        public String uri() {
            return this.uri;
        }

        public MultiMap headers() {
            return this.headers;
        }
    }
}

