/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.logging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;

public class Log4jConfigurator {
    private static final Logger logging = LogManager.getLogger(Log4jConfigurator.class);
    private static final String ROOT = "root";
    private static Log4jConfigurator instance;

    private Log4jConfigurator() {
    }

    public static synchronized Log4jConfigurator getInstance() {
        if (instance == null) {
            logging.trace("Creating new Log4jConfigurator instance");
            instance = new Log4jConfigurator();
        }
        return instance;
    }

    public synchronized List<String> getLoggers() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getLoggerName(LogManager.getRootLogger()));
        Collection loggerCollection = ((LoggerContext)LogManager.getContext((boolean)false)).getLoggers();
        loggerCollection.forEach(logger -> {
            if (logger.getLevel() != null) {
                list.add(this.getLoggerName((Logger)logger));
            }
        });
        if (logging.isDebugEnabled()) {
            logging.debug("getLoggers() returns totally " + list.size() + " loggers");
        }
        return list;
    }

    public synchronized List<String> getLoggersSorted() {
        List<String> loggers = this.getLoggers();
        LoggerComparator comp = new LoggerComparator();
        loggers.sort(comp);
        return loggers;
    }

    public synchronized List<String> getAppenders(String logger) throws IllegalArgumentException {
        Logger logobj = this.getLoggerFromName(logger);
        ArrayList<String> list = new ArrayList<String>();
        Map appenderMap = ((org.apache.logging.log4j.core.Logger)logobj).getAppenders();
        appenderMap.forEach((s, appender) -> list.add(appender.getName()));
        if (logging.isDebugEnabled()) {
            logging.debug("getAppenders(" + logger + ") found " + list.size() + " appenders");
        }
        return list;
    }

    public synchronized Level getLevel(String logger) throws IllegalArgumentException {
        Logger logobj = this.getLoggerFromName(logger);
        if (logging.isTraceEnabled()) {
            logging.trace("getLevel(" + logger + ") returns " + logobj.getLevel());
        }
        return logobj.getLevel();
    }

    public synchronized Level getEffectiveLevel(String logger) throws IllegalArgumentException {
        Logger logobj = this.getLoggerFromName(logger);
        if (logging.isTraceEnabled()) {
            logging.trace("getEffectiveLevel(" + logger + ") returns " + logobj.getLevel());
        }
        return logobj.getLevel();
    }

    public synchronized void setLoggerLevel(String name, String level) throws IllegalArgumentException {
        Configurator.setLevel((String)name, (Level)Level.toLevel((String)level));
        logging.info("New level for looger '" + name + "': " + level);
    }

    private String getLoggerName(Logger logger) {
        if (!(logger instanceof org.apache.logging.log4j.core.Logger)) {
            return null;
        }
        if (((org.apache.logging.log4j.core.Logger)logger).getParent() == null) {
            return ROOT;
        }
        return logger.getName();
    }

    private Logger getLoggerFromName(String name) throws IllegalArgumentException {
        Logger logger = null;
        logger = name.equals(ROOT) ? LogManager.getRootLogger() : LogManager.getLogger((String)name);
        if (logger == null) {
            throw new IllegalArgumentException("Unknown logger 'null'");
        }
        return logger;
    }

    private class LoggerComparator
    implements Comparator<String> {
        private LoggerComparator() {
        }

        @Override
        public int compare(String l1, String l2) {
            if (l1 == null) {
                l1 = "";
            }
            if (l2 == null) {
                l2 = "";
            }
            if (l1.equals(Log4jConfigurator.ROOT)) {
                if (l2.equals(Log4jConfigurator.ROOT)) {
                    return 0;
                }
                return -1;
            }
            if (l2.equals(Log4jConfigurator.ROOT)) {
                return 1;
            }
            return l1.compareTo(l2);
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof LoggerComparator;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

