/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.logging;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.swisspush.gateleen.logging.CloneableDynamicMBean;
import org.swisspush.gateleen.logging.Log4jConfigurator;

public class Log4jConfiguratorMBean
implements CloneableDynamicMBean {
    private final Logger logging = LogManager.getLogger(Log4jConfiguratorMBean.class);
    public static final String ASTERISK = "*";
    public static final String DEFAULT_JMX_NAME = "Log4jConfigurator";
    private static final String SET_LOGGER_LEVEL_METHOD = "setLoggerLevel";

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        this.logging.trace("getAttribute(" + attribute + ")");
        Log4jConfigurator cnf = Log4jConfigurator.getInstance();
        Object level = null;
        try {
            if (cnf.getLevel(attribute) == null) {
                level = cnf.getEffectiveLevel(attribute).toString();
                level = (String)level + ASTERISK;
            } else {
                level = cnf.getLevel(attribute).toString();
            }
        }
        catch (IllegalArgumentException e) {
            String msg = "Unknown attribute '" + attribute + "'";
            this.logging.warn(msg, (Throwable)e);
            throw new AttributeNotFoundException(msg);
        }
        return level;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.logging.trace("setAttribute(" + attribute + ")");
        Log4jConfigurator cnf = Log4jConfigurator.getInstance();
        try {
            cnf.setLoggerLevel(attribute.getName(), (String)attribute.getValue());
        }
        catch (IllegalArgumentException e) {
            String msg = "Unknown attribute '" + attribute + "'";
            this.logging.warn(msg, (Throwable)e);
            throw new AttributeNotFoundException(msg);
        }
        catch (ClassCastException e) {
            String msg = "Unexpected type of attribute value; expected " + String.class.getName() + " but got " + attribute.getValue().getClass().getName();
            this.logging.warn(msg, (Throwable)e);
            throw new MBeanException(e, msg);
        }
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        this.logging.trace("getAttributes(" + attributes + ")");
        AttributeList ret = new AttributeList();
        for (String attribute : attributes) {
            Object val = null;
            try {
                val = this.getAttribute(attribute);
            }
            catch (Exception e) {
                this.logging.error((Object)e);
            }
            ret.add(new Attribute(attribute, val));
        }
        return ret;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        this.logging.trace("setAttributes(" + attributes + ")");
        for (Object attribute : attributes) {
            try {
                this.setAttribute((Attribute)attribute);
            }
            catch (Exception e) {
                this.logging.error((Object)e);
            }
        }
        return null;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        this.logging.trace("invoke(" + actionName + "," + params + "," + signature + ")");
        Method action = null;
        try {
            Class[] classes = new Class[signature.length];
            for (int idx = 0; idx < signature.length; ++idx) {
                classes[idx] = Class.forName(signature[idx]);
            }
            action = this.getClass().getMethod(actionName, classes);
        }
        catch (Exception e) {
            String msg = "Unknown action " + actionName;
            this.logging.error(msg, (Throwable)e);
            throw new ReflectionException(e, msg);
        }
        try {
            Object ret = action.invoke((Object)this, params);
            this.logging.info("Successfully invoked action " + actionName);
            return ret;
        }
        catch (Exception e) {
            String msg = "Error while invoking action " + actionName;
            this.logging.error(msg, (Throwable)e);
            throw new ReflectionException(e, msg);
        }
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        this.logging.trace("getMBeanInfo()");
        return new MBeanInfo(Log4jConfiguratorMBean.class.getName(), "Test implementation of a MBean", this.getAttributeInfo(), this.getConstructorInfo(), this.getOperationInfo(), this.getNotificationInfo());
    }

    private MBeanAttributeInfo[] getAttributeInfo() {
        Log4jConfigurator cnf = Log4jConfigurator.getInstance();
        List<String> loggers = cnf.getLoggersSorted();
        MBeanAttributeInfo[] attrInfo = new MBeanAttributeInfo[loggers.size()];
        Iterator<String> it = loggers.iterator();
        int idx = 0;
        while (it.hasNext()) {
            String logger = it.next();
            attrInfo[idx] = new MBeanAttributeInfo(logger, String.class.getName(), "Level for log4j logger '" + logger + "'", true, true, false);
            ++idx;
        }
        if (this.logging.isDebugEnabled()) {
            for (MBeanAttributeInfo mBeanAttributeInfo : attrInfo) {
                this.logging.debug("Attribute '" + mBeanAttributeInfo.getName() + "': type=" + mBeanAttributeInfo.getType() + "; readable=" + mBeanAttributeInfo.isReadable() + "; writable=" + mBeanAttributeInfo.isWritable() + "; is=" + mBeanAttributeInfo.isIs());
            }
        }
        return attrInfo;
    }

    private MBeanConstructorInfo[] getConstructorInfo() {
        Constructor<?>[] ctors = Log4jConfiguratorMBean.class.getConstructors();
        MBeanConstructorInfo[] ctorInfo = new MBeanConstructorInfo[ctors.length];
        try {
            for (int idx = 0; idx < ctors.length; ++idx) {
                ctorInfo[idx] = new MBeanConstructorInfo("Default c'tor", Log4jConfiguratorMBean.class.getConstructor(new Class[0]));
            }
        }
        catch (NoSuchMethodException e) {
            this.logging.error((Object)e);
        }
        return ctorInfo;
    }

    private MBeanOperationInfo[] getOperationInfo() {
        try {
            String description = "Sets the level for one ore more loggers.";
            MBeanParameterInfo p1 = new MBeanParameterInfo("NamePattern", String.class.getName(), "Regexp used to select the loggers, e.g. ^org.swisspush.*");
            MBeanParameterInfo p2 = new MBeanParameterInfo("Level", String.class.getName(), "New level (one of trace, debug, info, warn, error, fatal)");
            MBeanParameterInfo[] signature = new MBeanParameterInfo[]{p1, p2};
            String returnType = String.class.getName();
            MBeanOperationInfo anySetOp = new MBeanOperationInfo(SET_LOGGER_LEVEL_METHOD, description, signature, returnType, 1);
            return new MBeanOperationInfo[]{anySetOp};
        }
        catch (Exception e) {
            this.logging.error("Unable to expose method setLoggerLevel", (Throwable)e);
            return null;
        }
    }

    private MBeanNotificationInfo[] getNotificationInfo() {
        return null;
    }

    public String setLoggerLevel(String pattern, String level) {
        int modcount = 0;
        try {
            Pattern rep = Pattern.compile(pattern);
            Log4jConfigurator cnf = Log4jConfigurator.getInstance();
            List<String> loggers = cnf.getLoggers();
            for (String logger : loggers) {
                if (!rep.matcher(logger).matches()) continue;
                cnf.setLoggerLevel(logger, level);
                ++modcount;
            }
        }
        catch (PatternSyntaxException e) {
            this.logging.error("Invalid logger name pattern " + pattern, (Throwable)e);
        }
        Object msg = modcount == 0 ? "No logger matched the pattern" : (modcount == 1 ? "1 logger was modified" : modcount + " loggers were modified");
        return msg;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

