/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.logging;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.WriteStream;
import org.swisspush.gateleen.logging.LoggingHandler;

public class LoggingWriteStream
implements WriteStream<Buffer> {
    private final WriteStream<Buffer> wrappedWriteStream;
    private final LoggingHandler loggingHandler;
    private final boolean isRequest;

    public LoggingWriteStream(WriteStream<Buffer> wrappedWriteStream, LoggingHandler loggingHandler, boolean isRequest) {
        this.wrappedWriteStream = wrappedWriteStream;
        this.loggingHandler = loggingHandler;
        this.isRequest = isRequest;
    }

    public WriteStream<Buffer> exceptionHandler(Handler<Throwable> handler) {
        this.wrappedWriteStream.exceptionHandler(handler);
        return this;
    }

    public Future<Void> write(Buffer data) {
        this.write(data, (Handler<AsyncResult<Void>>)((Handler)event -> {}));
        return Future.succeededFuture();
    }

    public void write(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.wrappedWriteStream.write((Object)data);
        if (this.isRequest) {
            this.loggingHandler.appendRequestPayload(data);
        } else {
            this.loggingHandler.appendResponsePayload(data);
        }
    }

    public void end(Handler<AsyncResult<Void>> handler) {
        this.wrappedWriteStream.end();
    }

    public WriteStream<Buffer> setWriteQueueMaxSize(int maxSize) {
        this.wrappedWriteStream.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public boolean writeQueueFull() {
        return this.wrappedWriteStream.writeQueueFull();
    }

    public WriteStream<Buffer> drainHandler(Handler<Void> handler) {
        this.wrappedWriteStream.drainHandler(handler);
        return this;
    }
}

