/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.logging;

import io.vertx.core.MultiMap;
import io.vertx.core.eventbus.EventBus;
import java.io.Writer;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.StringLayout;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AbstractWriterAppender;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.appender.WriterManager;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.CloseShieldWriter;
import org.swisspush.gateleen.core.event.EventBusWriter;

@Plugin(name="Writer", category="Core", elementType="appender", printObject=true)
public class EventBusAppender
extends AbstractWriterAppender {
    private static WriterManagerFactory factory = new WriterManagerFactory();

    @PluginFactory
    public static EventBusAppender createAppender(StringLayout layout, Filter filter, String name, EventBus eventBus, String address, MultiMap deliveryOptionsHeaders, EventBusWriter.TransmissionMode transmissionMode, boolean follow, boolean ignore) {
        if (name == null) {
            LOGGER.error("No name provided for EventBusAppender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        EventBusWriter target = new EventBusWriter(eventBus, address, deliveryOptionsHeaders, transmissionMode);
        EventBusAppender appender = new EventBusAppender(name, layout, filter, EventBusAppender.getManager((Writer)target, follow, layout), ignore, null);
        appender.start();
        return appender;
    }

    private static WriterManager getManager(Writer target, boolean follow, StringLayout layout) {
        CloseShieldWriter writer = new CloseShieldWriter(target);
        String managerName = target.getClass().getName() + "@" + Integer.toHexString(target.hashCode()) + "." + follow;
        return WriterManager.getManager((String)managerName, (Object)new FactoryData((Writer)writer, managerName, layout), (ManagerFactory)factory);
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    private EventBusAppender(String name, StringLayout layout, Filter filter, WriterManager manager, boolean ignoreExceptions, Property[] properties) {
        super(name, layout, filter, ignoreExceptions, true, properties, manager);
    }

    private static class WriterManagerFactory
    implements ManagerFactory<WriterManager, FactoryData> {
        private WriterManagerFactory() {
        }

        public WriterManager createManager(String name, FactoryData data) {
            return new WriterManager(data.writer, data.name, data.layout, true);
        }
    }

    private static class FactoryData {
        private final StringLayout layout;
        private final String name;
        private final Writer writer;

        public FactoryData(Writer writer, String type, StringLayout layout) {
            this.writer = writer;
            this.name = type;
            this.layout = layout;
        }
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<EventBusAppender> {
        private static EventBus eventBus;
        private String address;
        private MultiMap deliveryOptionsHeaders;
        private EventBusWriter.TransmissionMode transmissionMode;

        public EventBusAppender build() {
            Layout layout = this.getOrCreateLayout();
            if (!(layout instanceof StringLayout)) {
                LOGGER.error("Layout must be a StringLayout to log to ServletContext");
                return null;
            }
            StringLayout stringLayout = (StringLayout)layout;
            EventBusWriter target = new EventBusWriter(eventBus, this.address, this.deliveryOptionsHeaders, this.transmissionMode);
            EventBusAppender appender = new EventBusAppender(this.getName(), stringLayout, this.getFilter(), EventBusAppender.getManager((Writer)target, false, stringLayout), this.isIgnoreExceptions(), this.getPropertyArray());
            appender.start();
            return appender;
        }

        public static void setEventBus(EventBus eventBus) {
            Builder.eventBus = eventBus;
        }

        public B setAddress(String address) {
            this.address = address;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setDeliveryOptionsHeaders(MultiMap deliveryOptionsHeaders) {
            this.deliveryOptionsHeaders = deliveryOptionsHeaders;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setTransmissionMode(EventBusWriter.TransmissionMode transmissionMode) {
            this.transmissionMode = transmissionMode;
            return (B)((Object)((Builder)this.asBuilder()));
        }
    }
}

