/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.logging;

import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.TimeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.slf4j.Logger;
import org.swisspush.gateleen.core.event.EventBusWriter;
import org.swisspush.gateleen.core.http.RequestLoggerFactory;
import org.swisspush.gateleen.logging.EventBusAppender;
import org.swisspush.gateleen.logging.FilterResult;
import org.swisspush.gateleen.logging.LogAppenderRepository;
import org.swisspush.gateleen.logging.LoggingResource;
import org.swisspush.gateleen.logging.LoggingResourceManager;
import org.swisspush.gateleen.logging.RequestPropertyFilter;

public class LoggingHandler {
    private HttpServerRequest request;
    private MultiMap requestHeaders;
    private HttpClientResponse response;
    private boolean active = false;
    private Buffer requestPayload;
    private Buffer responsePayload;
    private LoggingResource loggingResource;
    private EventBus eventBus;
    private LogAppenderRepository logAppenderRepository;
    private String currentDestination;
    private static final String LOGGING_DIR_PROPERTY = "org.swisspush.logging.dir";
    private static final String CONTENT_TYPE = "content-type";
    private static final String APPLICATION_JSON = "application/json";
    private static final String DEFAULT_LOGGER = "RequestLog";
    private static final String REJECT = "reject";
    private static final String DESTINATION = "destination";
    private static final String DESCRIPTION = "description";
    private static final String META_DATA = "metadata";
    private static final String TRANSMISSION = "transmission";
    private static final String URL = "url";
    private static final String METHOD = "method";
    private static final String STATUS_CODE = "statusCode";
    private static final String STATUS_MESSAGE = "statusMessage";
    private static final String REQUEST = "request";
    private static final String RESPONSE = "response";
    private static final String HEADERS = "headers";
    private static final String BODY = "body";
    private static final String FILE = "file";
    private static final String ADDRESS = "address";
    private static final String DEFAULT = "default";
    private Map<String, org.apache.logging.log4j.Logger> loggers = new HashMap<String, org.apache.logging.log4j.Logger>();
    private Logger log;

    public LoggingHandler(LoggingResourceManager loggingResourceManager, LogAppenderRepository logAppenderRepository, HttpServerRequest request, EventBus eventBus) {
        this.logAppenderRepository = logAppenderRepository;
        this.request = request;
        this.eventBus = eventBus;
        this.loggingResource = loggingResourceManager.getLoggingResource();
        this.log = RequestLoggerFactory.getLogger(LoggingHandler.class, (HttpServerRequest)request);
        ((org.apache.logging.log4j.core.Logger)LogManager.getLogger((String)DEFAULT_LOGGER)).setAdditive(false);
        boolean stopValidation = false;
        block0: for (Map<String, String> payloadFilter : this.loggingResource.getPayloadFilters()) {
            if (this.active || stopValidation) break;
            ArrayList<Map.Entry<String, String>> payloadFilterEntrySetList = new ArrayList<Map.Entry<String, String>>();
            for (Map.Entry<String, String> filterEntry : payloadFilter.entrySet()) {
                if (filterEntry.getKey().equalsIgnoreCase(URL)) {
                    payloadFilterEntrySetList.add(0, filterEntry);
                    continue;
                }
                payloadFilterEntrySetList.add(filterEntry);
            }
            boolean reject = Boolean.parseBoolean(payloadFilter.get(REJECT));
            for (Map.Entry entry : payloadFilterEntrySetList) {
                if (REJECT.equalsIgnoreCase((String)entry.getKey()) || DESTINATION.equalsIgnoreCase((String)entry.getKey()) || DESCRIPTION.equalsIgnoreCase((String)entry.getKey())) continue;
                FilterResult result = RequestPropertyFilter.filterProperty(request, (String)entry.getKey(), (String)entry.getValue(), reject);
                if (result == FilterResult.FILTER) {
                    this.active = true;
                    this.currentDestination = this.createLoggerAndGetDestination(payloadFilter);
                    continue;
                }
                if (result == FilterResult.REJECT) {
                    this.active = false;
                    stopValidation = true;
                    continue block0;
                }
                if (result != FilterResult.NO_MATCH) continue;
                this.active = false;
                continue block0;
            }
        }
    }

    public boolean isActive() {
        return this.active;
    }

    private String createLoggerAndGetDestination(Map<String, String> payloadFilter) {
        String filterDestination = payloadFilter.get(DESTINATION);
        if (filterDestination == null) {
            this.log.debug("no filterDestination set");
            filterDestination = DEFAULT;
        }
        if (this.loggingResource.getDestinationEntries().containsKey(filterDestination)) {
            Map<String, String> destinationOptions = this.loggingResource.getDestinationEntries().get(filterDestination);
            Appender appender = null;
            if (destinationOptions.containsKey(FILE)) {
                this.log.debug("found destination entry with type 'file' for: {}", (Object)filterDestination);
                appender = this.getFileAppender(filterDestination, destinationOptions.get(FILE));
            } else if (destinationOptions.containsKey(ADDRESS)) {
                this.log.debug("found destination entry with type 'eventBus' for: {}", (Object)filterDestination);
                appender = this.getEventBusAppender(filterDestination, destinationOptions);
            } else {
                this.log.warn("Unknown typeLocation for destination: {}", (Object)filterDestination);
            }
            if (appender != null) {
                if (!this.loggers.containsKey(filterDestination)) {
                    org.apache.logging.log4j.Logger filterLogger = LogManager.getLogger((String)("LOG_FILTER_" + payloadFilter.get(URL)));
                    ((org.apache.logging.log4j.core.Logger)filterLogger).addAppender(appender);
                    ((org.apache.logging.log4j.core.Logger)filterLogger).setAdditive(false);
                    this.loggers.put(filterDestination, filterLogger);
                }
            } else {
                this.loggers.put(filterDestination, LogManager.getLogger((String)DEFAULT_LOGGER));
            }
        } else {
            if (!filterDestination.equals(DEFAULT)) {
                this.log.warn("no destination entry with name '{}' found, using default logger instead", (Object)filterDestination);
            }
            this.loggers.put(filterDestination, LogManager.getLogger((String)DEFAULT_LOGGER));
        }
        return filterDestination;
    }

    private Appender getEventBusAppender(String filterDestination, Map<String, String> destinationOptions) {
        if (!this.logAppenderRepository.hasAppender(filterDestination)) {
            EventBusAppender.Builder.setEventBus(this.eventBus);
            EventBusAppender appender = ((EventBusAppender.Builder)((EventBusAppender.Builder)((Object)((EventBusAppender.Builder)((Object)((EventBusAppender.Builder)EventBusAppender.newBuilder().setName(filterDestination)).setAddress(destinationOptions.get(ADDRESS)))).setDeliveryOptionsHeaders(MultiMap.caseInsensitiveMultiMap().add(META_DATA, destinationOptions.get(META_DATA))))).setTransmissionMode(EventBusWriter.TransmissionMode.fromString((String)destinationOptions.get(TRANSMISSION))).setLayout((Layout)PatternLayout.createDefaultLayout())).build();
            this.logAppenderRepository.addAppender(filterDestination, (Appender)appender);
        }
        return this.logAppenderRepository.getAppender(filterDestination);
    }

    private Appender getFileAppender(String filterDestination, String fileName) {
        if (!this.logAppenderRepository.hasAppender(filterDestination)) {
            this.log.debug("file path: {}", (Object)(System.getProperty(LOGGING_DIR_PROPERTY) + fileName));
            RollingFileAppender.Builder builder = RollingFileAppender.newBuilder().withPolicy((TriggeringPolicy)new TimeBasedTriggeringPolicy.Builder().withInterval(1).build());
            builder.setName(filterDestination);
            builder.withFileName(System.getProperty(LOGGING_DIR_PROPERTY) + fileName);
            builder.withAppend(true);
            PatternLayout layout = PatternLayout.createDefaultLayout();
            builder.setLayout((Layout)layout);
            this.logAppenderRepository.addAppender(filterDestination, (Appender)builder.build());
        }
        return this.logAppenderRepository.getAppender(filterDestination);
    }

    public void setResponse(HttpClientResponse response) {
        this.response = response;
    }

    public void request(MultiMap headers) {
        this.requestHeaders = headers;
    }

    public void appendRequestPayload(Buffer data) {
        this.appendRequestPayload(data, this.request.headers());
    }

    public void appendResponsePayload(Buffer data) {
        this.appendResponsePayload(data, this.response.headers());
    }

    public void appendRequestPayload(Buffer data, MultiMap headers) {
        if (this.active && this.isJsonContent(headers)) {
            this.getRequestPayload().appendBuffer(data);
        }
    }

    public void appendResponsePayload(Buffer data, MultiMap headers) {
        if (this.active && this.isJsonContent(headers)) {
            this.getResponsePayload().appendBuffer(data);
        }
    }

    public void log() {
        this.log(this.request.uri(), this.request.method(), this.response.statusCode(), this.response.statusMessage(), this.requestHeaders, this.response.headers());
    }

    public void log(String uri, HttpMethod method, int statusCode, String statusMessage, MultiMap requestHeaders, MultiMap responseHeaders) {
        if (this.active) {
            this.log.info("request is going to be logged");
            JsonObject logEvent = new JsonObject().put(URL, (Object)uri).put(METHOD, (Object)method.name()).put(STATUS_CODE, (Object)statusCode).put(STATUS_MESSAGE, (Object)statusMessage);
            JsonObject requestLog = new JsonObject();
            JsonObject responseLog = new JsonObject();
            logEvent.put(REQUEST, (Object)requestLog);
            logEvent.put(RESPONSE, (Object)responseLog);
            requestLog.put(HEADERS, (Object)this.headersAsJson(requestHeaders));
            responseLog.put(HEADERS, (Object)this.headersAsJson(responseHeaders));
            if (this.requestPayload != null) {
                try {
                    requestLog.put(BODY, (Object)new JsonObject(this.requestPayload));
                }
                catch (DecodeException e) {
                    try {
                        requestLog.put(BODY, (Object)new JsonArray(this.requestPayload));
                    }
                    catch (DecodeException ex) {
                        this.log.info("request payload could not be parsed and will not be logged");
                    }
                }
            }
            if (this.responsePayload != null) {
                String responsePayloadString = this.responsePayload.toString("UTF-8");
                try {
                    responseLog.put(BODY, (Object)new JsonObject(responsePayloadString));
                }
                catch (DecodeException e) {
                    try {
                        responseLog.put(BODY, (Object)new JsonArray(responsePayloadString));
                    }
                    catch (DecodeException ex) {
                        this.log.info("response payload could not be parsed and will not be logged");
                    }
                }
            }
            try {
                this.aboutToLogRequest(this.currentDestination);
                this.loggers.get(this.currentDestination).info(logEvent.encode());
            }
            catch (Exception ex) {
                this.errorLogRequest(this.currentDestination, ex);
            }
        } else {
            this.log.info("request will not be logged");
        }
    }

    private void aboutToLogRequest(String currentDestination) {
        this.log.info("About to log to destination {}", (Object)currentDestination);
    }

    private void errorLogRequest(String currentDestination, Exception ex) {
        this.log.error("Error logging to destination {}. Cause: {}", (Object)currentDestination, (Object)ex.toString());
    }

    private JsonObject headersAsJson(MultiMap headers) {
        JsonObject obj = new JsonObject();
        switch (this.loggingResource.getHeaderLogStrategy()) {
            case LOG_ALL: {
                for (Map.Entry entry : headers) {
                    String key = ((String)entry.getKey()).toLowerCase();
                    obj.put(key, entry.getValue());
                }
                break;
            }
            case LOG_LIST: {
                for (String header : this.loggingResource.getHeaders()) {
                    String value = headers.get(header);
                    if (value == null) continue;
                    obj.put(header, (Object)value);
                }
                break;
            }
            case LOG_NONE: {
                return obj;
            }
            default: {
                this.loggers.get(this.currentDestination).warn("Unsupported HeaderLogStrategy '" + this.loggingResource.getHeaderLogStrategy() + "' used. Log nothing!");
            }
        }
        return obj;
    }

    private Buffer getRequestPayload() {
        if (this.requestPayload == null) {
            this.requestPayload = Buffer.buffer();
        }
        return this.requestPayload;
    }

    private Buffer getResponsePayload() {
        if (this.responsePayload == null) {
            this.responsePayload = Buffer.buffer();
        }
        return this.responsePayload;
    }

    private boolean isJsonContent(MultiMap headers) {
        return headers.contains(CONTENT_TYPE) && headers.get(CONTENT_TYPE).contains(APPLICATION_JSON);
    }
}

