/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.logging;

import io.vertx.core.Vertx;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.core.Appender;
import org.swisspush.gateleen.logging.LogAppenderRepository;

public class DefaultLogAppenderRepository
implements LogAppenderRepository {
    private Map<String, Appender> appenderMap = new HashMap<String, Appender>();

    public DefaultLogAppenderRepository(Vertx vertx) {
        vertx.eventBus().consumer("gateleen.logging-updated", event -> this.clearRepository());
    }

    @Override
    public boolean hasAppender(String name) {
        return this.appenderMap.containsKey(name);
    }

    @Override
    public void addAppender(String name, Appender appender) {
        this.appenderMap.put(name, appender);
    }

    @Override
    public Appender getAppender(String name) {
        return this.appenderMap.get(name);
    }

    @Override
    public void clearRepository() {
        this.appenderMap.clear();
    }
}

