/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.merge;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.util.CollectionContentComparator;
import org.swisspush.gateleen.core.util.ExpansionDeltaUtil;
import org.swisspush.gateleen.core.util.HttpServerRequestUtil;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.merge.MergeData;

public class MergeHandler {
    private static Logger log = LoggerFactory.getLogger(MergeHandler.class);
    public static final String MISSMATCH_ERROR = "Resources as well as collections with the given name were found.";
    private static final String MERGE_HEADER = "x-merge-collections";
    private static final String SELF_REQUEST_HEADER = "x-self-request";
    private static final int NO_PARAMETER_FOUND = -1;
    private static final int TIMEOUT = 120000;
    private static final String SLASH = "/";
    private final HttpClient httpClient;
    private final Comparator<String> collectionContentComparator;

    public MergeHandler(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.collectionContentComparator = new CollectionContentComparator();
    }

    public boolean handle(HttpServerRequest request) {
        String mergeCollection = request.getHeader(MERGE_HEADER);
        if (mergeCollection != null && request.method().equals((Object)HttpMethod.GET)) {
            HttpClientRequest cReq = this.httpClient.request(HttpMethod.GET, mergeCollection, cRes -> {
                if (cRes.statusCode() == StatusCode.OK.getStatusCode()) {
                    String collectionName = this.getCollectionName(mergeCollection);
                    String targetUrlPart = this.getTargetUrlPart(request.path());
                    if (log.isTraceEnabled()) {
                        log.trace("handle > (mergeCollection) {}, (collectionName) {}, (targetUrlPart) {}", new Object[]{mergeCollection, collectionName, targetUrlPart});
                    }
                    cRes.handler(data -> {
                        JsonObject dataObject = new JsonObject(data.toString());
                        if (log.isTraceEnabled()) {
                            log.trace(" >> body is \"{}\"", (Object)dataObject.toString());
                        }
                        if (dataObject.getValue(collectionName) instanceof JsonArray) {
                            List<String> collections = this.getCollections(dataObject.getJsonArray(collectionName));
                            Handler<MergeData> mergeCollectionHandler = this.installMergeCollectionHandler(request, collections.size(), targetUrlPart);
                            for (String collection : collections) {
                                if (log.isTraceEnabled()) {
                                    log.trace("requestCollection {}", (Object)collection);
                                }
                                this.requestCollection(request, mergeCollection, collection, request.path(), mergeCollectionHandler);
                            }
                        } else {
                            request.response().end(dataObject.toBuffer());
                        }
                    });
                } else {
                    request.response().setChunked(true);
                    cRes.handler(data -> request.response().write(data));
                    cRes.endHandler(v -> request.response().end());
                }
            });
            cReq.setTimeout(120000L);
            cReq.headers().set("Accept", "application/json");
            cReq.headers().set(SELF_REQUEST_HEADER, "true");
            cReq.setChunked(true);
            cReq.exceptionHandler(ExpansionDeltaUtil.createRequestExceptionHandler((HttpServerRequest)request, (String)mergeCollection, MergeHandler.class));
            cReq.end();
            return true;
        }
        return false;
    }

    private void requestCollection(HttpServerRequest request, String mergeCollection, String collection, String path, Handler<MergeData> mergeCollectionHandler) {
        String requestUrl = mergeCollection + collection + (path.startsWith(SLASH) ? path.substring(path.indexOf(SLASH) + 1, path.length()) : path);
        String parentUrl = this.prepareParentCollection(requestUrl);
        String targetUrlPart = this.getTargetUrlPart(requestUrl);
        if (log.isTraceEnabled()) {
            log.trace("requestCollection > (requestUrl)" + requestUrl + " (parentUrl) " + parentUrl + " (targetUrlPart) " + targetUrlPart);
        }
        HttpClientRequest collectionRequest = this.httpClient.request(HttpMethod.GET, parentUrl, collectionResponse -> {
            collectionResponse.exceptionHandler(ExpansionDeltaUtil.createRequestExceptionHandler((HttpServerRequest)request, (String)parentUrl, MergeHandler.class));
            if (collectionResponse.statusCode() == StatusCode.OK.getStatusCode()) {
                String parentCollection = this.getCollectionName(parentUrl);
                collectionResponse.bodyHandler(data -> {
                    String collectionName = parentCollection;
                    JsonObject dataObject = new JsonObject(data.toString());
                    if (!dataObject.containsKey(collectionName) && dataObject.size() == 1) {
                        collectionName = (String)dataObject.fieldNames().stream().findFirst().get();
                        if (log.isTraceEnabled()) {
                            log.trace("   >>> collection {} could not be found, use instead key: {}", (Object)parentCollection, (Object)collectionName);
                        }
                    }
                    if (log.isTraceEnabled()) {
                        log.trace("requestCollection >> uri is: {}, body is: {}", (Object)parentUrl, (Object)data.toString());
                    }
                    if (dataObject.getValue(collectionName) instanceof JsonArray) {
                        List<String> collectionContent = this.getCollectionContent(dataObject.getJsonArray(collectionName));
                        if (collectionContent.contains(targetUrlPart + SLASH)) {
                            mergeCollectionHandler.handle((Object)new MergeData((Buffer)data, collectionResponse.statusCode(), collectionResponse.statusMessage(), true, requestUrl));
                        } else if (collectionContent.contains(targetUrlPart)) {
                            mergeCollectionHandler.handle((Object)new MergeData((Buffer)data, collectionResponse.statusCode(), collectionResponse.statusMessage(), false, requestUrl));
                        } else {
                            mergeCollectionHandler.handle((Object)new MergeData((Buffer)data, StatusCode.NOT_FOUND.getStatusCode(), StatusCode.NOT_FOUND.getStatusMessage(), false, requestUrl));
                        }
                    } else {
                        if (log.isTraceEnabled()) {
                            log.trace("requestCollection >> given array was not found");
                        }
                        mergeCollectionHandler.handle((Object)new MergeData((Buffer)data, StatusCode.NOT_FOUND.getStatusCode(), StatusCode.NOT_FOUND.getStatusMessage(), false, requestUrl));
                    }
                });
            } else {
                collectionResponse.handler(data -> mergeCollectionHandler.handle((Object)new MergeData((Buffer)data, collectionResponse.statusCode(), collectionResponse.statusMessage(), false, requestUrl)));
            }
        });
        collectionRequest.setTimeout(120000L);
        collectionRequest.headers().set("Accept", "application/json");
        collectionRequest.headers().set(SELF_REQUEST_HEADER, "true");
        collectionRequest.setChunked(true);
        collectionRequest.exceptionHandler(ExpansionDeltaUtil.createRequestExceptionHandler((HttpServerRequest)request, (String)parentUrl, MergeHandler.class));
        collectionRequest.end();
    }

    private List<String> getCollections(JsonArray array) {
        return array.getList().stream().map(r -> (String)r).filter(r -> r.endsWith(SLASH)).collect(Collectors.toList());
    }

    private List<String> getCollectionContent(JsonArray array) {
        return array.getList().stream().map(r -> (String)r).collect(Collectors.toList());
    }

    private Handler<MergeData> installMergeCollectionHandler(final HttpServerRequest request, final int subResourcesCount, final String targetUrlPart) {
        return new Handler<MergeData>(){
            private final List<MergeData> collectedData = new ArrayList<MergeData>();
            private final int totalCollectionCount = subResourcesCount;

            public void handle(MergeData subCollectionData) {
                if (log.isTraceEnabled()) {
                    log.trace("mergeCollectionHandler - handle (count: {}) > {}", (Object)this.totalCollectionCount, (Object)subCollectionData.getTargetRequest());
                    log.trace(" >>> data: {}", (Object)subCollectionData.getContent().toString());
                }
                this.collectedData.add(subCollectionData);
                if (this.collectedData.size() == this.totalCollectionCount) {
                    if (log.isTraceEnabled()) {
                        log.trace("mergeCollectionHandler - handle > list complete, start processing");
                    }
                    MergeData error = null;
                    int found = 0;
                    int collectionCount = 0;
                    int resourceCount = 0;
                    int notFound = 0;
                    for (MergeData data : this.collectedData) {
                        if (data.getStatusCode() == StatusCode.OK.getStatusCode()) {
                            ++found;
                            if (data.isTargetCollection()) {
                                ++collectionCount;
                                continue;
                            }
                            ++resourceCount;
                            continue;
                        }
                        if (data.getStatusCode() == StatusCode.NOT_FOUND.getStatusCode()) {
                            ++notFound;
                            continue;
                        }
                        error = data;
                        break;
                    }
                    if (log.isTraceEnabled()) {
                        log.trace("mergeCollectionHandler - handle > error {}, found {}, collectionCount {}, resourceCount {}, notFound {}", new Object[]{error, found, collectionCount, resourceCount, notFound});
                    }
                    if (error == null) {
                        if (log.isTraceEnabled()) {
                            log.trace("mergeCollectionHandler - handle > no errors found");
                        }
                        if (notFound == this.totalCollectionCount) {
                            if (log.isTraceEnabled()) {
                                log.trace("mergeCollectionHandler - handle > nothing found");
                            }
                            MergeHandler.this.createResponse(request, StatusCode.NOT_FOUND.getStatusCode(), StatusCode.NOT_FOUND.getStatusMessage(), null, null);
                        } else if (found == collectionCount && !this.collectedData.isEmpty()) {
                            if (log.isTraceEnabled()) {
                                log.trace("mergeCollectionHandler - handle > performMergeRequest");
                            }
                            List subCollectionsToRequest = this.collectedData.stream().filter(cData -> cData.getStatusCode() == StatusCode.OK.getStatusCode() && cData.isTargetCollection()).collect(Collectors.toList());
                            Handler mergeRequestHandler = MergeHandler.this.installMergeRequestHandler(request, subCollectionsToRequest.size(), targetUrlPart);
                            for (MergeData data : subCollectionsToRequest) {
                                MergeHandler.this.performMergeRequest(request, data, (Handler<MergeData>)mergeRequestHandler);
                            }
                        } else if (found == resourceCount && !this.collectedData.isEmpty()) {
                            if (log.isTraceEnabled()) {
                                log.trace("mergeCollectionHandler - handle > performDirectRequest");
                            }
                            MergeData resource = this.collectedData.stream().filter(cData -> cData.getStatusCode() == StatusCode.OK.getStatusCode() && !cData.isTargetCollection()).findFirst().get();
                            MergeHandler.this.performDirectRequest(request, resource);
                        } else {
                            if (log.isTraceEnabled()) {
                                log.trace("mergeCollectionHandler - handle > createResponse (missmatch)");
                            }
                            MergeHandler.this.createResponse(request, StatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), StatusCode.INTERNAL_SERVER_ERROR.getStatusMessage(), null, MergeHandler.MISSMATCH_ERROR);
                        }
                    } else {
                        if (log.isTraceEnabled()) {
                            log.trace("mergeCollectionHandler - handle > createResponse (error)");
                        }
                        MergeHandler.this.createResponse(request, error.getStatusCode(), error.getStatusMessage(), error.getContent(), null);
                    }
                }
            }
        };
    }

    private void performMergeRequest(HttpServerRequest request, MergeData data, Handler<MergeData> mergeRequestHandler) {
        String uri = data.getTargetRequest() + this.getParameters(request.uri());
        if (log.isTraceEnabled()) {
            log.trace("performMergeRequest > {}, {}", (Object)data.getTargetRequest(), (Object)uri);
        }
        HttpClientRequest mergeRequest = this.httpClient.request(HttpMethod.GET, uri, res -> {
            res.exceptionHandler(ExpansionDeltaUtil.createRequestExceptionHandler((HttpServerRequest)request, (String)data.getTargetRequest(), MergeHandler.class));
            res.bodyHandler(buffer -> mergeRequestHandler.handle((Object)new MergeData((Buffer)buffer, res.statusCode(), res.statusMessage(), true, data.getTargetRequest())));
        });
        mergeRequest.setTimeout(120000L);
        mergeRequest.headers().addAll(request.headers());
        mergeRequest.headers().set(SELF_REQUEST_HEADER, "true");
        mergeRequest.headers().remove(MERGE_HEADER);
        mergeRequest.setChunked(true);
        mergeRequest.exceptionHandler(ExpansionDeltaUtil.createRequestExceptionHandler((HttpServerRequest)request, (String)data.getTargetRequest(), MergeHandler.class));
        mergeRequest.end();
    }

    private Handler<MergeData> installMergeRequestHandler(final HttpServerRequest request, final int size, final String targetUrlPart) {
        return new Handler<MergeData>(){
            private final List<MergeData> collectedData = new ArrayList<MergeData>();

            public void handle(MergeData requestData) {
                this.collectedData.add(requestData);
                if (this.collectedData.size() == size) {
                    if (log.isTraceEnabled()) {
                        log.trace("installMergeRequestHandler > process started");
                    }
                    MergeData error = null;
                    for (MergeData data : this.collectedData) {
                        if (data.getStatusCode() == StatusCode.OK.getStatusCode() || data.getStatusCode() == StatusCode.NOT_FOUND.getStatusCode()) continue;
                        error = data;
                        break;
                    }
                    if (error == null) {
                        List validData;
                        if (log.isTraceEnabled()) {
                            log.trace("installMergeRequestHandler > no error found");
                        }
                        if (!(validData = this.collectedData.stream().filter(cData -> cData.getStatusCode() == StatusCode.OK.getStatusCode()).collect(Collectors.toList())).isEmpty()) {
                            if (log.isTraceEnabled()) {
                                log.trace("installMergeRequestHandler > createMergedResponse");
                            }
                            MergeHandler.this.createMergedResponse(request, targetUrlPart, validData);
                        } else {
                            if (log.isTraceEnabled()) {
                                log.trace("installMergeRequestHandler > nothing found");
                            }
                            MergeHandler.this.createResponse(request, StatusCode.NOT_FOUND.getStatusCode(), StatusCode.NOT_FOUND.getStatusMessage(), null, null);
                        }
                    } else {
                        if (log.isTraceEnabled()) {
                            log.trace("installMergeRequestHandler > error");
                        }
                        MergeHandler.this.createResponse(request, error.getStatusCode(), error.getStatusMessage(), error.getContent(), null);
                    }
                }
            }
        };
    }

    private void createMergedResponse(HttpServerRequest request, String collectionName, List<MergeData> collectionData) {
        if (log.isTraceEnabled()) {
            log.trace("createMergedResponse > {}", (Object)collectionName);
        }
        HashSet<String> collectionContent = new HashSet<String>();
        for (MergeData data : collectionData) {
            JsonObject dataObject = new JsonObject(data.getContent().toString());
            if (log.isTraceEnabled()) {
                log.trace("createMergedResponse > loop - {}", (Object)dataObject.toString());
            }
            if (!(dataObject.getValue(collectionName) instanceof JsonArray)) continue;
            collectionContent.addAll(this.getCollectionContent(dataObject.getJsonArray(collectionName)));
        }
        JsonObject responseData = new JsonObject();
        ArrayList<String> sortedCollectionContent = new ArrayList<String>(collectionContent);
        sortedCollectionContent.sort(this.collectionContentComparator);
        responseData.put(collectionName, new JsonArray(sortedCollectionContent));
        CaseInsensitiveHeaders headers = new CaseInsensitiveHeaders();
        headers.add("Content-Type", "application/json");
        this.createResponse(request, StatusCode.OK.getStatusCode(), StatusCode.OK.getStatusMessage(), Buffer.buffer((String)responseData.toString()), null, (MultiMap)headers);
    }

    private void performDirectRequest(HttpServerRequest request, MergeData resourceData) {
        String uri = resourceData.getTargetRequest() + this.getParameters(request.uri());
        if (log.isTraceEnabled()) {
            log.trace("performDirectRequest > {}", (Object)uri);
        }
        HttpClientRequest directRequest = this.httpClient.request(HttpMethod.GET, uri, res -> {
            HttpServerRequestUtil.prepareResponse((HttpServerRequest)request, (HttpClientResponse)res);
            res.handler(data -> request.response().write(data));
            res.endHandler(data -> request.response().end());
        });
        directRequest.setTimeout(120000L);
        directRequest.headers().addAll(request.headers());
        directRequest.headers().set(SELF_REQUEST_HEADER, "true");
        directRequest.headers().remove(MERGE_HEADER);
        directRequest.setChunked(true);
        directRequest.exceptionHandler(ExpansionDeltaUtil.createRequestExceptionHandler((HttpServerRequest)request, (String)resourceData.getTargetRequest(), MergeHandler.class));
        directRequest.end();
    }

    private void createResponse(HttpServerRequest request, int statusCode, String statusMessage, Buffer data, String freetext, MultiMap headers) {
        if (log.isTraceEnabled()) {
            log.trace("createResponse - for -> {} with statusCode {}.", (Object)request.uri(), (Object)statusCode);
        }
        request.response().setStatusCode(statusCode);
        request.response().setStatusMessage(statusMessage);
        if (headers != null) {
            request.response().headers().addAll(headers);
        }
        request.response().setChunked(true);
        if (freetext != null) {
            request.response().end(freetext);
        } else if (data != null) {
            request.response().end(data);
        } else {
            request.response().end();
        }
    }

    private void createResponse(HttpServerRequest request, int statusCode, String statusMessage, Buffer data, String freetext) {
        this.createResponse(request, statusCode, statusMessage, data, freetext, null);
    }

    private String getTargetUrlPart(String requestUrl) {
        if (requestUrl.endsWith(SLASH)) {
            requestUrl = requestUrl.substring(0, requestUrl.lastIndexOf(SLASH));
        }
        return requestUrl.substring(requestUrl.lastIndexOf(SLASH) + 1, requestUrl.length());
    }

    private String prepareParentCollection(String collection) {
        if (collection.endsWith(SLASH)) {
            collection = collection.substring(0, collection.lastIndexOf(SLASH));
        }
        return collection.substring(0, collection.lastIndexOf(47) + 1);
    }

    private String getCollectionName(String url) {
        if (url.endsWith(SLASH)) {
            url = url.substring(0, url.lastIndexOf(SLASH));
        }
        return url.substring(url.lastIndexOf(SLASH) + 1, url.length());
    }

    private String getParameters(String uri) {
        int parameterIndex = uri.lastIndexOf(63);
        if (parameterIndex == -1) {
            return "";
        }
        return uri.substring(parameterIndex, uri.length());
    }
}

