/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.monitoring;

import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.monitoring.ResetMetricsMBean;

public class ResetMetrics
implements ResetMetricsMBean {
    private Vertx vertx;
    private String prefix;
    private String monitoringAddress;
    private static Logger log = LoggerFactory.getLogger(ResetMetrics.class);

    public ResetMetrics(Vertx vertx, String prefix, String monitoringAddress) {
        this.vertx = vertx;
        this.prefix = prefix;
        this.monitoringAddress = monitoringAddress;
    }

    @Override
    public void resetLastUsedQueueSizeInformation() {
        this.removeMetric(this.prefix + "queues.last.size");
    }

    @Override
    public void resetRequestsFromClientsToCrushCount() {
        this.removeMetric(this.prefix + "requests.localhost");
    }

    @Override
    public void resetRequestsFromCrushToBackendsCount() {
        this.removeMetric(this.prefix + "requests.backends");
    }

    @Override
    public void resetMetricByName(String mBeanName) {
        this.removeMetric(mBeanName);
    }

    private void removeMetric(String metric) {
        log.debug("About to reset '" + metric + "' (triggered by an operation from MBean) by sending message to monitoring address '" + this.monitoringAddress + "'");
        this.vertx.eventBus().send(this.monitoringAddress, (Object)new JsonObject().put("name", metric).put("action", "remove"), reply -> {
            if (reply.failed()) {
                log.error("Failed to remove value for metric '" + metric + "'. Cause: " + reply.cause().getMessage(), reply.cause());
            } else if (!"ok".equals(((JsonObject)((Message)reply.result()).body()).getString("status"))) {
                log.error("Removing value for metric '" + metric + "' resulted in status '" + ((JsonObject)((Message)reply.result()).body()).getString("status") + "'. Message: " + ((JsonObject)((Message)reply.result()).body()).getString("message"));
            } else {
                log.debug("Value for metric '" + metric + "' successfully removed");
            }
        });
    }
}

