/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.monitoring;

import com.google.common.collect.Ordering;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.Message;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.RedisClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.http.RequestLoggerFactory;
import org.swisspush.gateleen.core.storage.ResourceStorage;
import org.swisspush.gateleen.core.util.Address;
import org.swisspush.gateleen.core.util.HttpServerRequestUtil;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.core.util.StringUtils;
import org.swisspush.redisques.util.RedisquesAPI;

public class MonitoringHandler {
    public static final String METRIC_NAME = "name";
    public static final String METRIC_ACTION = "action";
    public static final String MARK = "mark";
    public static final String SET = "set";
    private Vertx vertx;
    private ResourceStorage storage;
    private boolean requestPerRuleMonitoringActive;
    private String requestPerRuleMonitoringProperty;
    private final String requestPerRuleMonitoringPath;
    private Map<String, Long> requestPerRuleMonitoringMap;
    private static Logger log = LoggerFactory.getLogger(MonitoringHandler.class);
    public static final String REQUESTS_CLIENT_NAME = "requests.localhost";
    public static final String REQUESTS_BACKENDS_NAME = "requests.backends";
    private static final String REQUESTS_INCOMING_NAME = "requests.incoming";
    public static final String PENDING_REQUESTS_METRIC = "requests.pending.count";
    public static final String ACTIVE_QUEUE_COUNT_METRIC = "queues.active.count";
    public static final String LAST_USED_QUEUE_SIZE_METRIC = "queues.last.size";
    public static final String ENQUEUE_METRIC = "queues.enqueue";
    public static final String DEQUEUE_METRIC = "queues.dequeue";
    public static final String LISTENER_COUNT_METRIC = "hooks.listener.count";
    public static final String ROUTE_COUNT_METRIC = "hooks.route.count";
    @Deprecated
    public static final String QUEUES_KEY_PREFIX = "redisques:queues";
    @Deprecated
    public static final int MAX_AGE_MILLISECONDS = 120000;
    private static final int QUEUE_SIZE_REFRESH_TIME = 5000;
    public static final String REQUEST_PER_RULE_PREFIX = "rpr.";
    public static final String REQUEST_PER_RULE_PROPERTY = "org.swisspush.request.rule.property";
    public static final String REQUEST_PER_RULE_SAMPLING_PROPERTY = "org.swisspush.request.rule.sampling";
    public static final String REQUEST_PER_RULE_EXPIRY_PROPERTY = "org.swisspush.request.rule.expiry";
    public static final long REQUEST_PER_RULE_DEFAULT_SAMPLING = 60000L;
    public static final long REQUEST_PER_RULE_DEFAULT_EXPIRY = 86400L;
    private final String UNKNOWN_VALUE = "unknown";
    private final String EXPIRE_AFTER_HEADER = "x-expire-after";
    private String prefix;
    private long requestPerRuleSampling;
    private long requestPerRuleExpiry;
    private final UUID uuid;

    @Deprecated
    public MonitoringHandler(Vertx vertx, RedisClient redisClient, ResourceStorage storage, String prefix) {
        this(vertx, storage, prefix);
        log.warn("Deprecated constructor used. This constructor should not be used anymore since it may be removed in future releases.");
    }

    @Deprecated
    public MonitoringHandler(Vertx vertx, RedisClient redisClient, ResourceStorage storage, String prefix, String requestPerRulePath) {
        this(vertx, storage, prefix, requestPerRulePath);
        log.warn("Deprecated constructor used. This constructor should not be used anymore since it may be removed in future releases.");
    }

    public MonitoringHandler(Vertx vertx, ResourceStorage storage, String prefix) {
        this(vertx, storage, prefix, null);
    }

    public MonitoringHandler(Vertx vertx, ResourceStorage storage, String prefix, String requestPerRulePath) {
        this.vertx = vertx;
        this.storage = storage;
        this.prefix = prefix;
        this.requestPerRuleMonitoringPath = this.initRequestPerRuleMonitoringPath(requestPerRulePath);
        this.uuid = UUID.randomUUID();
        this.registerQueueSizeTrackingTimer();
        this.initRequestPerRuleMonitoring();
        Logger metricLogger = LoggerFactory.getLogger((String)"Metrics");
        HashMap metricCache = new HashMap();
        HashMap lastDumps = new HashMap();
        vertx.eventBus().consumer(this.getMonitoringAddress(), message -> {
            JsonObject body = (JsonObject)message.body();
            String action = body.getString(METRIC_ACTION);
            String name = body.getString(METRIC_NAME);
            this.handleRequestPerRuleMessage(name);
            switch (action) {
                case "set": 
                case "update": {
                    Long currentValue = (Long)metricCache.get(name);
                    Long newValue = body.getLong("n");
                    Long lastDump = (Long)lastDumps.get(name);
                    long now = System.currentTimeMillis() / 1000L;
                    if (newValue.equals(currentValue) && (lastDump == null || lastDump >= now - 300L)) break;
                    metricLogger.info(name + " " + body.getLong("n") + " " + now);
                    metricCache.put(name, newValue);
                    lastDumps.put(name, now);
                }
            }
        });
    }

    protected String getMonitoringAddress() {
        return Address.monitoringAddress();
    }

    protected String getRedisquesAddress() {
        return Address.redisquesAddress();
    }

    public String getRequestPerRuleMonitoringPath() {
        return this.requestPerRuleMonitoringPath;
    }

    private String initRequestPerRuleMonitoringPath(String requestPerRuleMonitoringPath) {
        String str = StringUtils.trim((String)requestPerRuleMonitoringPath);
        if (StringUtils.isNotEmpty((CharSequence)str) && str.endsWith("/")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    private void handleRequestPerRuleMessage(String metricName) {
        if (StringUtils.isNotEmpty((CharSequence)metricName) && metricName.startsWith(this.prefix + REQUEST_PER_RULE_PREFIX)) {
            this.writeRequestPerRuleMonitoringMetricsToStorage(metricName.replaceAll(this.prefix + REQUEST_PER_RULE_PREFIX, ""));
        }
    }

    private void initRequestPerRuleMonitoring() {
        this.requestPerRuleMonitoringProperty = StringUtils.getStringOrEmpty((String)System.getProperty(REQUEST_PER_RULE_PROPERTY));
        if (StringUtils.isNotEmpty((CharSequence)this.requestPerRuleMonitoringProperty)) {
            this.requestPerRuleMonitoringActive = true;
            log.info("Activated request per rule monitoring for request header property '{}'", (Object)this.requestPerRuleMonitoringProperty);
            this.configureSamplingAndExpiry();
            this.registerRequestPerRuleMonitoringTimer();
        } else {
            this.requestPerRuleMonitoringActive = false;
            log.info("Request per rule monitoring not active since system property '{}' was not set (or empty)", (Object)REQUEST_PER_RULE_PROPERTY);
        }
    }

    public boolean isRequestPerRuleMonitoringActive() {
        return this.requestPerRuleMonitoringActive;
    }

    private Map<String, Long> getRequestPerRuleMonitoringMap() {
        if (this.requestPerRuleMonitoringMap == null) {
            this.requestPerRuleMonitoringMap = new HashMap<String, Long>();
        }
        return this.requestPerRuleMonitoringMap;
    }

    private void registerQueueSizeTrackingTimer() {
        this.vertx.setPeriodic(5000L, event -> this.updateQueueCountInformation());
    }

    private void registerRequestPerRuleMonitoringTimer() {
        this.vertx.setPeriodic(this.requestPerRuleSampling, event -> this.submitRequestPerRuleMonitoringMetrics());
    }

    private void configureSamplingAndExpiry() {
        String sampling = System.getProperty(REQUEST_PER_RULE_SAMPLING_PROPERTY, String.valueOf(60000L));
        String expiry = System.getProperty(REQUEST_PER_RULE_EXPIRY_PROPERTY, String.valueOf(86400L));
        try {
            this.requestPerRuleSampling = Long.parseLong(sampling);
            log.info("Initializing request per rule monitoring with a sampling rate of [ms] {}", (Object)this.requestPerRuleSampling);
        }
        catch (NumberFormatException ex) {
            log.warn("Unable to parse system property '{}'. Using default value instead: {}", (Object)REQUEST_PER_RULE_SAMPLING_PROPERTY, (Object)60000L);
            this.requestPerRuleSampling = 60000L;
        }
        try {
            this.requestPerRuleExpiry = Long.parseLong(expiry);
            log.info("Initializing request per rule monitoring with an expiry value of [ms] {}", (Object)this.requestPerRuleExpiry);
        }
        catch (NumberFormatException ex) {
            log.warn("Unable to parse system property '{}'. Using default value instead: {}", (Object)REQUEST_PER_RULE_EXPIRY_PROPERTY, (Object)86400L);
            this.requestPerRuleExpiry = 86400L;
        }
    }

    public long getRequestPerRuleSampling() {
        return this.requestPerRuleSampling;
    }

    public long getRequestPerRuleExpiry() {
        return this.requestPerRuleExpiry;
    }

    public void updateIncomingRequests(HttpServerRequest request) {
        if (!HttpServerRequestUtil.isRemoteAddressLoopbackAddress((HttpServerRequest)request) && this.shouldBeTracked(request.uri())) {
            this.vertx.eventBus().publish(this.getMonitoringAddress(), (Object)new JsonObject().put(METRIC_NAME, this.prefix + REQUESTS_INCOMING_NAME).put(METRIC_ACTION, MARK));
        }
    }

    public void updateRequestPerRuleMonitoring(HttpServerRequest request, String metricName) {
        if (this.isRequestPerRuleMonitoringActive()) {
            String headerValue = StringUtils.getStringOrDefault((String)request.getHeader(this.requestPerRuleMonitoringProperty), (String)"unknown");
            if (StringUtils.isNotEmptyTrimmed((String)metricName)) {
                String key = headerValue + "." + metricName;
                this.getRequestPerRuleMonitoringMap().merge(key, 1L, Long::sum);
            } else {
                Logger requestlog = RequestLoggerFactory.getLogger(MonitoringHandler.class, (HttpServerRequest)request);
                requestlog.warn("Request per rule monitoring is active but was called without a rule metricName. This request will be ignored.");
            }
        }
    }

    private void submitRequestPerRuleMonitoringMetrics() {
        log.info("About to send {} request per rule monitoring values to metrics", (Object)this.getRequestPerRuleMonitoringMap().size());
        Iterator<Map.Entry<String, Long>> it = this.getRequestPerRuleMonitoringMap().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Long> entry = it.next();
            this.vertx.eventBus().publish(this.getMonitoringAddress(), (Object)new JsonObject().put(METRIC_NAME, this.prefix + REQUEST_PER_RULE_PREFIX + entry.getKey()).put(METRIC_ACTION, SET).put("n", entry.getValue()));
            it.remove();
        }
    }

    private void writeRequestPerRuleMonitoringMetricsToStorage(String name) {
        if (StringUtils.isNotEmptyTrimmed((String)this.requestPerRuleMonitoringPath)) {
            String path = this.requestPerRuleMonitoringPath + "/" + this.uuid + "/" + name;
            JsonObject obj = new JsonObject().put("timestamp", Long.valueOf(System.currentTimeMillis()));
            MultiMap headers = new CaseInsensitiveHeaders().add("x-expire-after", String.valueOf(this.requestPerRuleExpiry));
            this.storage.put(path, headers, Buffer.buffer((String)obj.encode()), status -> {
                if (status.intValue() != StatusCode.OK.getStatusCode()) {
                    log.error("Error putting resource {} to storage", (Object)path);
                }
            });
        } else {
            log.warn("No path configured for the request per rule monitoring");
        }
    }

    public void updateRequestsMeter(String target, String uri) {
        if (this.shouldBeTracked(uri)) {
            if (this.isRequestToExternalTarget(target)) {
                this.vertx.eventBus().publish(this.getMonitoringAddress(), (Object)new JsonObject().put(METRIC_NAME, this.prefix + REQUESTS_BACKENDS_NAME).put(METRIC_ACTION, MARK));
            } else {
                this.vertx.eventBus().publish(this.getMonitoringAddress(), (Object)new JsonObject().put(METRIC_NAME, this.prefix + REQUESTS_CLIENT_NAME).put(METRIC_ACTION, MARK));
            }
        }
    }

    public long startRequestMetricTracking(String metricName, String targetUri) {
        long time = 0L;
        if (this.shouldBeTracked(targetUri)) {
            if (metricName != null) {
                time = System.nanoTime();
                this.vertx.eventBus().publish(this.getMonitoringAddress(), (Object)new JsonObject().put(METRIC_NAME, this.prefix + "routing." + metricName).put(METRIC_ACTION, MARK));
            }
            this.updatePendingRequestCount(true);
        }
        return time;
    }

    public void stopRequestMetricTracking(String metricName, long startTime, String targetUri) {
        if (this.shouldBeTracked(targetUri)) {
            if (metricName != null) {
                double duration = (double)(System.nanoTime() - startTime) / 1000000.0;
                this.vertx.eventBus().publish(this.getMonitoringAddress(), (Object)new JsonObject().put(METRIC_NAME, this.prefix + "routing." + metricName + ".duration").put(METRIC_ACTION, "update").put("n", Double.valueOf(duration)));
            }
            this.updatePendingRequestCount(false);
        }
    }

    private void updatePendingRequestCount(boolean incrementCount) {
        String action = incrementCount ? "inc" : "dec";
        log.trace("Updating count for pending requests: {} remaining", (Object)action);
        this.vertx.eventBus().publish(this.getMonitoringAddress(), (Object)new JsonObject().put(METRIC_NAME, this.prefix + PENDING_REQUESTS_METRIC).put(METRIC_ACTION, action));
    }

    public void updateQueueCountInformation() {
        this.vertx.eventBus().send(this.getRedisquesAddress(), (Object)RedisquesAPI.buildGetQueuesCountOperation(), reply -> {
            if (reply.succeeded() && "ok".equals(((JsonObject)((Message)reply.result()).body()).getString("status"))) {
                long count = ((JsonObject)((Message)reply.result()).body()).getLong("value");
                this.vertx.eventBus().publish(this.getMonitoringAddress(), (Object)new JsonObject().put(METRIC_NAME, this.prefix + ACTIVE_QUEUE_COUNT_METRIC).put(METRIC_ACTION, SET).put("n", Long.valueOf(count)));
            } else {
                log.error("Error gathering count of active queues");
            }
        });
    }

    public void updateLastUsedQueueSizeInformation(String queue) {
        log.trace("About to update last used Queue size counter");
        this.vertx.eventBus().send(this.getRedisquesAddress(), (Object)RedisquesAPI.buildGetQueueItemsCountOperation((String)queue), reply -> {
            if (reply.succeeded() && "ok".equals(((JsonObject)((Message)reply.result()).body()).getString("status"))) {
                long count = ((JsonObject)((Message)reply.result()).body()).getLong("value");
                this.vertx.eventBus().publish(this.getMonitoringAddress(), (Object)new JsonObject().put(METRIC_NAME, this.prefix + LAST_USED_QUEUE_SIZE_METRIC).put(METRIC_ACTION, "update").put("n", Long.valueOf(count)));
            } else {
                log.error("Error gathering queue size for queue '{}'", (Object)queue);
            }
        });
    }

    public void updateQueuesSizesInformation(int numQueues, boolean showEmptyQueues, MonitoringCallback callback) {
        JsonObject resultObject = new JsonObject();
        JsonArray queuesArray = new JsonArray();
        this.vertx.eventBus().send(this.getRedisquesAddress(), (Object)RedisquesAPI.buildGetQueuesOperation(), reply -> {
            if (reply.succeeded() && "ok".equals(((JsonObject)((Message)reply.result()).body()).getString("status"))) {
                List queueNames = ((JsonObject)((Message)reply.result()).body()).getJsonObject("value").getJsonArray("queues").getList();
                this.collectQueueLengths(queueNames, numQueues, showEmptyQueues, mapEntries -> {
                    for (Map.Entry entry : mapEntries) {
                        JsonObject obj = new JsonObject();
                        obj.put(METRIC_NAME, (String)entry.getKey());
                        obj.put("size", (Long)entry.getValue());
                        queuesArray.add(obj);
                    }
                    resultObject.put("queues", queuesArray);
                    callback.onDone(resultObject);
                });
            } else {
                String error = "Error gathering names of active queues";
                log.error(error);
                callback.onFail(error, StatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            }
        });
    }

    private void collectQueueLengths(List<String> queueNames, int numOfQueues, boolean showEmptyQueues, QueueLengthCollectingCallback callback) {
        TreeMap resultMap = new TreeMap();
        ArrayList<Map.Entry<String, Long>> mapEntryList = new ArrayList<Map.Entry<String, Long>>();
        AtomicInteger subCommandCount = new AtomicInteger(queueNames.size());
        if (!queueNames.isEmpty()) {
            for (String name : queueNames) {
                this.vertx.eventBus().send(this.getRedisquesAddress(), (Object)RedisquesAPI.buildGetQueueItemsCountOperation((String)name), reply -> {
                    subCommandCount.decrementAndGet();
                    if (reply.succeeded() && "ok".equals(((JsonObject)((Message)reply.result()).body()).getString("status"))) {
                        long count = ((JsonObject)((Message)reply.result()).body()).getLong("value");
                        if (showEmptyQueues || count > 0L) {
                            resultMap.put(name, count);
                        }
                    } else {
                        log.error("Error gathering size of queue {}", (Object)name);
                    }
                    if (subCommandCount.get() == 0) {
                        mapEntryList.addAll(resultMap.entrySet());
                        this.sortResultMap(mapEntryList);
                        int toIndex = numOfQueues > queueNames.size() ? queueNames.size() : numOfQueues;
                        toIndex = Math.min(mapEntryList.size(), toIndex);
                        callback.onDone(mapEntryList.subList(0, toIndex));
                    }
                });
            }
        } else {
            callback.onDone(mapEntryList);
        }
    }

    public void updateEnqueue() {
        this.vertx.eventBus().publish(this.getMonitoringAddress(), (Object)new JsonObject().put(METRIC_NAME, this.prefix + ENQUEUE_METRIC).put(METRIC_ACTION, MARK));
    }

    public void updateDequeue() {
        this.vertx.eventBus().publish(this.getMonitoringAddress(), (Object)new JsonObject().put(METRIC_NAME, this.prefix + DEQUEUE_METRIC).put(METRIC_ACTION, MARK));
    }

    public void updateListenerCount(long count) {
        this.vertx.eventBus().publish(this.getMonitoringAddress(), (Object)new JsonObject().put(METRIC_NAME, this.prefix + LISTENER_COUNT_METRIC).put(METRIC_ACTION, SET).put("n", Long.valueOf(count)));
    }

    public void updateRoutesCount(long count) {
        this.vertx.eventBus().publish(this.getMonitoringAddress(), (Object)new JsonObject().put(METRIC_NAME, this.prefix + ROUTE_COUNT_METRIC).put(METRIC_ACTION, SET).put("n", Long.valueOf(count)));
    }

    private void sortResultMap(List<Map.Entry<String, Long>> input) {
        Ordering<Map.Entry<String, Long>> byMapValues = new Ordering<Map.Entry<String, Long>>(){

            public int compare(Map.Entry<String, Long> left, Map.Entry<String, Long> right) {
                return left.getValue().compareTo(right.getValue());
            }
        };
        Collections.sort(input, byMapValues.reverse());
    }

    private boolean isRequestToExternalTarget(String target) {
        boolean isInternalRequest = false;
        if (target != null) {
            isInternalRequest = target.contains("localhost") || target.contains("127.0.0.1");
        }
        return !isInternalRequest;
    }

    private boolean shouldBeTracked(String uri) {
        return !uri.contains("/jmx/") && !uri.endsWith("cleanup");
    }

    private static interface QueueLengthCollectingCallback {
        public void onDone(List<Map.Entry<String, Long>> var1);
    }

    public static interface MonitoringCallback {
        public void onDone(JsonObject var1);

        public void onFail(String var1, int var2);
    }
}

