/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.monitoring;

import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.client.RedisAPI;
import io.vertx.redis.client.Response;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.util.Address;

public class RedisMonitor {
    private Vertx vertx;
    private RedisAPI redisAPI;
    private int period;
    private long timer;
    private Logger log = LoggerFactory.getLogger(RedisMonitor.class);
    private String prefix;
    private String metricName;
    private String elementCountKey;

    public RedisMonitor(Vertx vertx, RedisAPI redisAPI, String name, int period) {
        this.vertx = vertx;
        this.redisAPI = redisAPI;
        this.period = period * 1000;
        this.prefix = "redis." + name + ".";
    }

    public void start() {
        this.timer = this.vertx.setPeriodic((long)this.period, timer -> {
            this.redisAPI.info(new ArrayList(), reply -> {
                if (reply.succeeded()) {
                    this.collectMetrics(((Response)reply.result()).toBuffer());
                } else {
                    this.log.warn("Cannot collect INFO from redis");
                }
            });
            if (this.metricName != null && this.elementCountKey != null) {
                this.redisAPI.zcard(this.elementCountKey, reply -> {
                    if (reply.succeeded()) {
                        long value = ((Response)reply.result()).toLong();
                        this.vertx.eventBus().publish(this.getMonitoringAddress(), (Object)new JsonObject().put("name", (Object)(this.prefix + this.metricName)).put("action", (Object)"set").put("n", (Object)value));
                    } else {
                        this.log.warn("Cannot collect zcard from redis for key {}", (Object)this.elementCountKey);
                    }
                });
            }
        });
    }

    public void stop() {
        if (this.timer != 0L) {
            this.vertx.cancelTimer(this.timer);
        }
    }

    protected String getMonitoringAddress() {
        return Address.monitoringAddress();
    }

    public void enableElementCount(String metricName, String key) {
        this.metricName = metricName;
        this.elementCountKey = key;
    }

    private void collectMetrics(Buffer buffer) {
        try {
            JsonObject info = new JsonObject(buffer);
            for (String fieldName : info.fieldNames()) {
                Object field = info.getValue(fieldName);
                if (field instanceof JsonObject) {
                    for (String sectionFieldName : ((JsonObject)field).fieldNames()) {
                        if ("keyspace".equals(fieldName)) {
                            String[] pairs;
                            for (String pair : pairs = ((JsonObject)field).getString(sectionFieldName).split(",")) {
                                String[] tokens = pair.split("=");
                                this.sendMetric(fieldName + "." + sectionFieldName + "." + tokens[0], tokens[1]);
                            }
                            continue;
                        }
                        this.sendMetric(fieldName + "." + sectionFieldName, ((JsonObject)field).getString(sectionFieldName));
                    }
                    continue;
                }
                this.sendMetric(fieldName, field.toString());
            }
        }
        catch (DecodeException ex) {
            this.log.warn("Could not parse redis info", (Throwable)ex);
        }
    }

    private void sendMetric(String name, String stringValue) {
        if (stringValue == null) {
            return;
        }
        long value = 0L;
        try {
            value = name.contains("_cpu_") ? (long)(Double.parseDouble(stringValue) * 1000.0) : Long.parseLong(stringValue);
            this.vertx.eventBus().publish(this.getMonitoringAddress(), (Object)new JsonObject().put("name", (Object)(this.prefix + name)).put("action", (Object)"set").put("n", (Object)value));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

