/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.monitoring;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.redis.client.RedisAPI;
import io.vertx.redis.client.Response;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.util.Address;
import org.swisspush.gateleen.monitoring.EventBusMetricsPublisher;
import org.swisspush.gateleen.monitoring.MetricsPublisher;

public class RedisMonitor {
    private Vertx vertx;
    private RedisAPI redisAPI;
    private int period;
    private long timer;
    private Logger log = LoggerFactory.getLogger(RedisMonitor.class);
    private String prefix;
    private String metricName;
    private String elementCountKey;
    private static final String DELIMITER = ":";
    private final MetricsPublisher publisher;

    public RedisMonitor(Vertx vertx, RedisAPI redisAPI, String name, int period) {
        this(vertx, redisAPI, name, period, new EventBusMetricsPublisher(vertx, Address.monitoringAddress(), "redis." + name + "."));
    }

    public RedisMonitor(Vertx vertx, RedisAPI redisAPI, String name, int period, MetricsPublisher publisher) {
        this.vertx = vertx;
        this.redisAPI = redisAPI;
        this.period = period * 1000;
        this.prefix = "redis." + name + ".";
        this.publisher = publisher;
    }

    public void start() {
        this.timer = this.vertx.setPeriodic((long)this.period, timer -> {
            this.redisAPI.info(new ArrayList()).onComplete(event -> {
                if (event.succeeded()) {
                    this.collectMetrics(((Response)event.result()).toBuffer());
                } else {
                    this.log.warn("Cannot collect INFO from redis");
                }
            });
            if (this.metricName != null && this.elementCountKey != null) {
                this.redisAPI.zcard(this.elementCountKey, reply -> {
                    if (reply.succeeded()) {
                        long value = ((Response)reply.result()).toLong();
                        this.publisher.publishMetric(this.prefix + this.metricName, value);
                    } else {
                        this.log.warn("Cannot collect zcard from redis for key {}", (Object)this.elementCountKey);
                    }
                });
            }
        });
    }

    public void stop() {
        if (this.timer != 0L) {
            this.vertx.cancelTimer(this.timer);
        }
    }

    protected String getMonitoringAddress() {
        return Address.monitoringAddress();
    }

    public void enableElementCount(String metricName, String key) {
        this.metricName = metricName;
        this.elementCountKey = key;
    }

    private void collectMetrics(Buffer buffer) {
        Splitter.on((String)System.lineSeparator()).omitEmptyStrings().trimResults().splitToList((CharSequence)buffer.toString()).stream().filter(input -> input.contains(DELIMITER) && !input.contains("executable") && !input.contains("config_file")).collect(Collectors.toMap(new Function<String, Object>(){

            public @Nullable String apply(@Nullable String input) {
                return input.split(RedisMonitor.DELIMITER)[0];
            }
        }, c -> c.split(DELIMITER)[1])).forEach((keyObj, val) -> {
            String key = (String)keyObj;
            long value = 0L;
            try {
                if (key.startsWith("db")) {
                    String[] pairs;
                    for (String pair : pairs = val.split(",")) {
                        String[] tokens = pair.split("=");
                        if (tokens.length == 2) {
                            value = Long.parseLong(tokens[1]);
                            this.publisher.publishMetric("keyspace." + key + "." + tokens[0], value);
                            continue;
                        }
                        this.log.warn("Invalid keyspace property. Will be ignored");
                    }
                } else if (key.contains("_cpu_")) {
                    value = (long)(Double.parseDouble(val) * 1000.0);
                    this.publisher.publishMetric(key, value);
                } else if (key.contains("fragmentation_ratio")) {
                    value = (long)Double.parseDouble(val);
                    this.publisher.publishMetric(key, value);
                } else {
                    value = Long.parseLong(val);
                    this.publisher.publishMetric(key, value);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
    }
}

