/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.monitoring;

import com.google.common.base.Splitter;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.redis.client.RedisAPI;
import io.vertx.redis.client.Response;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.util.Address;
import org.swisspush.gateleen.monitoring.EventBusMetricsPublisher;
import org.swisspush.gateleen.monitoring.MetricsPublisher;

public class RedisMonitor {
    private Vertx vertx;
    private RedisAPI redisAPI;
    private int period;
    private long timer;
    private Logger log = LoggerFactory.getLogger(RedisMonitor.class);
    private String prefix;
    private String metricName;
    private String elementCountKey;
    private static final String DELIMITER = ":";
    private final MetricsPublisher publisher;

    public RedisMonitor(Vertx vertx, RedisAPI redisAPI, String name, int period) {
        this(vertx, redisAPI, name, period, new EventBusMetricsPublisher(vertx, Address.monitoringAddress(), "redis." + name + "."));
    }

    public RedisMonitor(Vertx vertx, RedisAPI redisAPI, String name, int period, MetricsPublisher publisher) {
        this.vertx = vertx;
        this.redisAPI = redisAPI;
        this.period = period * 1000;
        this.prefix = "redis." + name + ".";
        this.publisher = publisher;
    }

    public void start() {
        this.timer = this.vertx.setPeriodic((long)this.period, timer -> {
            this.redisAPI.info(new ArrayList()).onComplete(event -> {
                if (event.succeeded()) {
                    this.collectMetrics(((Response)event.result()).toBuffer());
                } else {
                    this.log.warn("Cannot collect INFO from redis");
                }
            });
            if (this.metricName != null && this.elementCountKey != null) {
                this.redisAPI.zcard(this.elementCountKey, reply -> {
                    if (reply.succeeded()) {
                        long value = ((Response)reply.result()).toLong();
                        this.publisher.publishMetric(this.prefix + this.metricName, value);
                    } else {
                        this.log.warn("Cannot collect zcard from redis for key {}", (Object)this.elementCountKey);
                    }
                });
            }
        });
    }

    public void stop() {
        if (this.timer != 0L) {
            this.vertx.cancelTimer(this.timer);
        }
    }

    protected String getMonitoringAddress() {
        return Address.monitoringAddress();
    }

    public void enableElementCount(String metricName, String key) {
        this.metricName = metricName;
        this.elementCountKey = key;
    }

    private void collectMetrics(Buffer buffer) {
        HashMap<String, String> map = new HashMap<String, String>();
        Splitter.on((String)System.lineSeparator()).omitEmptyStrings().trimResults().splitToList((CharSequence)buffer.toString()).stream().filter(input -> input != null && input.contains(DELIMITER) && !input.contains("executable") && !input.contains("config_file")).forEach(entry -> {
            List keyValue = Splitter.on((String)DELIMITER).omitEmptyStrings().trimResults().splitToList((CharSequence)entry);
            if (keyValue.size() == 2) {
                map.put((String)keyValue.get(0), (String)keyValue.get(1));
            }
        });
        this.log.debug("got redis metrics {}", map);
        map.forEach((key, valueStr) -> {
            try {
                if (key.startsWith("db")) {
                    String[] pairs;
                    for (String pair : pairs = valueStr.split(",")) {
                        String[] tokens = pair.split("=");
                        if (tokens.length == 2) {
                            long value = Long.parseLong(tokens[1]);
                            this.publisher.publishMetric("keyspace." + key + "." + tokens[0], value);
                            continue;
                        }
                        this.log.warn("Invalid keyspace property. Will be ignored");
                    }
                } else if (key.contains("_cpu_")) {
                    long value = (long)(Double.parseDouble(valueStr) * 1000.0);
                    this.publisher.publishMetric((String)key, value);
                } else if (key.contains("fragmentation_ratio")) {
                    long value = (long)Double.parseDouble(valueStr);
                    this.publisher.publishMetric((String)key, value);
                } else {
                    long value = Long.parseLong(valueStr);
                    this.publisher.publishMetric((String)key, value);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
    }
}

