/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.monitoring;

import io.vertx.core.Vertx;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.util.Address;
import org.swisspush.gateleen.monitoring.ResetMetrics;

public class ResetMetricsController {
    private static Logger log = LoggerFactory.getLogger(ResetMetricsController.class);
    private static final String RESET_METRICS_MBEAN_NAME = ":type=ResetMetricsController";
    private Vertx vertx;
    private String monitoringAddress;

    public ResetMetricsController(Vertx vertx) {
        this(vertx, Address.monitoringAddress());
    }

    public ResetMetricsController(Vertx vertx, String monitoringAddress) {
        this.vertx = vertx;
        this.monitoringAddress = monitoringAddress;
    }

    public void registerResetMetricsControlMBean(String domain, String prefix) {
        ObjectName name;
        log.debug("About to register ResetMetricsControlMBean with domain '{}', prefix '{}' and monitoring address '{}'", new Object[]{domain, prefix, this.monitoringAddress});
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ResetMetrics resetMetrics = new ResetMetrics(this.vertx, prefix, this.monitoringAddress);
        try {
            name = new ObjectName(domain + RESET_METRICS_MBEAN_NAME);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        try {
            mbs.unregisterMBean(name);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            mbs.registerMBean(resetMetrics, name);
        }
        catch (Exception e) {
            throw new RuntimeException("exception while registering the ResetMetricsController MBean", e);
        }
    }
}

