/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.monitoring;

import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.monitoring.ResetMetricsMBean;

public class ResetMetrics
implements ResetMetricsMBean {
    private Vertx vertx;
    private String prefix;
    private String monitoringAddress;
    private static Logger log = LoggerFactory.getLogger(ResetMetrics.class);

    public ResetMetrics(Vertx vertx, String prefix, String monitoringAddress) {
        this.vertx = vertx;
        this.prefix = prefix;
        this.monitoringAddress = monitoringAddress;
    }

    @Override
    public void resetLastUsedQueueSizeInformation() {
        this.removeMetric(this.prefix + "queues.last.size");
    }

    @Override
    public void resetRequestsFromClientsToCrushCount() {
        this.removeMetric(this.prefix + "requests.localhost");
    }

    @Override
    public void resetRequestsFromCrushToBackendsCount() {
        this.removeMetric(this.prefix + "requests.backends");
    }

    @Override
    public void resetMetricByName(String mBeanName) {
        this.removeMetric(mBeanName);
    }

    private void removeMetric(String metric) {
        log.debug("About to reset '{}' (triggered by an operation from MBean) by sending message to monitoring address '{}'", (Object)metric, (Object)this.monitoringAddress);
        this.vertx.eventBus().request(this.monitoringAddress, (Object)new JsonObject().put("name", (Object)metric).put("action", (Object)"remove"), reply -> {
            if (reply.failed()) {
                log.error("Failed to remove value for metric '{}'. Cause: {}", new Object[]{metric, reply.cause().getMessage(), reply.cause()});
            } else if (!"ok".equals(((JsonObject)((Message)reply.result()).body()).getString("status"))) {
                log.error("Removing value for metric '{}' resulted in status '{}'. Message: {}", new Object[]{metric, ((JsonObject)((Message)reply.result()).body()).getString("status"), ((JsonObject)((Message)reply.result()).body()).getString("message")});
            } else {
                log.debug("Value for metric '{}' successfully removed", (Object)metric);
            }
        });
    }
}

