/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.packing;

import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.Message;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import java.util.List;
import org.slf4j.Logger;
import org.swisspush.gateleen.core.exception.GateleenExceptionFactory;
import org.swisspush.gateleen.core.http.HttpRequest;
import org.swisspush.gateleen.core.http.RequestLoggerFactory;
import org.swisspush.gateleen.core.util.ResponseStatusCodeLogUtil;
import org.swisspush.gateleen.core.util.Result;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.core.validation.ValidationResult;
import org.swisspush.gateleen.packing.PackingRequestParser;
import org.swisspush.gateleen.packing.validation.PackingValidator;
import org.swisspush.gateleen.queue.expiry.ExpiryCheckHandler;
import org.swisspush.redisques.util.RedisquesAPI;

public class PackingHandler {
    public static final String PACK_HEADER = "x-packed";
    private final Vertx vertx;
    private final String redisquesAddress;
    private final String queuePrefix;
    private final PackingValidator validator;
    private final GateleenExceptionFactory exceptionFactory;

    public PackingHandler(Vertx vertx, String queuePrefix, String redisquesAddress, PackingValidator validator, GateleenExceptionFactory exceptionFactory) {
        this.vertx = vertx;
        this.queuePrefix = queuePrefix;
        this.redisquesAddress = redisquesAddress;
        this.validator = validator;
        this.exceptionFactory = exceptionFactory;
    }

    public boolean isPacked(HttpServerRequest request) {
        return request.headers().get(PACK_HEADER) != null;
    }

    public boolean handle(HttpServerRequest request) {
        Logger requestLog = RequestLoggerFactory.getLogger(PackingHandler.class, (HttpServerRequest)request);
        if (!this.isPacked(request)) {
            requestLog.warn("Request is not packed and should not be handled by the PackingHandler");
            this.respondWith(request, StatusCode.INTERNAL_SERVER_ERROR);
            return true;
        }
        if (HttpMethod.PUT != request.method() && HttpMethod.POST != request.method()) {
            requestLog.warn("Only PUT/POST requests allowed for packed requests");
            this.respondWith(request, StatusCode.BAD_REQUEST);
            return true;
        }
        String fallbackQueueNameSuffix = String.valueOf(System.currentTimeMillis());
        request.bodyHandler(payload -> {
            ValidationResult validationResult = this.validator.validatePackingPayload((Buffer)payload);
            if (!validationResult.isSuccess()) {
                requestLog.warn("Invalid packing payload: " + validationResult.getMessage());
                this.respondWith(request, StatusCode.BAD_REQUEST);
                return;
            }
            Result<List<HttpRequest>, String> parseRequestsResult = PackingRequestParser.parseRequests(payload, request.headers());
            if (parseRequestsResult.isErr()) {
                requestLog.warn("Error while parsing requests from packing payload: " + (String)parseRequestsResult.err());
                this.respondWith(request, StatusCode.BAD_REQUEST);
                return;
            }
            for (HttpRequest req : (List)parseRequestsResult.ok()) {
                if (req.getHeaders() != null) {
                    req.getHeaders().remove("X-Server-Timestamp");
                }
                ExpiryCheckHandler.updateServerTimestampHeader((HttpRequest)req);
                String queueName = this.getQueueFromRequestOrPrefix(req, fallbackQueueNameSuffix);
                JsonObject enqueOp = RedisquesAPI.buildEnqueueOperation((String)queueName, (String)req.toJsonObject().put("queueTimestamp", (Object)System.currentTimeMillis()).encode());
                this.vertx.eventBus().request(this.redisquesAddress, (Object)enqueOp, event -> {
                    if (event.failed()) {
                        requestLog.error("Could not enqueue request {}", (Object)req.toJsonObject().encodePrettily());
                        if (requestLog.isWarnEnabled()) {
                            requestLog.warn("Could not enqueue request '{}' '{}'", new Object[]{queueName, req.getUri(), this.exceptionFactory.newException("eventBus.request('" + this.redisquesAddress + "', enqueOp) failed", event.cause())});
                        }
                        return;
                    }
                    if (!"ok".equals(((JsonObject)((Message)event.result()).body()).getString("status"))) {
                        requestLog.error("Could not enqueue request {}", (Object)req.toJsonObject().encodePrettily());
                    }
                });
            }
            this.respondWith(request, StatusCode.OK);
        });
        return true;
    }

    private String getQueueFromRequestOrPrefix(HttpRequest request, String fallbackQueueNameSuffix) {
        if (request.getHeaders().contains("x-queue")) {
            return request.getHeaders().get("x-queue");
        }
        return this.queuePrefix + fallbackQueueNameSuffix;
    }

    private void respondWith(HttpServerRequest request, StatusCode statusCode) {
        ResponseStatusCodeLogUtil.info((HttpServerRequest)request, (StatusCode)statusCode, PackingHandler.class);
        request.response().setStatusCode(statusCode.getStatusCode());
        request.response().setStatusMessage(statusCode.getStatusMessage());
        request.response().end();
    }
}

