/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.packing;

import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.swisspush.gateleen.core.http.HttpRequest;
import org.swisspush.gateleen.core.util.Result;

public class PackingRequestParser {
    private static final String HEADERS = "headers";
    private static final String PAYLOAD = "payload";
    private static final String REQUESTS = "requests";
    private static final String CONTENT_LENGTH = "content-length";
    private static final String UNIQUE_ID = "x-rp-unique_id";
    private static final String PACK_HEADER = "x-packed";
    private static final String COPY_ORIGINAL_HEADERS = "copy_original_headers";

    public static Result<List<HttpRequest>, String> parseRequests(Buffer data, MultiMap originalHeaders, String groupRequestHeader) {
        ArrayList<HttpRequest> requests = new ArrayList<HttpRequest>();
        try {
            JsonObject dataObject = new JsonObject(data.toString());
            for (int i = 0; i < dataObject.getJsonArray(REQUESTS).size(); ++i) {
                requests.add(PackingRequestParser.requestFromJsonObject((JsonObject)dataObject.getJsonArray(REQUESTS).getValue(i), originalHeaders, groupRequestHeader));
            }
        }
        catch (Exception ex) {
            return Result.err((Object)("Error while parsing requests payload. Cause: " + ex.getMessage()));
        }
        return Result.ok(requests);
    }

    private static HttpRequest requestFromJsonObject(JsonObject requestObj, MultiMap originalHeaders, String groupRequestHeader) {
        return new HttpRequest(PackingRequestParser.prepare(requestObj, originalHeaders, groupRequestHeader));
    }

    private static JsonObject prepare(JsonObject httpRequestJsonObject, MultiMap originalHeaders, String groupRequestHeader) {
        String payloadStr;
        try {
            payloadStr = httpRequestJsonObject.getJsonObject(PAYLOAD) != null ? httpRequestJsonObject.getJsonObject(PAYLOAD).encode() : null;
        }
        catch (ClassCastException e) {
            payloadStr = httpRequestJsonObject.getString(PAYLOAD);
        }
        MultiMap headersCleared = PackingRequestParser.headersCopiedCleared(originalHeaders, httpRequestJsonObject);
        JsonArray headers = httpRequestJsonObject.getJsonArray(HEADERS);
        MultiMap headersMap = PackingRequestParser.multiMapFromJsonArray(headers);
        for (Object entry : headersMap) {
            headersCleared.set((String)entry.getKey(), (String)entry.getValue());
        }
        headersCleared.remove(groupRequestHeader);
        headersCleared.set(groupRequestHeader, originalHeaders.get(groupRequestHeader));
        JsonArray headersJsonArray = new JsonArray();
        for (Map.Entry entry : headersCleared) {
            headersJsonArray.add((Object)new JsonArray(Arrays.asList((String)entry.getKey(), (String)entry.getValue())));
        }
        httpRequestJsonObject.put(HEADERS, (Object)headersJsonArray);
        if (payloadStr != null) {
            byte[] payload = payloadStr.getBytes(StandardCharsets.UTF_8);
            httpRequestJsonObject.getJsonArray(HEADERS).add((Object)new JsonArray(Arrays.asList(CONTENT_LENGTH, "" + payload.length)));
            httpRequestJsonObject.put(PAYLOAD, (Object)payload);
        }
        return httpRequestJsonObject;
    }

    private static MultiMap headersCopiedCleared(MultiMap originalHeaders, JsonObject httpRequestJsonObject) {
        HeadersMultiMap headersCleared = new HeadersMultiMap();
        boolean copyHeaders = httpRequestJsonObject.getBoolean(COPY_ORIGINAL_HEADERS, Boolean.valueOf(false));
        if (copyHeaders) {
            headersCleared.addAll(originalHeaders);
            headersCleared.remove(CONTENT_LENGTH);
            headersCleared.remove(UNIQUE_ID);
            headersCleared.remove(PACK_HEADER);
        }
        return headersCleared;
    }

    public static MultiMap multiMapFromJsonArray(JsonArray jsonArray) {
        HeadersMultiMap multiMap = new HeadersMultiMap();
        if (jsonArray == null) {
            return multiMap;
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonArray header = jsonArray.getJsonArray(i);
            multiMap.add(header.getString(0), header.getString(1));
        }
        return multiMap;
    }
}

