/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.player.player;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.json.JSONObject;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class Client {
    private RestTemplate restTemplate = new RestTemplate();

    public Client() {
        ArrayList<JsonConverter> converters = new ArrayList<JsonConverter>();
        converters.add(new JsonConverter());
        this.restTemplate.setMessageConverters(converters);
        this.restTemplate.setErrorHandler(new ResponseErrorHandler(){

            public boolean hasError(ClientHttpResponse clientHttpResponse) throws IOException {
                return false;
            }

            public void handleError(ClientHttpResponse clientHttpResponse) throws IOException {
            }
        });
    }

    public ResponseEntity<JSONObject> exchange(RequestEntity<JSONObject> request) {
        LoggerFactory.getLogger(this.getClass()).debug("" + request);
        return this.restTemplate.exchange(request, JSONObject.class);
    }

    private static class JsonConverter
    extends AbstractHttpMessageConverter<JSONObject> {
        public JsonConverter() {
            this.setSupportedMediaTypes(Arrays.asList(MediaType.ALL));
        }

        protected boolean supports(Class<?> aClass) {
            return aClass.isAssignableFrom(JSONObject.class);
        }

        protected JSONObject readInternal(Class<? extends JSONObject> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
            return new JSONObject((Object)inputMessage.getBody());
        }

        protected void writeInternal(JSONObject jsonObject, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
            outputMessage.getBody().write(jsonObject.toString().getBytes("UTF-8"));
        }
    }
}

