package org.swisspush.gateleen.player.player;

import com.google.common.collect.FluentIterable;
import org.swisspush.gateleen.player.exchange.Exchange;

/**
 * Allows to intercept the exchanges before and after performing the request.
 *
 * @author https://github.com/lbovet [Laurent Bovet]
 */
public class ExchangeHandler {

    /**
     * Called before un exchange is replayed.
     *
     * @param exchange the exchange from input log about to be replayed.
     * @return the exchange that will actually be replayed. Return the incoming exchange to play it unmodified. If null, this exchange will be skipped.
     * @throws Exception Exception
     */
    public Exchange before(Exchange exchange) throws Exception {
        return exchange;
    }

    /**
     * Called after the exchange has been replayed.
     *
     * @param exchange the actual exchanged. Contains the original request and the actual response of the replay.
     * @param partialOutputLog a request log generated by the collector since the last request or according to {@link #resetTailOutputLog()}.
     * @return true if the player should continue, false to make it stop now.
     * @throws Exception Exception
     */
    public boolean after(Exchange exchange, FluentIterable<Exchange> partialOutputLog) throws Exception {
        return true;
    }

    /**
     * By default, the tail output log is reset before each input exchange. This can be overriden to control when it must be reset.
     *
     * @return true by default
     */
    public boolean resetTailOutputLog() {
        return true;
    }
}
