/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.player.exchange;

import com.google.common.base.Function;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.http.HttpHeaders;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.swisspush.gateleen.player.exchange.Exchange;

public class ReplaceStringTransformer
implements Function<Exchange, Exchange> {
    private String pattern;
    private String with;

    public ReplaceStringTransformer(String pattern, String with) {
        this.pattern = pattern;
        this.with = with;
    }

    public Exchange apply(Exchange exchange) {
        try {
            return new Exchange((RequestEntity<JSONObject>)new RequestEntity((Object)this.replace((JSONObject)exchange.getRequest().getBody()), (MultiValueMap)this.replace(exchange.getRequest().getHeaders()), exchange.getRequest().getMethod(), new URI(this.replace(exchange.getRequest().getUrl().toString()))), (ResponseEntity<JSONObject>)new ResponseEntity((Object)this.replace((JSONObject)exchange.getResponse().getBody()), (MultiValueMap)this.replace(exchange.getResponse().getHeaders()), exchange.getResponse().getStatusCode()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private HttpHeaders replace(HttpHeaders headers) {
        if (headers == null) {
            return null;
        }
        HttpHeaders result = new HttpHeaders();
        for (Map.Entry entry : headers.entrySet()) {
            for (String value : (List)entry.getValue()) {
                result.add((String)entry.getKey(), this.replace(value));
            }
        }
        return result;
    }

    private JSONObject replace(JSONObject body) {
        if (body == null) {
            return body;
        }
        try {
            return new JSONObject(this.replace(body.toString()));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private String replace(String input) {
        return input.replaceAll(this.pattern, this.with);
    }

    public static ReplaceStringTransformer clearTimestamps() {
        return new ReplaceStringTransformer("\\d{4}-[01]\\d-[0-3]\\dT[0-2]\\d:[0-5]\\d:[0-5]\\d(\\.\\d+)?([+-][0-2]\\d:[0-5]\\d|Z)", "1970-01-01T00:00:00Z");
    }

    public static ReplaceStringTransformer clearUUIDs() {
        return new ReplaceStringTransformer("[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "00000000-0000-0000-0000-000000000000");
    }
}

