/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.player.log;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.json.JSONException;
import org.json.JSONObject;
import org.swisspush.gateleen.player.exchange.Exchange;
import org.swisspush.gateleen.player.log.RequestLog;

public abstract class ReaderRequestLog
extends RequestLog {
    private String urlPrefix;

    protected abstract Reader getReader();

    public ReaderRequestLog(String urlPrefix) {
        this.urlPrefix = urlPrefix;
    }

    public Iterator<Exchange> iterator() {
        return new ExchangeIterator();
    }

    class ExchangeIterator
    implements Iterator<Exchange> {
        private BufferedReader bufferedReader;
        private Exchange readAhead;

        ExchangeIterator() {
            this.bufferedReader = new BufferedReader(ReaderRequestLog.this.getReader());
        }

        @Override
        public boolean hasNext() {
            if (this.readAhead != null) {
                return true;
            }
            try {
                Exchange next;
                this.readAhead = next = this.next();
                return true;
            }
            catch (NoSuchElementException e) {
                return false;
            }
        }

        @Override
        public Exchange next() {
            if (this.readAhead != null) {
                Exchange result = this.readAhead;
                this.readAhead = null;
                return result;
            }
            try {
                String line = "";
                while (line != null && (line.trim().equals("") || line.trim().startsWith("#"))) {
                    line = this.bufferedReader.readLine();
                }
                if (line == null) {
                    throw new NoSuchElementException();
                }
                try {
                    return new Exchange(ReaderRequestLog.this.urlPrefix, new JSONObject(line));
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

