/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.player.player;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import java.util.Iterator;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.player.exchange.Exchange;
import org.swisspush.gateleen.player.exchange.IgnoreHeadersTransformer;
import org.swisspush.gateleen.player.exchange.TimeResolver;
import org.swisspush.gateleen.player.log.BufferingRequestLog;
import org.swisspush.gateleen.player.log.Collector;
import org.swisspush.gateleen.player.log.EventBusCollector;
import org.swisspush.gateleen.player.log.RequestLog;
import org.swisspush.gateleen.player.log.ResourceRequestLog;
import org.swisspush.gateleen.player.player.Client;
import org.swisspush.gateleen.player.player.ExchangeHandler;

public class Player {
    private FluentIterable<Exchange> inputLog;
    private BufferingRequestLog outputLog = new BufferingRequestLog();
    private Collector collector;
    private ExchangeHandler exchangeHandler = new ExchangeHandler();
    private Function<Long, Long> timingFunction = input -> input;
    private Client client = new Client();
    private long gracePeriod = 200L;
    private boolean keepCollectorOpen = false;
    private Thread shutdownHook = new Thread(new Runnable(){

        @Override
        public void run() {
            LoggerFactory.getLogger(this.getClass()).warn("You created a player but never started. Did you forget to call 'play()' ?.");
        }
    });
    private boolean resetElapsedTime = false;

    public Player() {
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public Player setInputLog(FluentIterable<Exchange> inputLog) {
        this.inputLog = inputLog;
        return this;
    }

    public Player setInputLog(String urlPrefix, String inputLogLocation) {
        return this.setInputLog(urlPrefix, inputLogLocation, (Predicate<? super Exchange>)Predicates.alwaysTrue());
    }

    public Player setInputLog(String urlPrefix, String inputLogLocation, Predicate<? super Exchange> inputFilter) {
        this.inputLog = new ResourceRequestLog(urlPrefix, inputLogLocation).filter(inputFilter);
        return this;
    }

    public FluentIterable<Exchange> getInputLog() {
        return this.inputLog;
    }

    public RequestLog getOutputLog() {
        return this.outputLog;
    }

    public boolean isResetElapsedTime() {
        return this.resetElapsedTime;
    }

    public void setResetElapsedTime(boolean resetElapsedTime) {
        this.resetElapsedTime = resetElapsedTime;
    }

    public Player setOutputCollector(Collector collector) {
        this.keepCollectorOpen = true;
        this.collector = collector;
        return this;
    }

    public Player setOutputCollector(String urlPrefix, String sockPath, String eventBusAddress) {
        return this.setOutputCollector(urlPrefix, sockPath, eventBusAddress, (Predicate<? super Exchange>)Predicates.alwaysTrue());
    }

    public Player setOutputCollector(String urlPrefix, String sockPath, String eventBusAddress, Predicate<? super Exchange> outputFilter) {
        this.collector = new EventBusCollector(urlPrefix, sockPath, eventBusAddress, outputFilter);
        return this;
    }

    public Player setExchangeHandler(ExchangeHandler exchangeHandler) {
        this.exchangeHandler = exchangeHandler;
        return this;
    }

    public Player setTimingFunction(Function<Long, Long> timingFunction) {
        this.timingFunction = timingFunction;
        return this;
    }

    public Player setGracePeriod(long gracePeriod) {
        this.gracePeriod = gracePeriod;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Player play() {
        if (this.inputLog == null) {
            throw new IllegalStateException("inputLog must be set");
        }
        long lastRecordedTime = 0L;
        Iterator iterator = this.inputLog.iterator();
        try {
            if (!iterator.hasNext()) return this;
            Exchange exchange = (Exchange)iterator.next();
            TimeResolver timeresolver = new TimeResolver(exchange.getTimestamp());
            while (exchange != null) {
                long absoluteTime;
                block22: {
                    absoluteTime = System.currentTimeMillis();
                    try {
                        exchange = this.exchangeHandler.before(exchange);
                    }
                    catch (Exception e) {
                        if (!(e instanceof RuntimeException)) throw new RuntimeException(e);
                        throw (RuntimeException)e;
                    }
                    if (exchange != null) {
                        exchange = (Exchange)IgnoreHeadersTransformer.ignoreCommonHeaders().apply((Object)exchange);
                        BufferingRequestLog partialOutputLog = null;
                        if (this.collector != null) {
                            partialOutputLog = this.collector.getRequestLog();
                            if (this.exchangeHandler.resetTailOutputLog()) {
                                partialOutputLog.dump(this.outputLog);
                            }
                            this.collector.start();
                        }
                        exchange.setResponse(this.client.exchange(exchange.getRequest()));
                        try {
                            if (this.exchangeHandler.after(exchange, partialOutputLog != null ? partialOutputLog.transform(IgnoreHeadersTransformer.ignoreCommonHeaders()) : null)) break block22;
                            return this;
                        }
                        catch (Exception e) {
                            if (!(e instanceof RuntimeException)) throw new RuntimeException(e);
                            throw (RuntimeException)e;
                        }
                    }
                }
                exchange = null;
                if (!iterator.hasNext()) continue;
                exchange = (Exchange)iterator.next();
                long recordedTime = timeresolver.resolve(exchange.getTimestamp());
                long delay = (Long)this.timingFunction.apply((Object)(recordedTime - lastRecordedTime));
                if (delay < 0L) {
                    throw new RuntimeException("Exchange timestamp is smaller than previous one: " + exchange);
                }
                if (delay > 60000L) {
                    LoggerFactory.getLogger(this.getClass()).warn("Time to wait until firing next exchange is greater than 1 minute: " + exchange);
                }
                lastRecordedTime = recordedTime;
                long elapsedTime = this.resetElapsedTime ? 0L : System.currentTimeMillis() - absoluteTime;
                try {
                    Thread.sleep(Math.max(delay - elapsedTime, 0L));
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                    return this;
                }
            }
        }
        finally {
            if (this.collector != null) {
                try {
                    Thread.sleep(this.gracePeriod);
                    this.collector.getRequestLog().dump(this.outputLog);
                }
                catch (InterruptedException interruptedException) {}
                if (!this.keepCollectorOpen) {
                    this.collector.stop();
                }
            }
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
    }

    public Player setClient(Client client) {
        this.client = client;
        return this;
    }
}

