/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.player.exchange;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import uk.co.datumedge.hamcrest.json.SameJSONAs;

public class Exchange {
    private RequestEntity<JSONObject> request;
    private ResponseEntity<JSONObject> response;

    public Exchange(RequestEntity<JSONObject> request, ResponseEntity<JSONObject> response) {
        this.request = request;
        this.response = response;
    }

    public Exchange(String urlPrefix, JSONObject json) {
        JSONObject jsonRequest = null;
        try {
            JSONObject jsonResponse;
            jsonRequest = json.getJSONObject("request");
            if (jsonRequest == null) {
                jsonRequest = new JSONObject();
            }
            if ((jsonResponse = json.getJSONObject("response")) == null) {
                jsonResponse = new JSONObject();
            }
            JSONObject body = null;
            JSONObject headers = null;
            try {
                if (jsonRequest.has("body")) {
                    body = jsonRequest.getJSONObject("body");
                }
                if (jsonRequest.has("headers")) {
                    headers = jsonRequest.getJSONObject("headers");
                }
                this.request = new RequestEntity((Object)body, (MultiValueMap)this.createHeaders(headers), HttpMethod.valueOf((String)json.getString("method")), new URI(urlPrefix + json.getString("url")));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            body = null;
            headers = null;
            if (jsonResponse.has("body")) {
                body = jsonResponse.getJSONObject("body");
            }
            if (jsonResponse.has("headers")) {
                headers = jsonResponse.getJSONObject("headers");
            }
            this.response = new ResponseEntity((Object)body, (MultiValueMap)this.createHeaders(headers), HttpStatus.valueOf((int)json.getInt("statusCode")));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public RequestEntity<JSONObject> getRequest() {
        return this.request;
    }

    public void setRequest(RequestEntity<JSONObject> request) {
        this.request = request;
    }

    public ResponseEntity<JSONObject> getResponse() {
        return this.response;
    }

    public void setResponse(ResponseEntity<JSONObject> response) {
        this.response = response;
    }

    private HttpHeaders createHeaders(JSONObject jsonHeaders) {
        try {
            HttpHeaders headers = new HttpHeaders();
            if (headers != null) {
                Iterator it = jsonHeaders.keys();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    headers.add(key, jsonHeaders.getString(key));
                }
            }
            return headers;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public String getTimestamp() {
        return this.request.getHeaders().getFirst("x-client-timestamp");
    }

    public String getId() {
        return this.request.getHeaders().getFirst("x-request-id");
    }

    public static com.google.common.base.Predicate<Exchange> request(final com.google.common.base.Predicate<? super RequestEntity<JSONObject>> requestPredicate) {
        return new com.google.common.base.Predicate<Exchange>(){

            public boolean apply(Exchange exchange) {
                return requestPredicate.apply(exchange.getRequest());
            }
        };
    }

    public static com.google.common.base.Predicate<Exchange> response(final com.google.common.base.Predicate<? super ResponseEntity<JSONObject>> responsePredicate) {
        return new com.google.common.base.Predicate<Exchange>(){

            public boolean apply(Exchange exchange) {
                return responsePredicate.apply(exchange.getResponse());
            }
        };
    }

    public static com.google.common.base.Predicate<Exchange> withId(final String ... requestIds) {
        return new com.google.common.base.Predicate<Exchange>(){

            public boolean apply(Exchange exchange) {
                boolean result = false;
                for (String requestId : requestIds) {
                    result |= requestId.equals(exchange.getRequest().getHeaders().getFirst("x-request-id"));
                }
                return result;
            }
        };
    }

    public static com.google.common.base.Predicate<RequestEntity<JSONObject>> url(final com.google.common.base.Predicate<? super CharSequence> stringPredicate) {
        return new com.google.common.base.Predicate<RequestEntity<JSONObject>>(){

            public boolean apply(RequestEntity<JSONObject> request) {
                return stringPredicate.apply((Object)request.getUrl().toString());
            }
        };
    }

    public static com.google.common.base.Predicate<RequestEntity<JSONObject>> method(final com.google.common.base.Predicate<HttpMethod> methodPredicate) {
        return new com.google.common.base.Predicate<RequestEntity<JSONObject>>(){

            public boolean apply(RequestEntity<JSONObject> request) {
                return methodPredicate.apply((Object)request.getMethod());
            }
        };
    }

    public static com.google.common.base.Predicate<ResponseEntity<JSONObject>> status(final com.google.common.base.Predicate<HttpStatus> statusPredicate) {
        return new com.google.common.base.Predicate<ResponseEntity<JSONObject>>(){

            public boolean apply(ResponseEntity<JSONObject> response) {
                return statusPredicate.apply((Object)response.getStatusCode());
            }
        };
    }

    public static <T extends HttpEntity<JSONObject>> com.google.common.base.Predicate<T> body(final Predicate bodyPredicate) {
        return new com.google.common.base.Predicate<T>(){
            JsonPath path;

            public boolean apply(T entity) {
                if (entity.getBody() == null) {
                    return false;
                }
                if (this.path == null) {
                    this.path = JsonPath.compile((String)"$[?]", (Predicate[])new Predicate[]{bodyPredicate});
                }
                return !((List)this.path.read(((JSONObject)entity.getBody()).toString())).isEmpty();
            }
        };
    }

    public static <T extends HttpEntity<JSONObject>> com.google.common.base.Predicate<T> headers(final com.google.common.base.Predicate<HttpHeaders> headersPredicate) {
        return new com.google.common.base.Predicate<T>(){

            public boolean apply(T entity) {
                return headersPredicate.apply((Object)entity.getHeaders());
            }
        };
    }

    public static <T extends HttpEntity<JSONObject>, U extends CharSequence> com.google.common.base.Predicate<T> header(final String key, final com.google.common.base.Predicate<U> stringPredicate) {
        return new com.google.common.base.Predicate<T>(){

            public boolean apply(T entity) {
                List found = entity.getHeaders().get((Object)key);
                if (found != null && !found.isEmpty()) {
                    return stringPredicate.apply((Object)((CharSequence)found.get(0)));
                }
                return false;
            }
        };
    }

    public static void assertSameExchange(Exchange expected, Exchange actual) {
        if (expected == null) {
            MatcherAssert.assertThat((String)"Actual exchange should be null", (Object)actual, (Matcher)CoreMatchers.nullValue());
        } else {
            MatcherAssert.assertThat((String)"Actual exchange should not be null", (Object)actual, (Matcher)CoreMatchers.notNullValue());
            MatcherAssert.assertThat((String)("Expected request: " + expected.getRequest() + ", Actual request: " + actual.getRequest()), (Object)expected.getRequest().getUrl(), (Matcher)IsEqual.equalTo((Object)actual.getRequest().getUrl()));
            MatcherAssert.assertThat((String)("Expected request: " + expected.getRequest() + ", Actual request: " + actual.getRequest()), (Object)expected.getRequest().getMethod(), (Matcher)IsEqual.equalTo((Object)actual.getRequest().getMethod()));
            MatcherAssert.assertThat((String)("Expected request: " + expected.getRequest() + ", Actual request: " + actual.getRequest()), (Object)expected.getRequest().getHeaders(), (Matcher)IsEqual.equalTo((Object)actual.getRequest().getHeaders()));
            if (expected.getRequest().getBody() != null && actual.getRequest().getBody() != null) {
                MatcherAssert.assertThat((String)("Actual request body should be null. Actual request: " + actual.getRequest()), (Object)((JSONObject)expected.getRequest().getBody()), (Matcher)CoreMatchers.notNullValue());
                MatcherAssert.assertThat((String)("Actual request body should not be null. Expected request: " + expected.getRequest()), (Object)((JSONObject)actual.getRequest().getBody()), (Matcher)CoreMatchers.notNullValue());
                MatcherAssert.assertThat((String)("Request body do not match. Expected request: " + expected.getRequest() + ", Actual request: " + actual.getRequest()), (Object)((JSONObject)expected.getRequest().getBody()), (Matcher)SameJSONAs.sameJSONObjectAs((JSONObject)((JSONObject)actual.getRequest().getBody())));
            }
            MatcherAssert.assertThat((String)("Expected response: " + expected.getResponse() + ", Actual response: " + actual.getResponse()), (Object)expected.getResponse().getStatusCode(), (Matcher)IsEqual.equalTo((Object)actual.getResponse().getStatusCode()));
            MatcherAssert.assertThat((String)("Expected response: " + expected.getResponse() + ", Actual response: " + actual.getResponse()), (Object)expected.getResponse().getHeaders(), (Matcher)IsEqual.equalTo((Object)actual.getResponse().getHeaders()));
            if (expected.getResponse().getBody() != null && actual.getResponse().getBody() != null) {
                MatcherAssert.assertThat((String)("Actual response body should be null. Actual response: " + actual.getResponse()), (Object)((JSONObject)expected.getResponse().getBody()), (Matcher)CoreMatchers.notNullValue());
                MatcherAssert.assertThat((String)("Actual response body should not be null. Expected response: " + expected.getResponse()), (Object)((JSONObject)actual.getResponse().getBody()), (Matcher)CoreMatchers.notNullValue());
                MatcherAssert.assertThat((String)("Response body do not match. Expected response: " + expected.getResponse() + ", Actual response: " + actual.getResponse()), (Object)((JSONObject)expected.getResponse().getBody()), (Matcher)SameJSONAs.sameJSONObjectAs((JSONObject)((JSONObject)actual.getRequest().getBody())));
            }
            MatcherAssert.assertThat((Object)expected.getRequest().getUrl(), (Matcher)IsEqual.equalTo((Object)actual.getRequest().getUrl()));
        }
    }

    public String toString() {
        return "request=" + this.request + ", response=" + this.response;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object o) {
        boolean equal;
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        Exchange exchange2 = (Exchange)o;
        boolean bl = equal = this.getRequest().getUrl().equals(exchange2.getRequest().getUrl()) && this.getRequest().getMethod().equals((Object)exchange2.getRequest().getMethod()) && this.getRequest().getHeaders().equals((Object)exchange2.getRequest().getHeaders());
        if (equal) {
            SameJSONAs body;
            if (this.getRequest().getBody() != null && exchange2.getRequest().getBody() != null) {
                body = SameJSONAs.sameJSONObjectAs((JSONObject)((JSONObject)this.getRequest().getBody()));
                equal = body.matches(exchange2.getRequest().getBody());
            } else if (this.getRequest().getBody() != null && exchange2.getRequest().getBody() == null || this.getRequest().getBody() == null && exchange2.getRequest().getBody() != null) {
                equal = false;
            }
            if (equal) {
                boolean bl2 = equal = this.getResponse().getStatusCode().equals((Object)exchange2.getResponse().getStatusCode()) && this.getResponse().getHeaders().equals((Object)exchange2.getResponse().getHeaders());
                if (equal) {
                    if (this.getResponse().getBody() != null && exchange2.getResponse().getBody() != null) {
                        body = SameJSONAs.sameJSONObjectAs((JSONObject)((JSONObject)this.getResponse().getBody()));
                        equal = body.matches(exchange2.getResponse().getBody());
                    } else if (this.getResponse().getBody() != null && exchange2.getResponse().getBody() == null || this.getResponse().getBody() == null && exchange2.getResponse().getBody() != null) {
                        equal = false;
                    }
                }
            }
        }
        return equal;
    }
}

