/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.player.exchange;

import com.google.common.base.Function;
import java.util.Map;
import org.json.JSONObject;
import org.springframework.http.HttpHeaders;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.swisspush.gateleen.player.exchange.Exchange;

public class IgnoreHeadersTransformer
implements Function<Exchange, Exchange> {
    private String[] headers;

    public IgnoreHeadersTransformer(String ... headers) {
        this.headers = headers;
    }

    public Exchange apply(Exchange exchange) {
        HttpHeaders requestHeaders = new HttpHeaders();
        requestHeaders.putAll((Map)exchange.getRequest().getHeaders());
        HttpHeaders responseHeaders = new HttpHeaders();
        requestHeaders.putAll((Map)exchange.getResponse().getHeaders());
        for (String header : this.headers) {
            requestHeaders.remove((Object)header);
            responseHeaders.remove((Object)header);
        }
        return new Exchange((RequestEntity<JSONObject>)new RequestEntity((Object)((JSONObject)exchange.getRequest().getBody()), (MultiValueMap)requestHeaders, exchange.getRequest().getMethod(), exchange.getRequest().getUrl()), (ResponseEntity<JSONObject>)new ResponseEntity((Object)((JSONObject)exchange.getResponse().getBody()), (MultiValueMap)responseHeaders, exchange.getResponse().getStatusCode()));
    }

    public static Function<Exchange, Exchange> ignoreCommonHeaders() {
        return new IgnoreHeadersTransformer("connection", "host", "accept", "user-agent", "accept-encoding", "content-length", "x-client-timestamp", "x-server-timestamp", "x-log", "x-hooked", "x-self-request");
    }
}

