/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.playground;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.redis.RedisClient;
import io.vertx.redis.RedisOptions;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePropertySource;
import org.swisspush.gateleen.core.configuration.ConfigurationResourceManager;
import org.swisspush.gateleen.core.cors.CORSHandler;
import org.swisspush.gateleen.core.event.EventBusHandler;
import org.swisspush.gateleen.core.http.LocalHttpClient;
import org.swisspush.gateleen.core.resource.CopyResourceHandler;
import org.swisspush.gateleen.core.storage.EventBusResourceStorage;
import org.swisspush.gateleen.core.storage.ResourceStorage;
import org.swisspush.gateleen.core.util.Address;
import org.swisspush.gateleen.delegate.DelegateHandler;
import org.swisspush.gateleen.delta.DeltaHandler;
import org.swisspush.gateleen.expansion.ExpansionHandler;
import org.swisspush.gateleen.expansion.ZipExtractHandler;
import org.swisspush.gateleen.hook.HookHandler;
import org.swisspush.gateleen.logging.LogController;
import org.swisspush.gateleen.logging.LoggingResourceManager;
import org.swisspush.gateleen.monitoring.CustomRedisMonitor;
import org.swisspush.gateleen.monitoring.MonitoringHandler;
import org.swisspush.gateleen.monitoring.ResetMetricsController;
import org.swisspush.gateleen.qos.QoSHandler;
import org.swisspush.gateleen.queue.queuing.QueueBrowser;
import org.swisspush.gateleen.queue.queuing.QueueProcessor;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.QueueCircuitBreaker;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.QueueCircuitBreakerStorage;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.api.QueueCircuitBreakerHttpRequestHandler;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.configuration.QueueCircuitBreakerConfigurationResourceManager;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.impl.QueueCircuitBreakerImpl;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.impl.RedisQueueCircuitBreakerStorage;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.util.QueueCircuitBreakerRulePatternToCircuitMapping;
import org.swisspush.gateleen.routing.RuleProvider;
import org.swisspush.gateleen.runconfig.RunConfig;
import org.swisspush.gateleen.scheduler.SchedulerResourceManager;
import org.swisspush.gateleen.security.authorization.Authorizer;
import org.swisspush.gateleen.user.RoleProfileHandler;
import org.swisspush.gateleen.user.UserProfileHandler;
import org.swisspush.gateleen.validation.ValidationHandler;
import org.swisspush.gateleen.validation.ValidationResourceManager;

public class Server
extends AbstractVerticle {
    public static final String PREFIX = "gateleen.";
    public static final String ROOT = "/playground";
    public static final String SERVER_ROOT = "/playground/server";
    public static final String RULES_ROOT = "/playground/server/admin/v1/routing/rules";
    public static final String ROLE_PATTERN = "^z-playground[-_](.*)$";
    public static final String JMX_DOMAIN = "org.swisspush.gateleen";
    private HttpServer mainServer;
    private Authorizer authorizer;
    private org.swisspush.gateleen.routing.Router router;
    private LoggingResourceManager loggingResourceManager;
    private ConfigurationResourceManager configurationResourceManager;
    private ValidationResourceManager validationResourceManager;
    private SchedulerResourceManager schedulerResourceManager;
    private QueueCircuitBreakerConfigurationResourceManager queueCircuitBreakerConfigurationResourceManager;
    private MonitoringHandler monitoringHandler;
    private EventBusHandler eventBusHandler;
    private int defaultRedisPort = 6379;
    private int mainPort = 7012;
    private int circuitBreakerPort = 7013;
    private RedisClient redisClient;
    private ResourceStorage storage;
    private UserProfileHandler userProfileHandler;
    private RoleProfileHandler roleProfileHandler;
    private CORSHandler corsHandler;
    private ExpansionHandler expansionHandler;
    private DeltaHandler deltaHandler;
    private CopyResourceHandler copyResourceHandler;
    private ValidationHandler validationHandler;
    private QoSHandler qosHandler;
    private HookHandler hookHandler;
    private ZipExtractHandler zipExtractHandler;
    private DelegateHandler delegateHandler;
    private Logger log = LoggerFactory.getLogger(Server.class);

    public static void main(String[] args) {
        Vertx.vertx().deployVerticle("org.swisspush.gateleen.playground.Server", event -> LoggerFactory.getLogger(Server.class).info("[_] Gateleen - http://localhost:7012/gateleen/"));
    }

    public void start() {
        LocalHttpClient selfClient;
        LocalHttpClient selfClientExpansionHandler = selfClient = new LocalHttpClient(this.vertx);
        JsonObject info = new JsonObject();
        Map props = RunConfig.buildRedisProps((String)"localhost", (int)this.defaultRedisPort);
        System.setProperty("org.swisspush.request.rule.property", "x-appid");
        try {
            String externalConfig = System.getProperty("org.swisspush.config.dir") + "/config.properties";
            FileSystemResource externalConfigResource = new FileSystemResource(externalConfig);
            if (externalConfigResource.exists()) {
                this.log.info("Merging external config " + externalConfig);
                props.putAll(RunConfig.subMap((Map)((Map)new ResourcePropertySource((Resource)externalConfigResource).getSource()), (String)"redis."));
            } else {
                this.log.info("No external config found under " + externalConfig);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        final String redisHost = (String)props.get("redis.host");
        final Integer redisPort = (Integer)props.get("redis.port");
        RunConfig.deployModules((Vertx)this.vertx, Server.class, (Map)props, (Handler)new Handler<Boolean>((HttpClient)selfClientExpansionHandler, props, info){
            final /* synthetic */ HttpClient val$selfClientExpansionHandler;
            final /* synthetic */ Map val$props;
            final /* synthetic */ JsonObject val$info;
            {
                this.val$selfClientExpansionHandler = httpClient;
                this.val$props = map;
                this.val$info = jsonObject;
            }

            public void handle(Boolean success) {
                if (success.booleanValue()) {
                    Server.this.redisClient = RedisClient.create((Vertx)Server.this.vertx, (RedisOptions)new RedisOptions().setHost(redisHost).setPort(redisPort.intValue()));
                    new CustomRedisMonitor(Server.this.vertx, Server.this.redisClient, "main", "rest-storage", 10).start();
                    Server.this.storage = (ResourceStorage)new EventBusResourceStorage(Server.this.vertx.eventBus(), Address.storageAddress() + "-main");
                    Server.this.corsHandler = new CORSHandler();
                    Server.this.deltaHandler = new DeltaHandler(Server.this.redisClient, (HttpClient)selfClient);
                    Server.this.expansionHandler = new ExpansionHandler(Server.this.vertx, Server.this.storage, this.val$selfClientExpansionHandler, this.val$props, Server.ROOT, Server.RULES_ROOT);
                    Server.this.copyResourceHandler = new CopyResourceHandler((HttpClient)selfClient, "/playground/server/v1/copy");
                    Server.this.monitoringHandler = new MonitoringHandler(Server.this.vertx, Server.this.storage, Server.PREFIX, "/playground/server/monitoring/rpr");
                    Server.this.qosHandler = new QoSHandler(Server.this.vertx, Server.this.storage, "/playground/server/admin/v1/qos", this.val$props, Server.PREFIX);
                    Server.this.configurationResourceManager = new ConfigurationResourceManager(Server.this.vertx, Server.this.storage);
                    String eventBusConfigurationResource = "/playground/server/admin/v1/hookconfig";
                    Server.this.eventBusHandler = new EventBusHandler(Server.this.vertx, "/playground/server/event/v1/", "/playground/server/event/v1/sock/*", "event-", "channels/([^/]+).*", Server.this.configurationResourceManager, eventBusConfigurationResource);
                    Server.this.eventBusHandler.setEventbusBridgePingInterval(Long.valueOf(600000L));
                    Server.this.loggingResourceManager = new LoggingResourceManager(Server.this.vertx, Server.this.storage, "/playground/server/admin/v1/logging");
                    Server.this.userProfileHandler = new UserProfileHandler(Server.this.vertx, Server.this.storage, Server.this.loggingResourceManager, RunConfig.buildUserProfileConfiguration());
                    Server.this.roleProfileHandler = new RoleProfileHandler(Server.this.vertx, Server.this.storage, "/playground/server/roles/v1/([^/]+)/profile");
                    Server.this.hookHandler = new HookHandler(Server.this.vertx, (HttpClient)selfClient, Server.this.storage, Server.this.loggingResourceManager, Server.this.monitoringHandler, "/playground/server/users/v1/%s/profile", "/playground/server/hooks/v1/");
                    Server.this.authorizer = new Authorizer(Server.this.vertx, Server.this.storage, "/playground/server/security/v1/", Server.ROLE_PATTERN);
                    Server.this.validationResourceManager = new ValidationResourceManager(Server.this.vertx, Server.this.storage, "/playground/server/admin/v1/validation");
                    Server.this.validationHandler = new ValidationHandler(Server.this.validationResourceManager, Server.this.storage, (HttpClient)selfClient, "/playground/schemas/apis/");
                    Server.this.schedulerResourceManager = new SchedulerResourceManager(Server.this.vertx, Server.this.redisClient, Server.this.storage, Server.this.monitoringHandler, "/playground/server/admin/v1/schedulers");
                    Server.this.zipExtractHandler = new ZipExtractHandler((HttpClient)selfClient);
                    Server.this.delegateHandler = new DelegateHandler(Server.this.vertx, (HttpClient)selfClient, Server.this.storage, Server.this.monitoringHandler, "/playground/server/delegate/v1/delegates/", this.val$props);
                    Server.this.router = new org.swisspush.gateleen.routing.Router(Server.this.vertx, Server.this.storage, this.val$props, Server.this.loggingResourceManager, Server.this.monitoringHandler, (HttpClient)selfClient, Server.SERVER_ROOT, Server.RULES_ROOT, "/playground/server/users/v1/%s/profile", this.val$info, new Handler[]{aVoid -> {
                        Server.this.hookHandler.init();
                        Server.this.delegateHandler.init();
                    }});
                    RuleProvider ruleProvider = new RuleProvider(Server.this.vertx, Server.RULES_ROOT, Server.this.storage, this.val$props);
                    QueueCircuitBreakerRulePatternToCircuitMapping rulePatternToCircuitMapping = new QueueCircuitBreakerRulePatternToCircuitMapping();
                    Server.this.queueCircuitBreakerConfigurationResourceManager = new QueueCircuitBreakerConfigurationResourceManager(Server.this.vertx, Server.this.storage, "/playground/server/admin/v1/circuitbreaker");
                    RedisQueueCircuitBreakerStorage queueCircuitBreakerStorage = new RedisQueueCircuitBreakerStorage(Server.this.redisClient);
                    QueueCircuitBreakerHttpRequestHandler requestHandler = new QueueCircuitBreakerHttpRequestHandler(Server.this.vertx, (QueueCircuitBreakerStorage)queueCircuitBreakerStorage, "/playground/server/queuecircuitbreaker/circuit");
                    QueueCircuitBreakerImpl queueCircuitBreaker = new QueueCircuitBreakerImpl(Server.this.vertx, (QueueCircuitBreakerStorage)queueCircuitBreakerStorage, ruleProvider, rulePatternToCircuitMapping, Server.this.queueCircuitBreakerConfigurationResourceManager, (Handler)requestHandler, Server.this.circuitBreakerPort);
                    new QueueProcessor(Server.this.vertx, (HttpClient)selfClient, Server.this.monitoringHandler, (QueueCircuitBreaker)queueCircuitBreaker);
                    QueueBrowser queueBrowser = new QueueBrowser(Server.this.vertx, "/playground/server/queuing", Address.redisquesAddress(), Server.this.monitoringHandler);
                    LogController logController = new LogController();
                    logController.registerLogConfiguratorMBean(Server.JMX_DOMAIN);
                    ResetMetricsController resetMetricsController = new ResetMetricsController(Server.this.vertx);
                    resetMetricsController.registerResetMetricsControlMBean(Server.JMX_DOMAIN, Server.PREFIX);
                    RunConfig runConfig = RunConfig.with().authorizer(Server.this.authorizer).validationResourceManager(Server.this.validationResourceManager).validationHandler(Server.this.validationHandler).corsHandler(Server.this.corsHandler).deltaHandler(Server.this.deltaHandler).expansionHandler(Server.this.expansionHandler).hookHandler(Server.this.hookHandler).qosHandler(Server.this.qosHandler).copyResourceHandler(Server.this.copyResourceHandler).eventBusHandler(Server.this.eventBusHandler).roleProfileHandler(Server.this.roleProfileHandler).userProfileHandler(Server.this.userProfileHandler).loggingResourceManager(Server.this.loggingResourceManager).configurationResourceManager(Server.this.configurationResourceManager).queueCircuitBreakerConfigurationResourceManager(Server.this.queueCircuitBreakerConfigurationResourceManager).schedulerResourceManager(Server.this.schedulerResourceManager).zipExtractHandler(Server.this.zipExtractHandler).delegateHandler(Server.this.delegateHandler).build(Server.this.vertx, Server.this.redisClient, Server.class, Server.this.router, Server.this.monitoringHandler, queueBrowser);
                    Handler routingContextHandlerrNew = runConfig.buildRoutingContextHandler();
                    selfClient.setRoutingContexttHandler(routingContextHandlerrNew);
                    HttpServerOptions options = new HttpServerOptions();
                    options.setHandle100ContinueAutomatically(true);
                    Server.this.mainServer = Server.this.vertx.createHttpServer(options);
                    Router vertxRouter = Router.router((Vertx)Server.this.vertx);
                    Server.this.eventBusHandler.install(vertxRouter);
                    vertxRouter.route().handler(routingContextHandlerrNew);
                    Server.this.mainServer.requestHandler(arg_0 -> ((Router)vertxRouter).accept(arg_0));
                    Server.this.mainServer.listen(Server.this.mainPort);
                }
            }
        });
    }
}

