/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.playground;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.redis.RedisClient;
import io.vertx.redis.RedisOptions;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePropertySource;
import org.swisspush.gateleen.core.configuration.ConfigurationResourceManager;
import org.swisspush.gateleen.core.cors.CORSHandler;
import org.swisspush.gateleen.core.event.EventBusHandler;
import org.swisspush.gateleen.core.http.LocalHttpClient;
import org.swisspush.gateleen.core.lock.Lock;
import org.swisspush.gateleen.core.lock.impl.RedisBasedLock;
import org.swisspush.gateleen.core.resource.CopyResourceHandler;
import org.swisspush.gateleen.core.storage.EventBusResourceStorage;
import org.swisspush.gateleen.core.storage.ResourceStorage;
import org.swisspush.gateleen.core.util.Address;
import org.swisspush.gateleen.delegate.DelegateHandler;
import org.swisspush.gateleen.delta.DeltaHandler;
import org.swisspush.gateleen.expansion.ExpansionHandler;
import org.swisspush.gateleen.expansion.ZipExtractHandler;
import org.swisspush.gateleen.hook.HookHandler;
import org.swisspush.gateleen.hook.reducedpropagation.ReducedPropagationManager;
import org.swisspush.gateleen.hook.reducedpropagation.ReducedPropagationStorage;
import org.swisspush.gateleen.hook.reducedpropagation.impl.RedisReducedPropagationStorage;
import org.swisspush.gateleen.kafka.KafkaHandler;
import org.swisspush.gateleen.kafka.KafkaMessageSender;
import org.swisspush.gateleen.kafka.KafkaProducerRepository;
import org.swisspush.gateleen.logging.LogController;
import org.swisspush.gateleen.logging.LoggingResourceManager;
import org.swisspush.gateleen.monitoring.CustomRedisMonitor;
import org.swisspush.gateleen.monitoring.MonitoringHandler;
import org.swisspush.gateleen.monitoring.ResetMetricsController;
import org.swisspush.gateleen.qos.QoSHandler;
import org.swisspush.gateleen.queue.queuing.QueueBrowser;
import org.swisspush.gateleen.queue.queuing.QueueClient;
import org.swisspush.gateleen.queue.queuing.QueueProcessor;
import org.swisspush.gateleen.queue.queuing.RequestQueue;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.QueueCircuitBreaker;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.QueueCircuitBreakerStorage;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.api.QueueCircuitBreakerHttpRequestHandler;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.configuration.QueueCircuitBreakerConfigurationResourceManager;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.impl.QueueCircuitBreakerImpl;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.impl.RedisQueueCircuitBreakerStorage;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.util.QueueCircuitBreakerRulePatternToCircuitMapping;
import org.swisspush.gateleen.routing.RuleProvider;
import org.swisspush.gateleen.runconfig.RunConfig;
import org.swisspush.gateleen.scheduler.SchedulerResourceManager;
import org.swisspush.gateleen.security.authorization.Authorizer;
import org.swisspush.gateleen.user.RoleProfileHandler;
import org.swisspush.gateleen.user.UserProfileHandler;
import org.swisspush.gateleen.validation.ValidationHandler;
import org.swisspush.gateleen.validation.ValidationResourceManager;

public class Server
extends AbstractVerticle {
    private Logger log = LoggerFactory.getLogger(Server.class);
    private static final String PREFIX = "gateleen.";
    private static final String ROOT = "/playground";
    private static final String SERVER_ROOT = "/playground/server";
    private static final String RULES_ROOT = "/playground/server/admin/v1/routing/rules";
    private static final String ROLE_PATTERN = "^z-playground[-_](.*)$";
    private static final String JMX_DOMAIN = "org.swisspush.gateleen";
    private int defaultRedisPort = 6379;
    private int mainPort = 7012;
    private int circuitBreakerPort = 7013;
    private HttpServer mainServer;
    private RedisClient redisClient;
    private ResourceStorage storage;
    private Authorizer authorizer;
    private org.swisspush.gateleen.routing.Router router;
    private LoggingResourceManager loggingResourceManager;
    private ConfigurationResourceManager configurationResourceManager;
    private ValidationResourceManager validationResourceManager;
    private SchedulerResourceManager schedulerResourceManager;
    private QueueCircuitBreakerConfigurationResourceManager queueCircuitBreakerConfigurationResourceManager;
    private ReducedPropagationManager reducedPropagationManager;
    private MonitoringHandler monitoringHandler;
    private EventBusHandler eventBusHandler;
    private UserProfileHandler userProfileHandler;
    private RoleProfileHandler roleProfileHandler;
    private CORSHandler corsHandler;
    private ExpansionHandler expansionHandler;
    private DeltaHandler deltaHandler;
    private CopyResourceHandler copyResourceHandler;
    private ValidationHandler validationHandler;
    private QoSHandler qosHandler;
    private HookHandler hookHandler;
    private ZipExtractHandler zipExtractHandler;
    private DelegateHandler delegateHandler;
    private KafkaHandler kafkaHandler;

    public static void main(String[] args) {
        Vertx.vertx().deployVerticle("org.swisspush.gateleen.playground.Server", event -> LoggerFactory.getLogger(Server.class).info("[_] Gateleen - http://localhost:7012/gateleen/"));
    }

    public void start() {
        LocalHttpClient selfClient = new LocalHttpClient(this.vertx);
        JsonObject info = new JsonObject();
        Map props = RunConfig.buildRedisProps((String)"localhost", (int)this.defaultRedisPort);
        System.setProperty("org.swisspush.request.rule.property", "x-appid");
        try {
            String externalConfig = System.getProperty("org.swisspush.config.dir") + "/config.properties";
            FileSystemResource externalConfigResource = new FileSystemResource(externalConfig);
            if (externalConfigResource.exists()) {
                this.log.info("Merging external config {}", (Object)externalConfig);
                props.putAll(RunConfig.subMap((Map)((Map)new ResourcePropertySource((Resource)externalConfigResource).getSource()), (String)"redis."));
            } else {
                this.log.info("No external config found under {}", (Object)externalConfig);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String redisHost = (String)props.get("redis.host");
        Integer redisPort = (Integer)props.get("redis.port");
        props.put("max.expansion.level.hard", "100");
        props.put("max.expansion.level.soft", "50");
        RunConfig.deployModules((Vertx)this.vertx, Server.class, (Map)props, success -> {
            if (success.booleanValue()) {
                this.redisClient = RedisClient.create((Vertx)this.vertx, (RedisOptions)new RedisOptions().setHost(redisHost).setPort(redisPort.intValue()));
                new CustomRedisMonitor(this.vertx, this.redisClient, "main", "rest-storage", 10).start();
                this.storage = new EventBusResourceStorage(this.vertx.eventBus(), Address.storageAddress() + "-main");
                this.corsHandler = new CORSHandler();
                this.deltaHandler = new DeltaHandler(this.redisClient, (HttpClient)selfClient);
                this.expansionHandler = new ExpansionHandler(this.vertx, this.storage, (HttpClient)selfClient, props, ROOT, RULES_ROOT);
                this.copyResourceHandler = new CopyResourceHandler((HttpClient)selfClient, "/playground/server/v1/copy");
                this.monitoringHandler = new MonitoringHandler(this.vertx, this.storage, PREFIX, "/playground/server/monitoring/rpr");
                this.qosHandler = new QoSHandler(this.vertx, this.storage, "/playground/server/admin/v1/qos", props, PREFIX);
                this.qosHandler.enableResourceLogging(true);
                this.configurationResourceManager = new ConfigurationResourceManager(this.vertx, this.storage);
                this.configurationResourceManager.enableResourceLogging(true);
                this.eventBusHandler = new EventBusHandler(this.vertx, "/playground/server/event/v1/", "/playground/server/event/v1/sock/*", "event/channels/", "channels/([^/]+).*", this.configurationResourceManager, "/playground/server/admin/v1/hookconfig");
                this.eventBusHandler.setEventbusBridgePingInterval(Long.valueOf(600000L));
                this.loggingResourceManager = new LoggingResourceManager(this.vertx, this.storage, "/playground/server/admin/v1/logging");
                this.loggingResourceManager.enableResourceLogging(true);
                KafkaProducerRepository kafkaProducerRepository = new KafkaProducerRepository(this.vertx);
                KafkaMessageSender kafkaMessageSender = new KafkaMessageSender();
                this.kafkaHandler = new KafkaHandler(this.configurationResourceManager, kafkaProducerRepository, kafkaMessageSender, "/playground/server/admin/v1/kafka/topicsConfig", "/playground/server/streaming/");
                this.kafkaHandler.initialize();
                this.userProfileHandler = new UserProfileHandler(this.vertx, this.storage, RunConfig.buildUserProfileConfiguration());
                this.userProfileHandler.enableResourceLogging(true);
                this.roleProfileHandler = new RoleProfileHandler(this.vertx, this.storage, "/playground/server/roles/v1/([^/]+)/profile");
                this.roleProfileHandler.enableResourceLogging(true);
                RedisBasedLock lock = new RedisBasedLock(this.redisClient);
                QueueClient queueClient = new QueueClient(this.vertx, this.monitoringHandler);
                this.reducedPropagationManager = new ReducedPropagationManager(this.vertx, (ReducedPropagationStorage)new RedisReducedPropagationStorage(this.redisClient), (RequestQueue)queueClient, (Lock)lock);
                this.reducedPropagationManager.startExpiredQueueProcessing(5000L);
                this.hookHandler = new HookHandler(this.vertx, (HttpClient)selfClient, this.storage, this.loggingResourceManager, this.monitoringHandler, "/playground/server/users/v1/%s/profile", "/playground/server/hooks/v1/", (RequestQueue)queueClient, false, this.reducedPropagationManager);
                this.hookHandler.enableResourceLogging(true);
                this.authorizer = new Authorizer(this.vertx, this.storage, "/playground/server/security/v1/", ROLE_PATTERN);
                this.authorizer.enableResourceLogging(true);
                this.validationResourceManager = new ValidationResourceManager(this.vertx, this.storage, "/playground/server/admin/v1/validation");
                this.validationResourceManager.enableResourceLogging(true);
                this.validationHandler = new ValidationHandler(this.validationResourceManager, this.storage, (HttpClient)selfClient, "/playground/schemas/apis/");
                this.schedulerResourceManager = new SchedulerResourceManager(this.vertx, this.redisClient, this.storage, this.monitoringHandler, "/playground/server/admin/v1/schedulers");
                this.schedulerResourceManager.enableResourceLogging(true);
                this.zipExtractHandler = new ZipExtractHandler((HttpClient)selfClient);
                this.delegateHandler = new DelegateHandler(this.vertx, (HttpClient)selfClient, this.storage, this.monitoringHandler, "/playground/server/admin/v1/delegates/", props, null);
                this.delegateHandler.enableResourceLogging(true);
                this.router = new org.swisspush.gateleen.routing.Router(this.vertx, this.storage, props, this.loggingResourceManager, this.monitoringHandler, (HttpClient)selfClient, SERVER_ROOT, RULES_ROOT, "/playground/server/users/v1/%s/profile", info, new Handler[]{aVoid -> {
                    this.hookHandler.init();
                    this.delegateHandler.init();
                }});
                this.router.enableResourceLogging(true);
                String routerConfigurationResource = "/playground/server/admin/v1/routing/config";
                this.router.enableRoutingConfiguration(this.configurationResourceManager, routerConfigurationResource);
                RuleProvider ruleProvider = new RuleProvider(this.vertx, RULES_ROOT, this.storage, props);
                QueueCircuitBreakerRulePatternToCircuitMapping rulePatternToCircuitMapping = new QueueCircuitBreakerRulePatternToCircuitMapping();
                this.queueCircuitBreakerConfigurationResourceManager = new QueueCircuitBreakerConfigurationResourceManager(this.vertx, this.storage, "/playground/server/admin/v1/circuitbreaker");
                this.queueCircuitBreakerConfigurationResourceManager.enableResourceLogging(true);
                RedisQueueCircuitBreakerStorage queueCircuitBreakerStorage = new RedisQueueCircuitBreakerStorage(this.redisClient);
                QueueCircuitBreakerHttpRequestHandler requestHandler = new QueueCircuitBreakerHttpRequestHandler(this.vertx, (QueueCircuitBreakerStorage)queueCircuitBreakerStorage, "/playground/server/queuecircuitbreaker/circuit");
                QueueCircuitBreakerImpl queueCircuitBreaker = new QueueCircuitBreakerImpl(this.vertx, (Lock)lock, Address.redisquesAddress(), (QueueCircuitBreakerStorage)queueCircuitBreakerStorage, ruleProvider, rulePatternToCircuitMapping, this.queueCircuitBreakerConfigurationResourceManager, (Handler)requestHandler, this.circuitBreakerPort);
                new QueueProcessor(this.vertx, (HttpClient)selfClient, this.monitoringHandler, (QueueCircuitBreaker)queueCircuitBreaker);
                QueueBrowser queueBrowser = new QueueBrowser(this.vertx, "/playground/server/queuing", Address.redisquesAddress(), this.monitoringHandler);
                LogController logController = new LogController();
                logController.registerLogConfiguratorMBean(JMX_DOMAIN);
                ResetMetricsController resetMetricsController = new ResetMetricsController(this.vertx);
                resetMetricsController.registerResetMetricsControlMBean(JMX_DOMAIN, PREFIX);
                RunConfig runConfig = RunConfig.with().authorizer(this.authorizer).validationResourceManager(this.validationResourceManager).validationHandler(this.validationHandler).corsHandler(this.corsHandler).deltaHandler(this.deltaHandler).expansionHandler(this.expansionHandler).hookHandler(this.hookHandler).qosHandler(this.qosHandler).copyResourceHandler(this.copyResourceHandler).eventBusHandler(this.eventBusHandler).kafkaHandler(this.kafkaHandler).roleProfileHandler(this.roleProfileHandler).userProfileHandler(this.userProfileHandler).loggingResourceManager(this.loggingResourceManager).configurationResourceManager(this.configurationResourceManager).queueCircuitBreakerConfigurationResourceManager(this.queueCircuitBreakerConfigurationResourceManager).schedulerResourceManager(this.schedulerResourceManager).zipExtractHandler(this.zipExtractHandler).delegateHandler(this.delegateHandler).build(this.vertx, this.redisClient, Server.class, this.router, this.monitoringHandler, queueBrowser);
                Handler routingContextHandlerrNew = runConfig.buildRoutingContextHandler();
                selfClient.setRoutingContexttHandler(routingContextHandlerrNew);
                HttpServerOptions options = new HttpServerOptions();
                options.setHandle100ContinueAutomatically(true);
                this.mainServer = this.vertx.createHttpServer(options);
                Router vertxRouter = Router.router((Vertx)this.vertx);
                this.eventBusHandler.install(vertxRouter);
                vertxRouter.route().handler(routingContextHandlerrNew);
                this.mainServer.requestHandler(arg_0 -> ((Router)vertxRouter).accept(arg_0));
                this.mainServer.listen(this.mainPort);
            }
        });
    }
}

