/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.playground;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.redis.client.PoolOptions;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisAPI;
import io.vertx.redis.client.RedisConnectOptions;
import io.vertx.redis.client.RedisStandaloneConnectOptions;
import io.vertx.redis.client.impl.RedisClient;
import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePropertySource;
import org.swisspush.gateleen.cache.CacheHandler;
import org.swisspush.gateleen.cache.fetch.CacheDataFetcher;
import org.swisspush.gateleen.cache.fetch.DefaultCacheDataFetcher;
import org.swisspush.gateleen.cache.storage.CacheStorage;
import org.swisspush.gateleen.cache.storage.RedisCacheStorage;
import org.swisspush.gateleen.core.configuration.ConfigurationResourceManager;
import org.swisspush.gateleen.core.cors.CORSHandler;
import org.swisspush.gateleen.core.event.EventBusHandler;
import org.swisspush.gateleen.core.exception.GateleenExceptionFactory;
import org.swisspush.gateleen.core.http.ClientRequestCreator;
import org.swisspush.gateleen.core.http.LocalHttpClient;
import org.swisspush.gateleen.core.lock.Lock;
import org.swisspush.gateleen.core.lock.impl.RedisBasedLock;
import org.swisspush.gateleen.core.redis.RedisByNameProvider;
import org.swisspush.gateleen.core.redis.RedisProvider;
import org.swisspush.gateleen.core.resource.CopyResourceHandler;
import org.swisspush.gateleen.core.storage.EventBusResourceStorage;
import org.swisspush.gateleen.core.storage.ResourceStorage;
import org.swisspush.gateleen.core.util.Address;
import org.swisspush.gateleen.delegate.DelegateHandler;
import org.swisspush.gateleen.delta.DeltaHandler;
import org.swisspush.gateleen.expansion.ExpansionHandler;
import org.swisspush.gateleen.expansion.ZipExtractHandler;
import org.swisspush.gateleen.hook.HookHandler;
import org.swisspush.gateleen.hook.reducedpropagation.ReducedPropagationManager;
import org.swisspush.gateleen.hook.reducedpropagation.ReducedPropagationStorage;
import org.swisspush.gateleen.hook.reducedpropagation.impl.RedisReducedPropagationStorage;
import org.swisspush.gateleen.kafka.KafkaHandler;
import org.swisspush.gateleen.kafka.KafkaMessageSender;
import org.swisspush.gateleen.kafka.KafkaMessageValidator;
import org.swisspush.gateleen.kafka.KafkaProducerRepository;
import org.swisspush.gateleen.logging.DefaultLogAppenderRepository;
import org.swisspush.gateleen.logging.LogAppenderRepository;
import org.swisspush.gateleen.logging.LogController;
import org.swisspush.gateleen.logging.LoggingResourceManager;
import org.swisspush.gateleen.monitoring.CustomRedisMonitor;
import org.swisspush.gateleen.monitoring.MonitoringHandler;
import org.swisspush.gateleen.monitoring.ResetMetricsController;
import org.swisspush.gateleen.packing.PackingHandler;
import org.swisspush.gateleen.packing.validation.PackingValidator;
import org.swisspush.gateleen.packing.validation.PackingValidatorImpl;
import org.swisspush.gateleen.qos.QoSHandler;
import org.swisspush.gateleen.queue.queuing.QueueClient;
import org.swisspush.gateleen.queue.queuing.QueueProcessor;
import org.swisspush.gateleen.queue.queuing.RequestQueue;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.QueueCircuitBreaker;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.QueueCircuitBreakerStorage;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.api.QueueCircuitBreakerHttpRequestHandler;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.configuration.QueueCircuitBreakerConfigurationResourceManager;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.impl.QueueCircuitBreakerImpl;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.impl.RedisQueueCircuitBreakerStorage;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.util.QueueCircuitBreakerRulePatternToCircuitMapping;
import org.swisspush.gateleen.queue.queuing.splitter.QueueSplitter;
import org.swisspush.gateleen.queue.queuing.splitter.QueueSplitterImpl;
import org.swisspush.gateleen.routing.CustomHttpResponseHandler;
import org.swisspush.gateleen.routing.DeferCloseHttpClient;
import org.swisspush.gateleen.routing.RuleProvider;
import org.swisspush.gateleen.routing.auth.DefaultOAuthProvider;
import org.swisspush.gateleen.routing.auth.OAuthProvider;
import org.swisspush.gateleen.runconfig.RunConfig;
import org.swisspush.gateleen.scheduler.SchedulerResourceManager;
import org.swisspush.gateleen.security.PatternHolder;
import org.swisspush.gateleen.security.authorization.Authorizer;
import org.swisspush.gateleen.security.content.ContentTypeConstraintHandler;
import org.swisspush.gateleen.security.content.ContentTypeConstraintRepository;
import org.swisspush.gateleen.user.RoleProfileHandler;
import org.swisspush.gateleen.user.UserProfileHandler;
import org.swisspush.gateleen.validation.DefaultValidationSchemaProvider;
import org.swisspush.gateleen.validation.ValidationHandler;
import org.swisspush.gateleen.validation.ValidationResourceManager;
import org.swisspush.gateleen.validation.ValidationSchemaProvider;
import org.swisspush.gateleen.validation.Validator;

public class Server
extends AbstractVerticle {
    private Logger log = LoggerFactory.getLogger(Server.class);
    private static final String PREFIX = "gateleen.";
    private static final String ROOT = "/playground";
    private static final String SERVER_ROOT = "/playground/server";
    private static final String RULES_ROOT = "/playground/server/admin/v1/routing/rules";
    private static final String RETURN_HTTP_STATUS_ROOT = "/playground/server/return-with-status-code";
    private static final String ROLE_PATTERN = "^z-playground[-_](.*)$";
    private static final String ROLE_PREFIX = "z-playground-";
    private static final String JMX_DOMAIN = "org.swisspush.gateleen";
    private int defaultRedisPort = 6379;
    private int mainPort = 7012;
    private int circuitBreakerPort = 7013;
    private int storagePort = 8989;
    private HttpServer mainServer;
    private RedisClient redisClient;
    private RedisAPI redisApi;
    private ResourceStorage storage;
    private CacheStorage cacheStorage;
    private CacheDataFetcher cacheDataFetcher;
    private final GateleenExceptionFactory exceptionFactory = GateleenExceptionFactory.newGateleenWastefulExceptionFactory();
    private Authorizer authorizer;
    private org.swisspush.gateleen.routing.Router router;
    private final AtomicReference<Handler<RoutingContext>> routingContextHandlerRf = new AtomicReference();
    private LoggingResourceManager loggingResourceManager;
    private LogAppenderRepository logAppenderRepository;
    private ConfigurationResourceManager configurationResourceManager;
    private ValidationResourceManager validationResourceManager;
    private ValidationSchemaProvider validationSchemaProvider;
    private Validator validator;
    private SchedulerResourceManager schedulerResourceManager;
    private QueueCircuitBreakerConfigurationResourceManager queueCircuitBreakerConfigurationResourceManager;
    private ReducedPropagationManager reducedPropagationManager;
    private MonitoringHandler monitoringHandler;
    private EventBusHandler eventBusHandler;
    private UserProfileHandler userProfileHandler;
    private RoleProfileHandler roleProfileHandler;
    private CORSHandler corsHandler;
    private ExpansionHandler expansionHandler;
    private DeltaHandler deltaHandler;
    private CopyResourceHandler copyResourceHandler;
    private ValidationHandler validationHandler;
    private QoSHandler qosHandler;
    private HookHandler hookHandler;
    private ZipExtractHandler zipExtractHandler;
    private DelegateHandler delegateHandler;
    private KafkaHandler kafkaHandler;
    private CustomHttpResponseHandler customHttpResponseHandler;
    private ContentTypeConstraintHandler contentTypeConstraintHandler;
    private CacheHandler cacheHandler;
    private PackingHandler packingHandler;
    private QueueSplitter queueSplitter;

    public static void main(String[] args) {
        Vertx.vertx().deployVerticle("org.swisspush.gateleen.playground.Server", event -> LoggerFactory.getLogger(Server.class).info("[_] Gateleen - http://localhost:7012/gateleen/"));
    }

    public void start() {
        LocalHttpClient selfClient = new LocalHttpClient(this.vertx, this::getRoutingContext, this.exceptionFactory);
        JsonObject info = new JsonObject();
        Map props = RunConfig.buildRedisProps((String)"localhost", (int)this.defaultRedisPort);
        System.setProperty("org.swisspush.request.rule.property", "x-appid");
        try {
            String externalConfig = System.getProperty("org.swisspush.config.dir") + "/config.properties";
            FileSystemResource externalConfigResource = new FileSystemResource(externalConfig);
            if (externalConfigResource.exists()) {
                this.log.info("Merging external config {}", (Object)externalConfig);
                props.putAll(RunConfig.subMap((Map)((Map)new ResourcePropertySource((Resource)externalConfigResource).getSource()), (String)"redis."));
            } else {
                this.log.info("No external config found under {}", (Object)externalConfig);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String redisHost = (String)props.get("redis.host");
        Integer redisPort = (Integer)props.get("redis.port");
        boolean redisEnableTls = props.get("redis.enableTls") != null ? (Boolean)props.get("redis.enableTls") : false;
        props.put("max.expansion.level.hard", "100");
        props.put("max.expansion.level.soft", "50");
        props.put("dst.observe", true);
        RunConfig.deployModules((Vertx)this.vertx, Server.class, (Map)props, success -> {
            if (success.booleanValue()) {
                String protocol = redisEnableTls ? "rediss://" : "redis://";
                this.redisClient = new RedisClient(this.vertx, new NetClientOptions(), new PoolOptions(), (RedisConnectOptions)new RedisStandaloneConnectOptions().setConnectionString(protocol + redisHost + ":" + redisPort), TracingPolicy.IGNORE);
                this.redisApi = RedisAPI.api((Redis)this.redisClient);
                RedisProvider redisProvider = () -> Future.succeededFuture((Object)this.redisApi);
                RedisByNameProvider redisByNameProvider = storageName -> Future.succeededFuture((Object)this.redisApi);
                new CustomRedisMonitor(this.vertx, redisProvider, "main", "rest-storage", 10).start();
                this.storage = new EventBusResourceStorage(this.vertx.eventBus(), Address.storageAddress() + "-main", this.exceptionFactory);
                this.corsHandler = new CORSHandler();
                RuleProvider ruleProvider = new RuleProvider(this.vertx, RULES_ROOT, this.storage, props);
                this.deltaHandler = new DeltaHandler(this.vertx, redisByNameProvider, (HttpClient)selfClient, ruleProvider, this.loggingResourceManager, this.logAppenderRepository, true);
                this.expansionHandler = new ExpansionHandler(ruleProvider, (HttpClient)selfClient, props, ROOT);
                this.copyResourceHandler = new CopyResourceHandler((HttpClient)selfClient, this.exceptionFactory, "/playground/server/v1/copy");
                this.monitoringHandler = new MonitoringHandler(this.vertx, this.storage, PREFIX, "/playground/server/monitoring/rpr");
                RedisBasedLock lock = new RedisBasedLock(redisProvider, GateleenExceptionFactory.newGateleenWastefulExceptionFactory());
                this.cacheStorage = new RedisCacheStorage(this.vertx, (Lock)lock, redisProvider, this.exceptionFactory, 20000L);
                this.cacheDataFetcher = new DefaultCacheDataFetcher(new ClientRequestCreator((HttpClient)selfClient));
                this.cacheHandler = new CacheHandler(this.cacheDataFetcher, this.cacheStorage, "/playground/server/cache");
                this.packingHandler = new PackingHandler(this.vertx, "packed-", Address.redisquesAddress(), "x-rp-grp", (PackingValidator)new PackingValidatorImpl(), this.exceptionFactory);
                this.qosHandler = new QoSHandler(this.vertx, this.storage, "/playground/server/admin/v1/qos", props, PREFIX);
                this.qosHandler.enableResourceLogging(true);
                this.configurationResourceManager = new ConfigurationResourceManager(this.vertx, this.storage, this.exceptionFactory);
                this.configurationResourceManager.enableResourceLogging(true);
                this.eventBusHandler = new EventBusHandler(this.vertx, "/playground/server/event/v1/", "/playground/server/event/v1/sock/", "event/channels/", "channels/([^/]+).*", this.configurationResourceManager, "/playground/server/admin/v1/hookconfig");
                this.eventBusHandler.setEventbusBridgePingInterval(Long.valueOf(600000L));
                this.logAppenderRepository = new DefaultLogAppenderRepository(this.vertx);
                this.loggingResourceManager = new LoggingResourceManager(this.vertx, this.storage, "/playground/server/admin/v1/logging");
                this.loggingResourceManager.enableResourceLogging(true);
                ContentTypeConstraintRepository repository = new ContentTypeConstraintRepository();
                this.contentTypeConstraintHandler = new ContentTypeConstraintHandler(this.configurationResourceManager, repository, "/playground/server/admin/v1/contentTypeConstraints", Arrays.asList(new PatternHolder("application/json"), new PatternHolder("application/x-www-form-urlencoded"), new PatternHolder("multipart/form-data")));
                this.contentTypeConstraintHandler.initialize();
                this.userProfileHandler = new UserProfileHandler(this.vertx, this.storage, RunConfig.buildUserProfileConfiguration());
                this.userProfileHandler.enableResourceLogging(true);
                this.roleProfileHandler = new RoleProfileHandler(this.vertx, this.storage, "/playground/server/roles/v1/([^/]+)/profile");
                this.roleProfileHandler.enableResourceLogging(true);
                QueueClient queueClient = new QueueClient(this.vertx, this.monitoringHandler);
                this.reducedPropagationManager = new ReducedPropagationManager(this.vertx, (ReducedPropagationStorage)new RedisReducedPropagationStorage(redisProvider, this.exceptionFactory), (RequestQueue)queueClient, (Lock)lock, this.exceptionFactory);
                this.reducedPropagationManager.startExpiredQueueProcessing(5000L);
                this.queueSplitter = new QueueSplitterImpl(this.configurationResourceManager, "/playground/server/admin/v1/queueSplitters");
                this.queueSplitter.initialize();
                this.hookHandler = new HookHandler(this.vertx, (HttpClient)selfClient, this.storage, this.loggingResourceManager, this.logAppenderRepository, this.monitoringHandler, "/playground/server/users/v1/%s/profile", "/playground/server/hooks/v1/", (RequestQueue)queueClient, false, this.reducedPropagationManager, null, this.storage, 1, this.queueSplitter);
                this.hookHandler.enableResourceLogging(true);
                this.authorizer = new Authorizer(this.vertx, this.storage, "/playground/server/security/v1/", ROLE_PATTERN, ROLE_PREFIX, props);
                this.authorizer.enableResourceLogging(true);
                this.validationResourceManager = new ValidationResourceManager(this.vertx, this.storage, "/playground/server/admin/v1/validation");
                this.validationResourceManager.enableResourceLogging(true);
                this.validationSchemaProvider = new DefaultValidationSchemaProvider(this.vertx, new ClientRequestCreator((HttpClient)selfClient), Duration.ofSeconds(30L));
                this.validator = new Validator(this.storage, "/playground/schemas/apis/", this.validationSchemaProvider);
                this.validationHandler = new ValidationHandler(this.validationResourceManager, (HttpClient)selfClient, this.validator);
                KafkaProducerRepository kafkaProducerRepository = new KafkaProducerRepository(this.vertx);
                KafkaMessageSender kafkaMessageSender = new KafkaMessageSender();
                KafkaMessageValidator messageValidator = new KafkaMessageValidator(this.validationResourceManager, this.validator);
                this.kafkaHandler = KafkaHandler.builder().withVertx(this.vertx).withConfigurationResourceManager(this.configurationResourceManager).withKafkaMessageValidator(messageValidator).withRepository(kafkaProducerRepository).withKafkaMessageSender(kafkaMessageSender).withConfigResourceUri("/playground/server/admin/v1/kafka/topicsConfig").withStreamingPath("/playground/server/streaming/").build();
                this.kafkaHandler.initialize();
                this.schedulerResourceManager = new SchedulerResourceManager(this.vertx, redisProvider, this.storage, this.monitoringHandler, "/playground/server/admin/v1/schedulers", props);
                this.schedulerResourceManager.enableResourceLogging(true);
                this.zipExtractHandler = new ZipExtractHandler((HttpClient)selfClient);
                this.delegateHandler = new DelegateHandler(this.vertx, (HttpClient)selfClient, this.storage, "/playground/server/admin/v1/delegates/", props, null);
                this.delegateHandler.enableResourceLogging(true);
                this.customHttpResponseHandler = new CustomHttpResponseHandler(RETURN_HTTP_STATUS_ROOT);
                this.router = org.swisspush.gateleen.routing.Router.builder().withServerPath(SERVER_ROOT).withRulesPath(RULES_ROOT).withUserProfilePath("/playground/server/users/v1/%s/profile").withVertx(this.vertx).withSelfClient((HttpClient)selfClient).withStorage(this.storage).withStoragePort(this.storagePort).withInfo(info).withMonitoringHandler(this.monitoringHandler).withLoggingResourceManager(this.loggingResourceManager).withLogAppenderRepository(this.logAppenderRepository).withResourceLogging(true).withRoutingConfiguration(this.configurationResourceManager, "/playground/server/admin/v1/routing/config").withHttpClientFactory(this::createHttpClientForRouter).withOAuthProvider((OAuthProvider)new DefaultOAuthProvider(this.vertx)).addDoneHandler(aVoid -> {
                    this.hookHandler.init();
                    this.delegateHandler.init();
                }).build();
                QueueCircuitBreakerRulePatternToCircuitMapping rulePatternToCircuitMapping = new QueueCircuitBreakerRulePatternToCircuitMapping();
                this.queueCircuitBreakerConfigurationResourceManager = new QueueCircuitBreakerConfigurationResourceManager(this.vertx, this.storage, "/playground/server/admin/v1/circuitbreaker");
                this.queueCircuitBreakerConfigurationResourceManager.enableResourceLogging(true);
                RedisQueueCircuitBreakerStorage queueCircuitBreakerStorage = new RedisQueueCircuitBreakerStorage(redisProvider, this.exceptionFactory);
                QueueCircuitBreakerHttpRequestHandler requestHandler = new QueueCircuitBreakerHttpRequestHandler(this.vertx, (QueueCircuitBreakerStorage)queueCircuitBreakerStorage, "/playground/server/queuecircuitbreaker/circuit");
                QueueCircuitBreakerImpl queueCircuitBreaker = new QueueCircuitBreakerImpl(this.vertx, (Lock)lock, Address.redisquesAddress(), (QueueCircuitBreakerStorage)queueCircuitBreakerStorage, ruleProvider, this.exceptionFactory, rulePatternToCircuitMapping, this.queueCircuitBreakerConfigurationResourceManager, (Handler)requestHandler, this.circuitBreakerPort);
                new QueueProcessor(this.vertx, (HttpClient)selfClient, this.monitoringHandler, (QueueCircuitBreaker)queueCircuitBreaker);
                LogController logController = new LogController();
                logController.registerLogConfiguratorMBean(JMX_DOMAIN);
                ResetMetricsController resetMetricsController = new ResetMetricsController(this.vertx);
                resetMetricsController.registerResetMetricsControlMBean(JMX_DOMAIN, PREFIX);
                RunConfig runConfig = RunConfig.with().authorizer(this.authorizer).validationResourceManager(this.validationResourceManager).validationHandler(this.validationHandler).cacheHandler(this.cacheHandler).packingHandler(this.packingHandler).corsHandler(this.corsHandler).deltaHandler(this.deltaHandler).expansionHandler(this.expansionHandler).hookHandler(this.hookHandler).qosHandler(this.qosHandler).copyResourceHandler(this.copyResourceHandler).eventBusHandler(this.eventBusHandler).kafkaHandler(this.kafkaHandler).roleProfileHandler(this.roleProfileHandler).userProfileHandler(this.userProfileHandler).loggingResourceManager(this.loggingResourceManager).configurationResourceManager(this.configurationResourceManager).queueCircuitBreakerConfigurationResourceManager(this.queueCircuitBreakerConfigurationResourceManager).queueSplitter(this.queueSplitter).schedulerResourceManager(this.schedulerResourceManager).zipExtractHandler(this.zipExtractHandler).delegateHandler(this.delegateHandler).customHttpResponseHandler(this.customHttpResponseHandler).contentTypeConstraintHandler(this.contentTypeConstraintHandler).build(this.vertx, redisProvider, Server.class, this.router, this.monitoringHandler);
                Handler routingContextHandlerrNew = runConfig.buildRoutingContextHandler();
                this.routingContextHandlerRf.compareAndSet(null, (Handler<RoutingContext>)routingContextHandlerrNew);
                HttpServerOptions options = new HttpServerOptions();
                options.setHandle100ContinueAutomatically(true);
                this.mainServer = this.vertx.createHttpServer(options);
                Router vertxRouter = Router.router((Vertx)this.vertx);
                this.eventBusHandler.install(vertxRouter);
                vertxRouter.route().handler(routingContextHandlerrNew);
                this.mainServer.requestHandler((Handler)vertxRouter);
                this.mainServer.listen(this.mainPort);
            }
        });
    }

    private Handler<RoutingContext> getRoutingContext() {
        Handler<RoutingContext> routingContextHandler = this.routingContextHandlerRf.get();
        if (routingContextHandler == null) {
            this.log.debug("HuhWhat? Why is routingContextHandler null?");
        }
        return routingContextHandler;
    }

    private HttpClient createHttpClientForRouter(HttpClientOptions opts) {
        HttpClient client = this.vertx.createHttpClient(opts);
        client = new DeferCloseHttpClient(this.vertx, client);
        return client;
    }
}

