/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.qos;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class QoSRule {
    private Double reject;
    private Double warn;
    private Pattern urlPattern;
    private Set<String> actions;

    public QoSRule(Pattern urlPattern) {
        this.urlPattern = urlPattern;
        this.actions = new HashSet<String>();
    }

    public Double getReject() {
        return this.reject;
    }

    public void setReject(Double reject) {
        this.reject = reject;
    }

    public Double getWarn() {
        return this.warn;
    }

    public void setWarn(Double warn) {
        this.warn = warn;
    }

    public Pattern getUrlPattern() {
        return this.urlPattern;
    }

    public boolean performAction() {
        return !this.actions.isEmpty();
    }

    public List<String> getActions() {
        return new ArrayList<String>(this.actions);
    }

    public void addAction(String action) {
        this.actions.add(action);
    }

    public void removeAction(String action) {
        this.actions.remove(action);
    }

    public void clearAction() {
        this.actions.clear();
    }
}

