/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.qos;

import com.floreysoft.jmte.DefaultModelAdaptor;
import com.floreysoft.jmte.Engine;
import com.floreysoft.jmte.ErrorHandler;
import com.floreysoft.jmte.ModelAdaptor;
import com.floreysoft.jmte.TemplateContext;
import com.floreysoft.jmte.message.ParseException;
import com.floreysoft.jmte.token.Token;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.http.RequestLoggerFactory;
import org.swisspush.gateleen.core.logging.LoggableResource;
import org.swisspush.gateleen.core.logging.RequestLogger;
import org.swisspush.gateleen.core.storage.ResourceStorage;
import org.swisspush.gateleen.core.util.ResourcesUtils;
import org.swisspush.gateleen.core.util.ResponseStatusCodeLogUtil;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.core.validation.ValidationResult;
import org.swisspush.gateleen.qos.QoSConfig;
import org.swisspush.gateleen.qos.QoSRule;
import org.swisspush.gateleen.qos.QoSSentinel;
import org.swisspush.gateleen.validation.ValidationException;
import org.swisspush.gateleen.validation.Validator;

public class QoSHandler
implements LoggableResource {
    private static final Logger log = LoggerFactory.getLogger(QoSHandler.class);
    private static final String UPDATE_ADDRESS = "gateleen.qos-settings-updated";
    private static final String JSON_FIELD_CONFIG = "config";
    private static final String JSON_FIELD_SENTINELS = "sentinels";
    private static final String JSON_FIELD_RULES = "rules";
    private static final String PERCENTILE_SUFFIX = "thPercentile";
    protected static final String REJECT_ACTION = "reject";
    protected static final String WARN_ACTION = "warn";
    private final Vertx vertx;
    private final ResourceStorage storage;
    private final String qosSettingsUri;
    private final Map<String, Object> properties;
    private final String prefix;
    private final String qosSettingsSchema;
    private MBeanServer mbeanServer;
    private long timerId = -1L;
    private QoSConfig globalQoSConfig;
    private List<QoSRule> qosRules;
    private List<QoSSentinel> qosSentinels;
    private boolean logQosConfigurationChanges = false;

    public QoSHandler(Vertx vertx, ResourceStorage storage, String qosSettingsPath, Map<String, Object> properties, String prefix) {
        this.vertx = vertx;
        this.storage = storage;
        this.qosSettingsUri = qosSettingsPath;
        this.properties = properties;
        this.prefix = prefix;
        this.qosRules = new ArrayList<QoSRule>();
        this.setMBeanServer(ManagementFactory.getPlatformMBeanServer());
        this.qosSettingsSchema = ResourcesUtils.loadResource((String)"gateleen_qos_schema_config", (boolean)true);
        this.loadQoSSettings();
        this.registerUpdateHandler();
    }

    public void enableResourceLogging(boolean resourceLoggingEnabled) {
        this.logQosConfigurationChanges = resourceLoggingEnabled;
    }

    protected void setMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    private void loadQoSSettings() {
        this.storage.get(this.qosSettingsUri, buffer -> {
            if (buffer != null) {
                try {
                    log.info("Applying QoS settings");
                    this.updateQoSSettings((Buffer)buffer);
                }
                catch (IllegalArgumentException e) {
                    log.error("Could not reconfigure QoS", (Throwable)e);
                }
            } else {
                log.warn("Could not get URL '{}' (getting settings).", (Object)(this.qosSettingsUri == null ? "<null>" : this.qosSettingsUri));
            }
        });
    }

    private void registerUpdateHandler() {
        this.vertx.eventBus().consumer(UPDATE_ADDRESS, event -> this.loadQoSSettings());
    }

    public boolean handle(HttpServerRequest request) {
        if (this.isQoSSettingsUpdate(request)) {
            this.handleQoSSettingsUpdate(request);
            return true;
        }
        return this.qoSHandledRequest(request);
    }

    private boolean qoSHandledRequest(HttpServerRequest request) {
        for (QoSRule rule : this.qosRules) {
            if (!rule.performAction() || !rule.getUrlPattern().matcher(request.uri()).matches()) continue;
            boolean requestHandled = false;
            Iterator<String> iterator = rule.getActions().iterator();
            while (iterator.hasNext()) {
                String action;
                switch (action = iterator.next()) {
                    case "reject": {
                        this.handleReject(request);
                        requestHandled = true;
                        break;
                    }
                    case "warn": {
                        RequestLoggerFactory.getLogger(QoSHandler.class, (HttpServerRequest)request).warn("QoS Warning: Heavy load detected for rule {}, concerning the request {}", (Object)rule.getUrlPattern(), (Object)request.uri());
                    }
                }
            }
            return requestHandled;
        }
        return false;
    }

    private void handleReject(HttpServerRequest request) {
        ResponseStatusCodeLogUtil.info((HttpServerRequest)request, (StatusCode)StatusCode.SERVICE_UNAVAILABLE, QoSHandler.class);
        request.response().setStatusCode(StatusCode.SERVICE_UNAVAILABLE.getStatusCode());
        request.response().setStatusMessage(StatusCode.SERVICE_UNAVAILABLE.getStatusMessage());
        request.response().end();
    }

    private void validateConfigurationValues(Buffer qosSettingsBuffer) throws ValidationException {
        ValidationResult validationResult = Validator.validateStatic((Buffer)qosSettingsBuffer, (String)this.qosSettingsSchema, (Logger)log);
        if (!validationResult.isSuccess()) {
            throw new ValidationException(validationResult);
        }
        try {
            JsonObject qosSettings = this.parseQoSSettings(qosSettingsBuffer);
            QoSConfig config = this.createQoSConfig(qosSettings);
            List<QoSSentinel> sentinels = this.createQoSSentinels(qosSettings);
            List<QoSRule> rules = this.createQoSRules(qosSettings);
            this.extendedValidation(config, sentinels, rules);
        }
        catch (Exception ex) {
            throw new ValidationException((Throwable)ex);
        }
    }

    private void extendedValidation(QoSConfig config, List<QoSSentinel> sentinels, List<QoSRule> rules) throws ValidationException {
        if (!(config != null || sentinels.isEmpty() && rules.isEmpty())) {
            throw new ValidationException("QoS setting contains rules or sentinels without global config!");
        }
        if (sentinels.isEmpty() && !rules.isEmpty()) {
            throw new ValidationException("QoS settings contain rules without sentinels");
        }
    }

    private void handleQoSSettingsUpdate(HttpServerRequest request) {
        if (HttpMethod.PUT == request.method()) {
            request.bodyHandler(buffer -> {
                try {
                    this.validateConfigurationValues((Buffer)buffer);
                }
                catch (ValidationException validationException) {
                    log.error("Could not parse QoS config resource: {}", (Object)validationException.toString());
                    ResponseStatusCodeLogUtil.info((HttpServerRequest)request, (StatusCode)StatusCode.BAD_REQUEST, QoSHandler.class);
                    request.response().setStatusCode(StatusCode.BAD_REQUEST.getStatusCode());
                    request.response().setStatusMessage(StatusCode.BAD_REQUEST.getStatusMessage() + " " + validationException.getMessage());
                    if (validationException.getValidationDetails() != null) {
                        request.response().headers().add("content-type", "application/json");
                        request.response().end(validationException.getValidationDetails().encode());
                    } else {
                        request.response().end(validationException.getMessage());
                    }
                    return;
                }
                this.storage.put(this.qosSettingsUri, buffer, status -> {
                    if (status.intValue() == StatusCode.OK.getStatusCode()) {
                        if (this.logQosConfigurationChanges) {
                            RequestLogger.logRequest((EventBus)this.vertx.eventBus(), (HttpServerRequest)request, (int)status, (Buffer)buffer);
                        }
                        this.vertx.eventBus().publish(UPDATE_ADDRESS, (Object)true);
                    } else {
                        request.response().setStatusCode(status.intValue());
                    }
                    ResponseStatusCodeLogUtil.info((HttpServerRequest)request, (StatusCode)StatusCode.fromCode((int)status), QoSHandler.class);
                    request.response().end();
                });
            });
        } else {
            this.storage.delete(this.qosSettingsUri, status -> {
                if (status.intValue() == StatusCode.OK.getStatusCode()) {
                    this.vertx.eventBus().publish(UPDATE_ADDRESS, (Object)true);
                } else {
                    request.response().setStatusCode(status.intValue());
                }
                request.response().end();
            });
        }
    }

    protected QoSConfig createQoSConfig(JsonObject qosSettings) {
        if (qosSettings.containsKey(JSON_FIELD_CONFIG)) {
            JsonObject jsonConfig = qosSettings.getJsonObject(JSON_FIELD_CONFIG);
            return new QoSConfig(jsonConfig.getInteger("percentile"), jsonConfig.getInteger("quorum"), jsonConfig.getInteger("period"), jsonConfig.getInteger("minSampleCount"), jsonConfig.getInteger("minSentinelCount"));
        }
        return null;
    }

    protected List<QoSSentinel> createQoSSentinels(JsonObject qosSettings) {
        ArrayList<QoSSentinel> sentinels = new ArrayList<QoSSentinel>();
        if (qosSettings.containsKey(JSON_FIELD_SENTINELS)) {
            JsonObject jsonSentinels = qosSettings.getJsonObject(JSON_FIELD_SENTINELS);
            for (String sentinelName : jsonSentinels.fieldNames()) {
                log.debug("Creating a new QoS sentinel object for metric: {}", (Object)sentinelName);
                JsonObject jsonSentinel = jsonSentinels.getJsonObject(sentinelName);
                QoSSentinel sentinel = new QoSSentinel(sentinelName);
                QoSSentinel oldSentinel = this.getOldSentinel(sentinelName);
                if (oldSentinel != null) {
                    sentinel.setLowestPercentileValue(oldSentinel.getLowestPercentileValue());
                }
                if (jsonSentinel.containsKey("minLowestPercentileValueMs")) {
                    Double minLowestPercentileValueMs = jsonSentinel.getDouble("minLowestPercentileValueMs");
                    sentinel.setLowestPercentileMinValue(minLowestPercentileValueMs);
                    if (sentinel.getLowestPercentileValue() < minLowestPercentileValueMs) {
                        log.debug("Set lowest percentile value {} of sentinel '{}' to a minLowestPercentileValueMs value of {}", new Object[]{sentinel.getLowestPercentileValue(), sentinelName, minLowestPercentileValueMs});
                        sentinel.setLowestPercentileValue(minLowestPercentileValueMs);
                    }
                }
                if (jsonSentinel.containsKey("percentile")) {
                    sentinel.setPercentile(jsonSentinel.getInteger("percentile"));
                }
                sentinels.add(sentinel);
            }
        }
        return sentinels;
    }

    public QoSSentinel getOldSentinel(String sentinelName) {
        if (this.qosSentinels == null || this.qosSentinels.isEmpty()) {
            return null;
        }
        for (QoSSentinel sentinel : this.qosSentinels) {
            if (!sentinel.getName().equalsIgnoreCase(sentinelName)) continue;
            return sentinel;
        }
        return null;
    }

    private List<QoSRule> createQoSRules(JsonObject qosSettings) {
        ArrayList<QoSRule> rules = new ArrayList<QoSRule>();
        if (qosSettings.containsKey(JSON_FIELD_RULES)) {
            JsonObject jsonRules = qosSettings.getJsonObject(JSON_FIELD_RULES);
            for (String urlPatternRegExp : jsonRules.fieldNames()) {
                log.debug("Creating a new QoS rule object for URL pattern: {}", (Object)urlPatternRegExp);
                JsonObject jsonRule = jsonRules.getJsonObject(urlPatternRegExp);
                Pattern urlPattern = Pattern.compile(urlPatternRegExp);
                QoSRule rule = new QoSRule(urlPattern);
                boolean addRule = false;
                if (jsonRule.containsKey(REJECT_ACTION)) {
                    addRule = true;
                    rule.setReject(jsonRule.getDouble(REJECT_ACTION));
                }
                if (jsonRule.containsKey(WARN_ACTION)) {
                    addRule = true;
                    rule.setWarn(jsonRule.getDouble(WARN_ACTION));
                }
                if (addRule) {
                    rules.add(rule);
                    continue;
                }
                log.warn("No or unknown QoS action defined for rule {}. This rule will not be loaded!", (Object)urlPatternRegExp);
            }
        }
        return rules;
    }

    protected JsonObject parseQoSSettings(Buffer buffer) {
        try {
            return new JsonObject(this.replaceConfigWildcards(buffer.toString("UTF-8")));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String replaceConfigWildcards(String configWithWildcards) {
        Engine engine = new Engine();
        engine.setModelAdaptor((ModelAdaptor)new DefaultModelAdaptor(){

            public Object getValue(TemplateContext context, Token arg1, List<String> arg2, String expression) {
                Object value = context.model.get((Object)expression);
                if (value != null) {
                    return value;
                }
                return super.getValue(context, arg1, arg2, expression);
            }

            protected Object traverse(Object obj, List<String> arg1, int arg2, ErrorHandler arg3, Token token) {
                if (obj == null) {
                    throw new IllegalArgumentException("Could not resolve " + token);
                }
                return super.traverse(obj, arg1, arg2, arg3, token);
            }
        });
        try {
            return engine.transform(configWithWildcards, this.properties);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private boolean isQoSSettingsUpdate(HttpServerRequest request) {
        return request.uri().equals(this.qosSettingsUri) && (HttpMethod.PUT == request.method() || HttpMethod.DELETE == request.method());
    }

    private void updateQoSSettings(Buffer buffer) {
        log.info("About to update QoS settings with content: {}", (Object)buffer.toString());
        ValidationResult validationResult = Validator.validateStatic((Buffer)buffer, (String)this.qosSettingsSchema, (Logger)log);
        if (!validationResult.isSuccess()) {
            log.error("QoS is disabled now. Got invalid QoS settings from storage");
            return;
        }
        this.cancelTimer();
        JsonObject qosSettings = this.parseQoSSettings(buffer);
        QoSConfig config = this.createQoSConfig(qosSettings);
        List<QoSSentinel> sentinels = this.createQoSSentinels(qosSettings);
        List<QoSRule> rules = this.createQoSRules(qosSettings);
        try {
            this.extendedValidation(config, sentinels, rules);
        }
        catch (ValidationException e) {
            log.error("QoS is disabled now. Message: {}", (Object)e.getMessage());
            return;
        }
        this.setGlobalQoSConfig(config);
        this.setQosSentinels(sentinels);
        this.setQosRules(rules);
        if (!this.qosSentinels.isEmpty() && !this.qosRules.isEmpty()) {
            log.debug("Start periodic timer every {}s", (Object)this.globalQoSConfig.getPeriod());
            this.timerId = this.vertx.setPeriodic((long)(this.globalQoSConfig.getPeriod() * 1000), event -> {
                log.debug("Timer fired: executing evaluateQoSActions");
                this.evaluateQoSActions();
            });
        } else {
            log.info("QoS is disabled now. No rules and sentinels found.");
        }
    }

    protected void cancelTimer() {
        log.debug("About to cancel timer");
        this.vertx.cancelTimer(this.timerId);
    }

    protected void evaluateQoSActions() {
        if (log.isTraceEnabled()) {
            Set<ObjectInstance> instances = this.mbeanServer.queryMBeans(null, null);
            for (ObjectInstance objectInstance : instances) {
                log.trace("MBean Found:");
                log.trace("Class Name:t" + objectInstance.getClassName());
                log.trace("Object Name:t" + objectInstance.getObjectName());
                log.trace("****************************************");
            }
        }
        int validSentinels = 0;
        ArrayList<Double> currentSentinelRatios = new ArrayList<Double>();
        for (QoSSentinel sentinel : this.qosSentinels) {
            String name = "metrics:name=" + this.prefix + "routing." + sentinel.getName() + ".duration";
            try {
                ObjectName beanName = new ObjectName(name);
                if (this.mbeanServer.isRegistered(beanName)) {
                    long currentSampleCount = (Long)this.mbeanServer.getAttribute(beanName, "Count");
                    if (currentSampleCount >= (long)this.globalQoSConfig.getMinSampleCount()) {
                        double currentResponseTime = 0.0;
                        currentResponseTime = sentinel.getPercentile() != null ? ((Double)this.mbeanServer.getAttribute(beanName, sentinel.getPercentile() + PERCENTILE_SUFFIX)).doubleValue() : ((Double)this.mbeanServer.getAttribute(beanName, this.globalQoSConfig.getPercentile() + PERCENTILE_SUFFIX)).doubleValue();
                        if (sentinel.getLowestPercentileValue() > currentResponseTime) {
                            if (currentResponseTime > 0.0) {
                                if (sentinel.getLowestPercentileMinValue() != null && currentResponseTime < sentinel.getLowestPercentileMinValue()) {
                                    sentinel.setLowestPercentileValue(sentinel.getLowestPercentileMinValue());
                                } else {
                                    sentinel.setLowestPercentileValue(currentResponseTime);
                                }
                            } else {
                                log.debug("ignoring response time of 0.0, because the metric is probably not yet fully initalized");
                            }
                        }
                        double currentRatio = currentResponseTime / sentinel.getLowestPercentileValue();
                        currentSentinelRatios.add(currentRatio);
                        log.debug("sentinel '{}': percentile={}, lowestPercentileValue={}, lowestPercentileMinValue={}, currentSampleCount={}, currentResponseTime={}, currentRatio={}", new Object[]{sentinel.getName(), sentinel.getPercentile(), sentinel.getLowestPercentileValue(), sentinel.getLowestPercentileMinValue(), currentSampleCount, currentResponseTime, currentRatio});
                        ++validSentinels;
                        continue;
                    }
                    log.warn("Sentinel {} doesn't have enough samples yet ({}/{})", new Object[]{sentinel.getName(), currentSampleCount, this.globalQoSConfig.getMinSampleCount()});
                    continue;
                }
                log.warn("MBean {} for sentinel {} is not ready yet ...", (Object)name, (Object)sentinel.getName());
            }
            catch (MalformedObjectNameException e) {
                log.error("Could not load MBean for metric name '" + sentinel.getName() + "'.", (Throwable)e);
            }
            catch (AttributeNotFoundException e) {
            }
            catch (InstanceNotFoundException e) {
                log.error("Could not find attribute " + sentinel.getPercentile() + "thPercentile for the MBean of the metric '" + sentinel.getName() + "'.", (Throwable)e);
            }
            catch (MBeanException | ReflectionException e) {
                log.error("Could not load value of attribute " + sentinel.getPercentile() + "thPercentile for the MBean of the metric '" + sentinel.getName() + "'.", (Throwable)e);
            }
        }
        if (validSentinels >= this.globalQoSConfig.getMinSentinelCount()) {
            int n = (int)Math.ceil((double)validSentinels / 100.0 * (double)this.globalQoSConfig.getQuorum()) - 1;
            currentSentinelRatios.sort(Collections.reverseOrder());
            if (log.isTraceEnabled()) {
                Iterator<Object> iterator = currentSentinelRatios.iterator();
                while (iterator.hasNext()) {
                    double sentinelRatio = (Double)iterator.next();
                    log.trace(" -> {}", (Object)sentinelRatio);
                }
            }
            log.debug("Sentinels count: {}", (Object)validSentinels);
            log.debug("Sentinels ratios: {}", currentSentinelRatios);
            log.debug("Threshold index: {}", (Object)n);
            log.debug("Threshold ratio: {}", currentSentinelRatios.get(n));
            for (QoSRule rule : this.qosRules) {
                Double warn = rule.getWarn();
                Double reject = rule.getReject();
                if (this.actionNecessary(reject, (Double)currentSentinelRatios.get(n))) {
                    log.debug("rule will be rejected: {}", (Object)rule.getUrlPattern());
                    rule.addAction(REJECT_ACTION);
                } else {
                    log.debug("rule will not be rejected: {}", (Object)rule.getUrlPattern());
                    rule.removeAction(REJECT_ACTION);
                }
                if (this.actionNecessary(warn, (Double)currentSentinelRatios.get(n))) {
                    log.debug("rule will be logged with a warning: {}", (Object)rule.getUrlPattern());
                    rule.addAction(WARN_ACTION);
                    continue;
                }
                log.debug("rule will not be logged with a warning: {}", (Object)rule.getUrlPattern());
                rule.removeAction(WARN_ACTION);
            }
        } else {
            this.qosRules.forEach(QoSRule::clearAction);
        }
    }

    protected boolean actionNecessary(Double ratio, double thresholdSentinelRatio) {
        return ratio != null && ratio <= thresholdSentinelRatio;
    }

    protected void setGlobalQoSConfig(QoSConfig globalQoSConfig) {
        this.globalQoSConfig = globalQoSConfig;
    }

    protected List<QoSRule> getQosRules() {
        return this.qosRules;
    }

    protected void setQosRules(List<QoSRule> qosRules) {
        this.qosRules = qosRules;
    }

    protected void setQosSentinels(List<QoSSentinel> qosSentinels) {
        this.qosSentinels = qosSentinels;
    }

    protected List<QoSSentinel> getQosSentinels() {
        return this.qosSentinels;
    }
}

