/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.queue.queuing;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.Message;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import org.swisspush.gateleen.core.http.HttpRequest;
import org.swisspush.gateleen.core.util.Address;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.monitoring.MonitoringHandler;
import org.swisspush.gateleen.queue.queuing.RequestQueue;
import org.swisspush.redisques.util.RedisquesAPI;

public class QueueClient
implements RequestQueue {
    public static final String QUEUE_TIMESTAMP = "queueTimestamp";
    private MonitoringHandler monitoringHandler;
    private Vertx vertx;

    public QueueClient(Vertx vertx, MonitoringHandler monitoringHandler) {
        this.vertx = vertx;
        this.monitoringHandler = monitoringHandler;
    }

    protected String getRedisquesAddress() {
        return Address.redisquesAddress();
    }

    @Override
    public void enqueue(HttpServerRequest request, Buffer buffer, String queue) {
        this.enqueue(request, request.headers(), buffer, queue);
    }

    @Override
    public void enqueue(HttpServerRequest request, MultiMap headers, Buffer buffer, String queue) {
        HttpRequest queuedRequest = new HttpRequest(request.method(), request.uri(), headers, buffer.getBytes());
        this.enqueue(request, queuedRequest, queue);
    }

    @Override
    public void enqueue(HttpRequest request, String queue) {
        this.enqueue(null, request, queue);
    }

    @Override
    public void enqueue(HttpRequest request, String queue, Handler<Void> doneHandler) {
        this.enqueue(null, request, queue, doneHandler);
    }

    private void enqueue(HttpServerRequest request, HttpRequest queuedRequest, String queue) {
        this.enqueue(request, queuedRequest, queue, null);
    }

    private void enqueue(final HttpServerRequest request, HttpRequest queuedRequest, final String queue, final Handler<Void> doneHandler) {
        this.vertx.eventBus().send(this.getRedisquesAddress(), (Object)RedisquesAPI.buildEnqueueOperation((String)queue, (String)queuedRequest.toJsonObject().put(QUEUE_TIMESTAMP, Long.valueOf(System.currentTimeMillis())).encode()), (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> event) {
                if ("ok".equals(((JsonObject)((Message)event.result()).body()).getString("status"))) {
                    QueueClient.this.monitoringHandler.updateLastUsedQueueSizeInformation(queue);
                    QueueClient.this.monitoringHandler.updateEnqueue();
                    if (request != null) {
                        request.response().setStatusCode(StatusCode.ACCEPTED.getStatusCode());
                        request.response().setStatusMessage(StatusCode.ACCEPTED.getStatusMessage());
                        request.response().end();
                    }
                } else if (request != null) {
                    request.response().setStatusCode(StatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
                    request.response().setStatusMessage(StatusCode.INTERNAL_SERVER_ERROR.getStatusMessage());
                    request.response().end(((JsonObject)((Message)event.result()).body()).getString("message"));
                }
                if (doneHandler != null) {
                    doneHandler.handle(null);
                }
            }
        });
    }
}

