/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.queue.expiry;

import io.vertx.core.MultiMap;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.http.HttpServerRequest;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.http.HttpRequest;

public final class ExpiryCheckHandler {
    public static final String SERVER_TIMESTAMP_HEADER = "X-Server-Timestamp";
    public static final String EXPIRE_AFTER_HEADER = "X-Expire-After";
    private static Logger log = LoggerFactory.getLogger(ExpiryCheckHandler.class);
    private static DateTimeFormatter dfISO8601 = ISODateTimeFormat.dateTime().withZone(DateTimeZone.forID((String)"Europe/Zurich"));
    private static DateTimeFormatter dfISO8601Parser = ISODateTimeFormat.dateTimeParser().withZone(DateTimeZone.forID((String)"Europe/Zurich"));
    private static DateTimeFormatter isoDateTimeParser = ISODateTimeFormat.dateTimeParser();

    private ExpiryCheckHandler() {
    }

    public static void updateServerTimestampHeader(HttpRequest request) {
        if (request.getHeaders() == null) {
            request.setHeaders((MultiMap)new CaseInsensitiveHeaders());
        }
        ExpiryCheckHandler.updateServerTimestampHeader(request.getHeaders());
    }

    public static void updateServerTimestampHeader(HttpServerRequest request) {
        ExpiryCheckHandler.updateServerTimestampHeader(request.headers());
    }

    public static void updateServerTimestampHeader(MultiMap headers) {
        String serverTimestamp = headers.get(SERVER_TIMESTAMP_HEADER);
        if (serverTimestamp == null) {
            String nowAsISO = dfISO8601.print((ReadableInstant)Instant.now());
            log.debug("Setting X-Server-Timestamp value to " + nowAsISO + "  since header " + EXPIRE_AFTER_HEADER + " is not defined");
            headers.set(SERVER_TIMESTAMP_HEADER, nowAsISO);
        } else {
            String updatedTimestamp = ExpiryCheckHandler.localizeTimestamp(serverTimestamp);
            if (!updatedTimestamp.equals(serverTimestamp)) {
                log.debug("UpdatingX-Server-Timestamp value from " + serverTimestamp + "  to " + updatedTimestamp);
                headers.remove(SERVER_TIMESTAMP_HEADER);
                headers.set(SERVER_TIMESTAMP_HEADER, updatedTimestamp);
            }
        }
    }

    public static Integer getExpireAfter(MultiMap headers) {
        Integer value;
        String expireAfterHeaderValue = headers.get(EXPIRE_AFTER_HEADER);
        if (expireAfterHeaderValue == null) {
            log.debug("X-Expire-After not defined");
            value = null;
        } else {
            try {
                value = Integer.parseInt(expireAfterHeaderValue);
                if (value < 0) {
                    log.debug("X-Expire-After is a negative number: " + expireAfterHeaderValue);
                    value = null;
                } else {
                    log.debug("Setting X-Expire-After value to " + value + " seconds as defined in header " + EXPIRE_AFTER_HEADER);
                }
            }
            catch (Exception e) {
                log.warn("X-Expire-After is not a number: " + expireAfterHeaderValue);
                value = null;
            }
        }
        return value;
    }

    public static boolean isExpired(HttpRequest request) {
        return ExpiryCheckHandler.isExpired(request.getHeaders());
    }

    public static boolean isExpired(HttpServerRequest request) {
        return ExpiryCheckHandler.isExpired(request.headers());
    }

    public static boolean isExpired(MultiMap headers) {
        if (headers != null) {
            Integer expireAfter = ExpiryCheckHandler.getExpireAfter(headers);
            String serverTimestamp = headers.get(SERVER_TIMESTAMP_HEADER);
            if (serverTimestamp != null && expireAfter != null) {
                LocalDateTime timestamp = ExpiryCheckHandler.parseDateTime(serverTimestamp);
                LocalDateTime expirationTime = ExpiryCheckHandler.getExpirationTime(timestamp, (int)expireAfter);
                LocalDateTime now = ExpiryCheckHandler.getActualTime();
                log.debug(" > isExpired - timestamp " + timestamp + " | expirationTime " + expirationTime + " | now " + now);
                return expirationTime.isBefore((ReadablePartial)now);
            }
        }
        return false;
    }

    public static LocalDateTime getActualTime() {
        return dfISO8601Parser.parseLocalDateTime(dfISO8601.print((ReadableInstant)Instant.now()));
    }

    public static LocalDateTime getExpirationTime(int expireAfter) {
        return ExpiryCheckHandler.getExpirationTime(ExpiryCheckHandler.getActualTime(), expireAfter);
    }

    public static LocalDateTime getExpirationTime(String serverTimestamp, int expireAfter) {
        return ExpiryCheckHandler.getExpirationTime(ExpiryCheckHandler.parseDateTime(serverTimestamp), expireAfter);
    }

    public static LocalDateTime parseDateTime(String datetime) {
        return dfISO8601Parser.parseLocalDateTime(ExpiryCheckHandler.localizeTimestamp(datetime));
    }

    public static String printDateTime(LocalDateTime datetime) {
        return dfISO8601.print((ReadablePartial)datetime);
    }

    private static LocalDateTime getExpirationTime(LocalDateTime timestamp, int expireAfter) {
        LocalDateTime expirationTime = timestamp.plusSeconds(expireAfter);
        log.debug("getExpirationTime: " + expirationTime);
        return expirationTime;
    }

    public static void setExpireAfter(HttpRequest request, int expireAfter) {
        if (request.getHeaders() == null) {
            request.setHeaders((MultiMap)new CaseInsensitiveHeaders());
        }
        ExpiryCheckHandler.setExpireAfter(request.getHeaders(), expireAfter);
    }

    public static void setExpireAfter(HttpServerRequest request, int expireAfter) {
        ExpiryCheckHandler.setExpireAfter(request.headers(), expireAfter);
    }

    public static void setExpireAfter(MultiMap headers, int expireAfter) {
        if (headers.get(EXPIRE_AFTER_HEADER) != null) {
            headers.remove(EXPIRE_AFTER_HEADER);
        }
        headers.set(EXPIRE_AFTER_HEADER, String.valueOf(expireAfter));
    }

    private static String localizeTimestamp(String timestamp) {
        String localizedTimestamp = timestamp;
        if (localizedTimestamp != null && localizedTimestamp.toUpperCase().endsWith("Z")) {
            try {
                DateTime dt = isoDateTimeParser.parseDateTime(localizedTimestamp);
                localizedTimestamp = dfISO8601.print((ReadableInstant)dt);
            }
            catch (IllegalArgumentException e) {
                log.warn("Could not parse: " + localizedTimestamp);
            }
        }
        return localizedTimestamp;
    }
}

