/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.queue.queuing.circuitbreaker.configuration;

import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.logging.LoggableResource;
import org.swisspush.gateleen.core.logging.RequestLogger;
import org.swisspush.gateleen.core.refresh.Refreshable;
import org.swisspush.gateleen.core.storage.ResourceStorage;
import org.swisspush.gateleen.core.util.ResourcesUtils;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.core.validation.ValidationResult;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.configuration.QueueCircuitBreakerConfigurationResource;
import org.swisspush.gateleen.validation.ValidationException;
import org.swisspush.gateleen.validation.Validator;

public class QueueCircuitBreakerConfigurationResourceManager
implements LoggableResource {
    private static final String UPDATE_ADDRESS = "gateleen.queue-circuit-breaker.config-updated";
    private boolean logConfigurationResourceChanges = false;
    private final String circuitBreakerConfigUri;
    private final ResourceStorage storage;
    private final Logger log = LoggerFactory.getLogger(QueueCircuitBreakerConfigurationResourceManager.class);
    private final Vertx vertx;
    private QueueCircuitBreakerConfigurationResource configurationResource;
    private final List<Refreshable> refreshables;
    private final String configResourceSchema;

    public QueueCircuitBreakerConfigurationResourceManager(Vertx vertx, ResourceStorage storage, String circuitBreakerConfigUri) {
        this.vertx = vertx;
        this.storage = storage;
        this.circuitBreakerConfigUri = circuitBreakerConfigUri;
        this.configResourceSchema = ResourcesUtils.loadResource((String)"gateleen_queue_schema_circuitBreakerConfiguration", (boolean)true);
        this.refreshables = new ArrayList<Refreshable>();
        this.updateConfigurationResource();
        vertx.eventBus().consumer(UPDATE_ADDRESS, event -> this.updateConfigurationResource());
    }

    public QueueCircuitBreakerConfigurationResource getConfigurationResource() {
        if (this.configurationResource == null) {
            this.configurationResource = new QueueCircuitBreakerConfigurationResource();
        }
        return this.configurationResource;
    }

    public void enableResourceLogging(boolean resourceLoggingEnabled) {
        this.logConfigurationResourceChanges = resourceLoggingEnabled;
    }

    public void addRefreshable(Refreshable refreshable) {
        this.refreshables.add(refreshable);
    }

    public boolean handleConfigurationResource(HttpServerRequest request) {
        if (request.uri().equals(this.circuitBreakerConfigUri) && HttpMethod.PUT == request.method()) {
            request.bodyHandler(configResourceBuffer -> {
                try {
                    this.extractConfigurationValues((Buffer)configResourceBuffer);
                }
                catch (ValidationException validationException) {
                    this.log.error("Could not parse circuit breaker configuration resource: " + validationException.toString());
                    request.response().setStatusCode(StatusCode.BAD_REQUEST.getStatusCode());
                    request.response().setStatusMessage(StatusCode.BAD_REQUEST.getStatusMessage() + " " + validationException.getMessage());
                    if (validationException.getValidationDetails() != null) {
                        request.response().headers().add("content-type", "application/json");
                        request.response().end(validationException.getValidationDetails().encode());
                    } else {
                        request.response().end(validationException.getMessage());
                    }
                    return;
                }
                this.storage.put(this.circuitBreakerConfigUri, configResourceBuffer, status -> {
                    if (status.intValue() == StatusCode.OK.getStatusCode()) {
                        if (this.logConfigurationResourceChanges) {
                            RequestLogger.logRequest((EventBus)this.vertx.eventBus(), (HttpServerRequest)request, (int)StatusCode.OK.getStatusCode(), (Buffer)configResourceBuffer);
                        }
                        this.vertx.eventBus().publish(UPDATE_ADDRESS, (Object)true);
                    } else {
                        request.response().setStatusCode(status.intValue());
                    }
                    request.response().end();
                });
            });
            return true;
        }
        if (request.uri().equals(this.circuitBreakerConfigUri) && HttpMethod.DELETE == request.method()) {
            this.getConfigurationResource().reset();
            this.log.info("reset circuit breaker configuration resource");
            this.notifyRefreshables();
        }
        return false;
    }

    private void notifyRefreshables() {
        this.refreshables.forEach(Refreshable::refresh);
    }

    private void updateConfigurationResource() {
        this.storage.get(this.circuitBreakerConfigUri, buffer -> {
            if (buffer != null) {
                try {
                    this.extractConfigurationValues((Buffer)buffer);
                    this.log.info("Applying circuit breaker configuration values : " + this.getConfigurationResource().toString());
                }
                catch (ValidationException e) {
                    this.log.warn("Could not reconfigure circuitbreaker", (Throwable)e);
                }
            } else {
                this.log.warn("Could not get URL '" + (this.circuitBreakerConfigUri == null ? "<null>" : this.circuitBreakerConfigUri) + "'.");
            }
            this.notifyRefreshables();
        });
    }

    private void extractConfigurationValues(Buffer configResourceBuffer) throws ValidationException {
        ValidationResult validationResult = Validator.validateStatic((Buffer)configResourceBuffer, (String)this.configResourceSchema, (Logger)this.log);
        if (!validationResult.isSuccess()) {
            throw new ValidationException(validationResult);
        }
        try {
            JsonObject configRes = new JsonObject(configResourceBuffer.toString("UTF-8"));
            this.getConfigurationResource().reset();
            this.getConfigurationResource().setCircuitCheckEnabled(configRes.getBoolean("circuitCheckEnabled"));
            this.getConfigurationResource().setStatisticsUpdateEnabled(configRes.getBoolean("statisticsUpdateEnabled"));
            this.getConfigurationResource().setErrorThresholdPercentage(configRes.getInteger("errorThresholdPercentage"));
            this.getConfigurationResource().setEntriesMaxAgeMS(configRes.getInteger("entriesMaxAgeMS"));
            this.getConfigurationResource().setMinQueueSampleCount(configRes.getInteger("minQueueSampleCount"));
            this.getConfigurationResource().setMaxQueueSampleCount(configRes.getInteger("maxQueueSampleCount"));
            JsonObject openToHalfOpen = configRes.getJsonObject("openToHalfOpen");
            this.getConfigurationResource().setOpenToHalfOpenTaskEnabled(openToHalfOpen.getBoolean("enabled"));
            this.getConfigurationResource().setOpenToHalfOpenTaskInterval(openToHalfOpen.getInteger("interval"));
            JsonObject unlockQueues = configRes.getJsonObject("unlockQueues");
            this.getConfigurationResource().setUnlockQueuesTaskEnabled(unlockQueues.getBoolean("enabled"));
            this.getConfigurationResource().setUnlockQueuesTaskInterval(unlockQueues.getInteger("interval"));
            JsonObject unlockSampleQueues = configRes.getJsonObject("unlockSampleQueues");
            this.getConfigurationResource().setUnlockSampleQueuesTaskEnabled(unlockSampleQueues.getBoolean("enabled"));
            this.getConfigurationResource().setUnlockSampleQueuesTaskInterval(unlockSampleQueues.getInteger("interval"));
        }
        catch (Exception ex) {
            this.getConfigurationResource().reset();
            throw new ValidationException((Throwable)ex);
        }
    }
}

