/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.queue.queuing.circuitbreaker.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.swisspush.gateleen.core.http.HttpRequest;
import org.swisspush.gateleen.core.refresh.Refreshable;
import org.swisspush.gateleen.core.util.Address;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.QueueCircuitBreaker;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.QueueCircuitBreakerStorage;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.configuration.QueueCircuitBreakerConfigurationResource;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.configuration.QueueCircuitBreakerConfigurationResourceManager;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.util.PatternAndCircuitHash;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.util.QueueCircuitBreakerRulePatternToCircuitMapping;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.util.QueueCircuitState;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.util.QueueResponseType;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.util.UpdateStatisticsResult;
import org.swisspush.gateleen.routing.Rule;
import org.swisspush.gateleen.routing.RuleProvider;
import org.swisspush.redisques.util.RedisquesAPI;

public class QueueCircuitBreakerImpl
implements QueueCircuitBreaker,
RuleProvider.RuleChangesObserver,
Refreshable {
    private Logger log = LoggerFactory.getLogger(QueueCircuitBreakerImpl.class);
    private Vertx vertx;
    private QueueCircuitBreakerStorage queueCircuitBreakerStorage;
    private QueueCircuitBreakerRulePatternToCircuitMapping ruleToCircuitMapping;
    private QueueCircuitBreakerConfigurationResourceManager configResourceManager;
    private String redisquesAddress;
    private long openToHalfOpenTimerId = -1L;
    private long unlockQueuesTimerId = -1L;
    private long unlockSampleQueuesTimerId = -1L;

    public QueueCircuitBreakerImpl(Vertx vertx, QueueCircuitBreakerStorage queueCircuitBreakerStorage, RuleProvider ruleProvider, QueueCircuitBreakerRulePatternToCircuitMapping ruleToCircuitMapping, QueueCircuitBreakerConfigurationResourceManager configResourceManager, Handler<HttpServerRequest> queueCircuitBreakerHttpRequestHandler, int requestHandlerPort) {
        this(vertx, Address.redisquesAddress(), queueCircuitBreakerStorage, ruleProvider, ruleToCircuitMapping, configResourceManager, queueCircuitBreakerHttpRequestHandler, requestHandlerPort);
    }

    public QueueCircuitBreakerImpl(Vertx vertx, String redisquesAddress, QueueCircuitBreakerStorage queueCircuitBreakerStorage, RuleProvider ruleProvider, QueueCircuitBreakerRulePatternToCircuitMapping ruleToCircuitMapping, QueueCircuitBreakerConfigurationResourceManager configResourceManager, Handler<HttpServerRequest> queueCircuitBreakerHttpRequestHandler, int requestHandlerPort) {
        this.vertx = vertx;
        this.redisquesAddress = redisquesAddress;
        this.queueCircuitBreakerStorage = queueCircuitBreakerStorage;
        ruleProvider.registerObserver((RuleProvider.RuleChangesObserver)this);
        this.ruleToCircuitMapping = ruleToCircuitMapping;
        this.configResourceManager = configResourceManager;
        this.configResourceManager.addRefreshable(this);
        this.registerPeriodicTasks();
        HttpServerOptions options = new HttpServerOptions().setHandle100ContinueAutomatically(true);
        vertx.createHttpServer(options).requestHandler(queueCircuitBreakerHttpRequestHandler).listen(requestHandlerPort, event -> {
            if (event.succeeded()) {
                this.log.info((Object)("Successfully listening to port " + requestHandlerPort));
            } else {
                this.log.error((Object)("Unable to listen to port " + requestHandlerPort + ". Cannot handle QueueCircuitBreaker http requests"));
            }
        });
    }

    private void registerPeriodicTasks() {
        this.registerOpenToHalfOpenTask();
        this.registerUnlockQueuesTask();
        this.registerUnlockSampleQueuesTask();
    }

    private void registerOpenToHalfOpenTask() {
        boolean openToHalfOpenTaskEnabled = this.getConfig().isOpenToHalfOpenTaskEnabled();
        this.vertx.cancelTimer(this.openToHalfOpenTimerId);
        if (openToHalfOpenTaskEnabled) {
            this.openToHalfOpenTimerId = this.vertx.setPeriodic((long)this.getConfig().getOpenToHalfOpenTaskInterval(), event -> this.setOpenCircuitsToHalfOpen().setHandler(event1 -> {
                if (event1.succeeded()) {
                    if ((Long)event1.result() > 0L) {
                        this.log.info((Object)("Successfully changed " + event1.result() + " circuits from state open to state half-open"));
                    } else {
                        this.log.info((Object)"No open circuits to change state to half-open");
                    }
                } else {
                    this.log.error((Object)event1.cause().getMessage());
                }
            }));
        }
    }

    private void registerUnlockQueuesTask() {
        boolean unlockQueuesTaskEnabled = this.getConfig().isUnlockQueuesTaskEnabled();
        this.vertx.cancelTimer(this.unlockQueuesTimerId);
        if (unlockQueuesTaskEnabled) {
            this.unlockQueuesTimerId = this.vertx.setPeriodic((long)this.getConfig().getUnlockQueuesTaskInterval(), event -> this.unlockNextQueue().setHandler(event1 -> {
                if (event1.succeeded()) {
                    if (event1.result() == null) {
                        this.log.info((Object)"No locked queues to unlock");
                    } else {
                        this.log.info((Object)("Successfully unlocked queue '" + (String)event1.result() + "'"));
                    }
                } else {
                    this.log.error((Object)("Unable to unlock queue '" + event1.cause().getMessage() + "'"));
                }
            }));
        }
    }

    private void registerUnlockSampleQueuesTask() {
        boolean unlockSampleQueuesTaskEnabled = this.getConfig().isUnlockSampleQueuesTaskEnabled();
        this.vertx.cancelTimer(this.unlockSampleQueuesTimerId);
        if (unlockSampleQueuesTaskEnabled) {
            this.unlockSampleQueuesTimerId = this.vertx.setPeriodic((long)this.getConfig().getUnlockSampleQueuesTaskInterval(), event -> this.unlockSampleQueues().setHandler(event1 -> {
                if (event1.succeeded()) {
                    if ((Long)event1.result() == 0L) {
                        this.log.info((Object)"No sample queues to unlock");
                    } else {
                        this.log.info((Object)("Successfully unlocked " + event1.result() + " sample queues"));
                    }
                } else {
                    this.log.error((Object)event1.cause().getMessage());
                }
            }));
        }
    }

    public void rulesChanged(List<Rule> rules) {
        this.log.info((Object)"rules have changed, renew rule to circuit mapping");
        List<PatternAndCircuitHash> removedEntries = this.ruleToCircuitMapping.updateRulePatternToCircuitMapping(rules);
        this.log.info((Object)(removedEntries.size() + " mappings have been removed with the update"));
        removedEntries.forEach(this::closeAndRemoveCircuit);
    }

    public void refresh() {
        this.log.info((Object)"Circuit breaker configuration values have changed. Check periodic tasks");
        this.registerPeriodicTasks();
    }

    @Override
    public boolean isCircuitCheckEnabled() {
        return this.configResourceManager.getConfigurationResource().isCircuitCheckEnabled();
    }

    @Override
    public boolean isStatisticsUpdateEnabled() {
        return this.configResourceManager.getConfigurationResource().isStatisticsUpdateEnabled();
    }

    @Override
    public Future<QueueCircuitState> handleQueuedRequest(String queueName, HttpRequest queuedRequest) {
        Future future = Future.future();
        PatternAndCircuitHash patternAndCircuitHash = this.getPatternAndCircuitHashFromRequest(queuedRequest);
        if (patternAndCircuitHash != null) {
            this.queueCircuitBreakerStorage.getQueueCircuitState(patternAndCircuitHash).setHandler(event -> {
                if (event.failed()) {
                    future.fail(event.cause());
                } else {
                    future.complete(event.result());
                    if (QueueCircuitState.OPEN == event.result()) {
                        this.lockQueueSync(queueName, queuedRequest);
                    }
                }
            });
        } else {
            this.failWithNoRuleToCircuitMappingMessage(future, queueName, queuedRequest);
        }
        return future;
    }

    @Override
    public Future<Void> updateStatistics(String queueName, HttpRequest queuedRequest, QueueResponseType queueResponseType) {
        Future future = Future.future();
        String requestId = this.getRequestUniqueId(queuedRequest);
        long currentTS = System.currentTimeMillis();
        PatternAndCircuitHash patternAndCircuitHash = this.getPatternAndCircuitHashFromRequest(queuedRequest);
        if (patternAndCircuitHash != null) {
            int errorThresholdPercentage = this.getConfig().getErrorThresholdPercentage();
            int entriesMaxAgeMS = this.getConfig().getEntriesMaxAgeMS();
            int minQueueSampleCount = this.getConfig().getMinQueueSampleCount();
            int maxQueueSampleCount = this.getConfig().getMaxQueueSampleCount();
            this.queueCircuitBreakerStorage.updateStatistics(patternAndCircuitHash, requestId, currentTS, errorThresholdPercentage, entriesMaxAgeMS, minQueueSampleCount, maxQueueSampleCount, queueResponseType).setHandler(event -> {
                if (event.failed()) {
                    future.fail(event.cause());
                } else {
                    if (UpdateStatisticsResult.OPENED == event.result()) {
                        this.lockQueueSync(queueName, queuedRequest);
                    }
                    future.complete();
                }
            });
        } else {
            this.failWithNoRuleToCircuitMappingMessage(future, queueName, queuedRequest);
        }
        return future;
    }

    @Override
    public Future<Void> closeCircuit(HttpRequest queuedRequest) {
        Future future = Future.future();
        PatternAndCircuitHash patternAndCircuitHash = this.getPatternAndCircuitHashFromRequest(queuedRequest);
        if (patternAndCircuitHash != null) {
            this.log.info((Object)("About to close circuit " + patternAndCircuitHash.getPattern().pattern()));
            this.queueCircuitBreakerStorage.closeCircuit(patternAndCircuitHash).setHandler(event -> {
                if (event.failed()) {
                    future.fail(event.cause());
                    return;
                }
                future.complete();
            });
        } else {
            this.failWithNoRuleToCircuitMappingMessage(future, null, queuedRequest);
        }
        return future;
    }

    private void closeAndRemoveCircuit(PatternAndCircuitHash patternAndCircuitHash) {
        this.log.info((Object)("circuit " + patternAndCircuitHash.getPattern().pattern() + " has been removed. Closing corresponding circuit"));
        this.queueCircuitBreakerStorage.closeAndRemoveCircuit(patternAndCircuitHash).setHandler(event -> {
            if (event.failed()) {
                this.log.error((Object)("failed to close circuit " + patternAndCircuitHash.getPattern().pattern()));
            }
        });
    }

    @Override
    public Future<Void> closeAllCircuits() {
        this.log.info((Object)"About to close all circuits");
        return this.queueCircuitBreakerStorage.closeAllCircuits();
    }

    @Override
    public Future<Void> reOpenCircuit(HttpRequest queuedRequest) {
        Future future = Future.future();
        PatternAndCircuitHash patternAndCircuitHash = this.getPatternAndCircuitHashFromRequest(queuedRequest);
        if (patternAndCircuitHash != null) {
            this.log.info((Object)("About to reopen circuit " + patternAndCircuitHash.getPattern().pattern()));
            this.queueCircuitBreakerStorage.reOpenCircuit(patternAndCircuitHash).setHandler(event -> {
                if (event.failed()) {
                    future.fail(event.cause());
                    return;
                }
                future.complete();
            });
        } else {
            this.failWithNoRuleToCircuitMappingMessage(future, null, queuedRequest);
        }
        return future;
    }

    @Override
    public Future<Void> lockQueue(final String queueName, HttpRequest queuedRequest) {
        final Future future = Future.future();
        PatternAndCircuitHash patternAndCircuitHash = this.getPatternAndCircuitHashFromRequest(queuedRequest);
        if (patternAndCircuitHash != null) {
            this.queueCircuitBreakerStorage.lockQueue(queueName, patternAndCircuitHash).setHandler(event -> {
                if (event.failed()) {
                    future.fail(event.cause());
                    return;
                }
                this.vertx.eventBus().send(this.redisquesAddress, (Object)RedisquesAPI.buildPutLockOperation((String)queueName, (String)"queue_circuit_breaker"), (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

                    public void handle(AsyncResult<Message<JsonObject>> reply) {
                        if (reply.failed()) {
                            future.fail(reply.cause());
                            return;
                        }
                        if ("ok".equals(((JsonObject)((Message)reply.result()).body()).getString("status"))) {
                            QueueCircuitBreakerImpl.this.log.info((Object)("locked queue '" + queueName + "' because the circuit has been opened"));
                            future.complete();
                        } else {
                            future.fail("failed to lock queue '" + queueName + "'. Queue should have been locked, because the circuit has been opened");
                        }
                    }
                });
            });
        } else {
            this.failWithNoRuleToCircuitMappingMessage(future, queueName, queuedRequest);
        }
        return future;
    }

    @Override
    public Future<String> unlockNextQueue() {
        this.log.info((Object)"About to unlock the next queue");
        Future future = Future.future();
        this.queueCircuitBreakerStorage.popQueueToUnlock().setHandler(event -> {
            if (event.failed()) {
                future.fail(event.cause().getMessage());
                return;
            }
            String queueToUnlock = (String)event.result();
            if (queueToUnlock != null) {
                this.unlockQueue(queueToUnlock).setHandler(event1 -> {
                    if (event1.failed()) {
                        future.fail(event1.cause().getMessage());
                        return;
                    }
                    future.complete(event1.result());
                });
            } else {
                future.complete(null);
            }
        });
        return future;
    }

    private void logQueueUnlockError(String queueToUnlock) {
        this.log.error((Object)("Error during unlock of queue '" + queueToUnlock + "'. This queue has been removed from database but not from redisques. This queue must be unlocked manually!"));
    }

    @Override
    public Future<Long> setOpenCircuitsToHalfOpen() {
        return this.queueCircuitBreakerStorage.setOpenCircuitsToHalfOpen();
    }

    @Override
    public Future<Long> unlockSampleQueues() {
        this.log.info((Object)"About to unlock a sample queue for each circuit");
        Future future = Future.future();
        this.queueCircuitBreakerStorage.unlockSampleQueues().setHandler(event -> {
            if (event.failed()) {
                future.fail(event.cause().getMessage());
                return;
            }
            List queuesToUnlock = (List)event.result();
            if (queuesToUnlock == null || queuesToUnlock.isEmpty()) {
                future.complete((Object)0L);
                return;
            }
            AtomicInteger futureCounter = new AtomicInteger(queuesToUnlock.size());
            ArrayList failedFutures = new ArrayList();
            for (String queueToUnlock : queuesToUnlock) {
                this.unlockQueue(queueToUnlock).setHandler(event1 -> {
                    futureCounter.decrementAndGet();
                    if (event1.failed()) {
                        failedFutures.add(event1.cause().getMessage());
                    }
                    if (futureCounter.get() == 0) {
                        if (failedFutures.size() > 0) {
                            future.fail("The following queues could not be unlocked: " + failedFutures);
                        } else {
                            future.complete((Object)queuesToUnlock.size());
                        }
                    }
                });
            }
        });
        return future;
    }

    @Override
    public Future<String> unlockQueue(final String queueName) {
        this.log.info((Object)("About to unlock queue '" + queueName + "'"));
        final Future future = Future.future();
        this.vertx.eventBus().send(this.redisquesAddress, (Object)RedisquesAPI.buildDeleteLockOperation((String)queueName), (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

            public void handle(AsyncResult<Message<JsonObject>> reply) {
                if (reply.failed()) {
                    QueueCircuitBreakerImpl.this.logQueueUnlockError(queueName);
                    future.fail(queueName);
                    return;
                }
                if ("ok".equals(((JsonObject)((Message)reply.result()).body()).getString("status"))) {
                    future.complete((Object)queueName);
                } else {
                    QueueCircuitBreakerImpl.this.logQueueUnlockError(queueName);
                    future.fail(queueName);
                }
            }
        });
        return future;
    }

    private void lockQueueSync(String queueName, HttpRequest queuedRequest) {
        this.lockQueue(queueName, queuedRequest).setHandler(event -> {
            if (event.failed()) {
                this.log.warn((Object)event.cause().getMessage());
            }
        });
    }

    private void failWithNoRuleToCircuitMappingMessage(Future future, String queueName, HttpRequest request) {
        if (queueName == null) {
            future.fail("no rule to circuit mapping found for uri " + request.getUri());
        } else {
            future.fail("no rule to circuit mapping found for queue '" + queueName + "' and uri " + request.getUri());
        }
    }

    private PatternAndCircuitHash getPatternAndCircuitHashFromRequest(HttpRequest request) {
        return this.ruleToCircuitMapping.getCircuitFromRequestUri(request.getUri());
    }

    private String getRequestUniqueId(HttpRequest request) {
        String unique = request.getHeaders().get("x-rp-unique_id");
        if (unique == null) {
            unique = request.getHeaders().get("x-rp-unique-id");
        }
        if (unique == null) {
            this.log.warn((Object)("request to " + request.getUri() + " has no unique-id header. Using request uri instead"));
            unique = request.getUri();
        }
        return unique;
    }

    private QueueCircuitBreakerConfigurationResource getConfig() {
        return this.configResourceManager.getConfigurationResource();
    }
}

