/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.queue.queuing.circuitbreaker.lua;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.logging.Logger;
import io.vertx.redis.RedisClient;
import java.util.List;
import org.swisspush.gateleen.core.lua.LuaScriptState;
import org.swisspush.gateleen.core.lua.RedisCommand;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.util.UpdateStatisticsResult;

public class UpdateStatsRedisCommand
implements RedisCommand {
    private LuaScriptState luaScriptState;
    private List<String> keys;
    private List<String> arguments;
    private Future<UpdateStatisticsResult> future;
    private RedisClient redisClient;
    private Logger log;

    public UpdateStatsRedisCommand(LuaScriptState luaScriptState, List<String> keys, List<String> arguments, RedisClient redisClient, Logger log, Future<UpdateStatisticsResult> future) {
        this.luaScriptState = luaScriptState;
        this.keys = keys;
        this.arguments = arguments;
        this.redisClient = redisClient;
        this.log = log;
        this.future = future;
    }

    public void exec(int executionCounter) {
        this.redisClient.evalsha(this.luaScriptState.getSha(), this.keys, this.arguments, event -> {
            if (event.succeeded()) {
                String value = ((JsonArray)event.result()).getString(0);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("UpdateStatsRedisCommand lua script got result: " + value));
                }
                this.future.complete((Object)UpdateStatisticsResult.fromString(value, UpdateStatisticsResult.ERROR));
            } else {
                String message = event.cause().getMessage();
                if (message != null && message.startsWith("NOSCRIPT")) {
                    this.log.warn((Object)"UpdateStatsRedisCommand script couldn't be found, reload it");
                    this.log.warn((Object)("amount the script got loaded: " + String.valueOf(executionCounter)));
                    if (executionCounter > 10) {
                        this.future.fail("amount the script got loaded is higher than 10, we abort");
                    } else {
                        this.luaScriptState.loadLuaScript((RedisCommand)new UpdateStatsRedisCommand(this.luaScriptState, this.keys, this.arguments, this.redisClient, this.log, this.future), executionCounter);
                    }
                } else {
                    this.future.fail("UpdateStatsRedisCommand request failed with message: " + message);
                }
            }
        });
    }
}

