/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.queue.queuing.circuitbreaker.util;

import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.swisspush.gateleen.core.util.HashCodeGenerator;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.util.PatternAndCircuitHash;
import org.swisspush.gateleen.routing.Rule;

public class QueueCircuitBreakerRulePatternToCircuitMapping {
    private Logger log = LoggerFactory.getLogger(QueueCircuitBreakerRulePatternToCircuitMapping.class);
    private List<PatternAndCircuitHash> rulePatternToCircuitMapping = new ArrayList<PatternAndCircuitHash>();

    public List<PatternAndCircuitHash> updateRulePatternToCircuitMapping(List<Rule> rules) {
        ArrayList<PatternAndCircuitHash> originalPatternAndCircuitHashes = new ArrayList<PatternAndCircuitHash>(this.rulePatternToCircuitMapping);
        this.log.debug((Object)"clearing rule pattern to circuit mapping values");
        this.rulePatternToCircuitMapping.clear();
        this.log.debug((Object)"new rule pattern to circuit mapping values are:");
        for (Rule rule : rules) {
            PatternAndCircuitHash patternAndCircuitHash = this.getPatternAndCircuitHashFromRule(rule);
            this.log.debug((Object)patternAndCircuitHash);
            if (patternAndCircuitHash != null) {
                this.rulePatternToCircuitMapping.add(patternAndCircuitHash);
                continue;
            }
            this.log.error((Object)("rule pattern and circuitHash could not be retrieved from rule " + rule.getUrlPattern()));
        }
        return this.getRemovedPatternAndCircuitHashes(originalPatternAndCircuitHashes, this.rulePatternToCircuitMapping);
    }

    private List<PatternAndCircuitHash> getRemovedPatternAndCircuitHashes(List<PatternAndCircuitHash> currentPatternAndCircuitHashes, List<PatternAndCircuitHash> newPatternAndCircuitHashes) {
        currentPatternAndCircuitHashes.removeAll(newPatternAndCircuitHashes);
        return currentPatternAndCircuitHashes;
    }

    public PatternAndCircuitHash getCircuitFromRequestUri(String requestUri) {
        for (PatternAndCircuitHash mapping : this.rulePatternToCircuitMapping) {
            if (!mapping.getPattern().matcher(requestUri).matches()) continue;
            return mapping;
        }
        return null;
    }

    private PatternAndCircuitHash getPatternAndCircuitHashFromRule(Rule rule) {
        try {
            Pattern pattern = Pattern.compile(rule.getUrlPattern());
            String circuitHash = HashCodeGenerator.createHashCode((String)rule.getUrlPattern());
            return new PatternAndCircuitHash(pattern, circuitHash);
        }
        catch (Exception e) {
            this.log.error((Object)("Could not compile the regex:" + rule.getUrlPattern() + " to a pattern."));
            return null;
        }
    }
}

