/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.queue.queuing.circuitbreaker.lua;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.redis.RedisClient;
import java.util.List;
import org.swisspush.gateleen.core.lua.LuaScriptState;
import org.swisspush.gateleen.core.lua.RedisCommand;

public class GetAllCircuitsRedisCommand
implements RedisCommand {
    private LuaScriptState luaScriptState;
    private List<String> keys;
    private List<String> arguments;
    private Future<JsonObject> future;
    private RedisClient redisClient;
    private Logger log;

    public GetAllCircuitsRedisCommand(LuaScriptState luaScriptState, List<String> keys, List<String> arguments, RedisClient redisClient, Logger log, Future<JsonObject> future) {
        this.luaScriptState = luaScriptState;
        this.keys = keys;
        this.arguments = arguments;
        this.redisClient = redisClient;
        this.log = log;
        this.future = future;
    }

    public void exec(int executionCounter) {
        this.redisClient.evalsha(this.luaScriptState.getSha(), this.keys, this.arguments, event -> {
            if (event.succeeded()) {
                JsonArray resultArray = (JsonArray)event.result();
                try {
                    String objectStr = resultArray.getString(0);
                    JsonObject obj = new JsonObject(objectStr);
                    this.future.complete((Object)obj);
                }
                catch (Exception e) {
                    this.future.fail("could not get json from lua script. cause: " + e);
                }
            } else {
                String message = event.cause().getMessage();
                if (message != null && message.startsWith("NOSCRIPT")) {
                    this.log.warn((Object)"GetAllCircuitsRedisCommand script couldn't be found, reload it");
                    this.log.warn((Object)("amount the script got loaded: " + String.valueOf(executionCounter)));
                    if (executionCounter > 10) {
                        this.future.fail("amount the script got loaded is higher than 10, we abort");
                    } else {
                        this.luaScriptState.loadLuaScript((RedisCommand)new GetAllCircuitsRedisCommand(this.luaScriptState, this.keys, this.arguments, this.redisClient, this.log, this.future), executionCounter);
                    }
                } else {
                    this.future.fail("GetAllCircuitsRedisCommand request failed with message: " + message);
                }
            }
        });
    }
}

