/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.queue.queuing.circuitbreaker.impl;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.http.HttpRequest;
import org.swisspush.gateleen.core.lock.Lock;
import org.swisspush.gateleen.core.refresh.Refreshable;
import org.swisspush.gateleen.core.util.Address;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.QueueCircuitBreaker;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.QueueCircuitBreakerStorage;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.configuration.QueueCircuitBreakerConfigurationResource;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.configuration.QueueCircuitBreakerConfigurationResourceManager;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.util.PatternAndCircuitHash;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.util.QueueCircuitBreakerRulePatternToCircuitMapping;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.util.QueueCircuitState;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.util.QueueResponseType;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.util.UpdateStatisticsResult;
import org.swisspush.gateleen.routing.Rule;
import org.swisspush.gateleen.routing.RuleProvider;
import org.swisspush.redisques.util.RedisquesAPI;

public class QueueCircuitBreakerImpl
implements QueueCircuitBreaker,
RuleProvider.RuleChangesObserver,
Refreshable {
    private Logger log = LoggerFactory.getLogger(QueueCircuitBreakerImpl.class);
    private Vertx vertx;
    private QueueCircuitBreakerStorage queueCircuitBreakerStorage;
    private QueueCircuitBreakerRulePatternToCircuitMapping ruleToCircuitMapping;
    private QueueCircuitBreakerConfigurationResourceManager configResourceManager;
    private Lock lock;
    public static final String OPEN_TO_HALF_OPEN_TASK_LOCK = "openToHalfOpenTask";
    public static final String UNLOCK_QUEUES_TASK_LOCK = "unlockQueuesTask";
    public static final String UNLOCK_SAMPLE_QUEUES_TASK_LOCK = "unlockSampleQueuesTask";
    private String redisquesAddress;
    private long openToHalfOpenTimerId = -1L;
    private long unlockQueuesTimerId = -1L;
    private long unlockSampleQueuesTimerId = -1L;

    public QueueCircuitBreakerImpl(Vertx vertx, Lock lock, String redisquesAddress, QueueCircuitBreakerStorage queueCircuitBreakerStorage, RuleProvider ruleProvider, QueueCircuitBreakerRulePatternToCircuitMapping ruleToCircuitMapping, QueueCircuitBreakerConfigurationResourceManager configResourceManager, Handler<HttpServerRequest> queueCircuitBreakerHttpRequestHandler, int requestHandlerPort) {
        this.vertx = vertx;
        this.lock = lock;
        this.redisquesAddress = redisquesAddress;
        this.queueCircuitBreakerStorage = queueCircuitBreakerStorage;
        ruleProvider.registerObserver((RuleProvider.RuleChangesObserver)this);
        this.ruleToCircuitMapping = ruleToCircuitMapping;
        this.configResourceManager = configResourceManager;
        this.configResourceManager.addRefreshable(this);
        this.registerPeriodicTasks();
        HttpServerOptions options = new HttpServerOptions().setHandle100ContinueAutomatically(true);
        vertx.createHttpServer(options).requestHandler(queueCircuitBreakerHttpRequestHandler).listen(requestHandlerPort, event -> {
            if (event.succeeded()) {
                this.log.info("Successfully listening to port " + requestHandlerPort);
            } else {
                this.log.error("Unable to listen to port " + requestHandlerPort + ". Cannot handle QueueCircuitBreaker http requests");
            }
        });
    }

    private void registerPeriodicTasks() {
        this.registerOpenToHalfOpenTask();
        this.registerUnlockQueuesTask();
        this.registerUnlockSampleQueuesTask();
    }

    private String createToken(String appendix) {
        return Address.instanceAddress() + "_" + System.currentTimeMillis() + "_" + appendix;
    }

    private long getLockExpiry(int taskInterval) {
        if (taskInterval <= 1) {
            return 1L;
        }
        return taskInterval / 2;
    }

    private Future<Boolean> acquireLock(String lock, String token, long lockExpiryMs) {
        Future future = Future.future();
        if (this.lock == null) {
            this.log.info("No lock implementation defined, going to pretend like we got the lock");
            future.complete((Object)Boolean.TRUE);
            return future;
        }
        this.log.debug("Trying to acquire lock '" + lock + "' with token '" + token + "' and expiry " + lockExpiryMs + "ms");
        this.lock.acquireLock(lock, token, lockExpiryMs).setHandler(lockEvent -> {
            if (lockEvent.succeeded()) {
                if (((Boolean)lockEvent.result()).booleanValue()) {
                    this.log.debug("Acquired lock '" + lock + "' with token '" + token + "'");
                    future.complete((Object)Boolean.TRUE);
                } else {
                    future.complete((Object)Boolean.FALSE);
                }
            } else {
                future.fail(lockEvent.cause());
            }
        });
        return future;
    }

    private void releaseLock(String lock, String token) {
        if (this.lock == null) {
            this.log.info("No lock implementation defined, going to pretend like we released the lock");
            return;
        }
        this.log.debug("Trying to release lock '" + lock + "' with token '" + token + "'");
        this.lock.releaseLock(lock, token).setHandler(releaseEvent -> {
            if (releaseEvent.succeeded()) {
                if (((Boolean)releaseEvent.result()).booleanValue()) {
                    this.log.debug("Released lock '" + lock + "' with token '" + token + "'");
                }
            } else {
                this.log.error("Could not release lock '" + lock + "'. Message: " + releaseEvent.cause().getMessage());
            }
        });
    }

    private void registerOpenToHalfOpenTask() {
        boolean openToHalfOpenTaskEnabled = this.getConfig().isOpenToHalfOpenTaskEnabled();
        int openToHalfOpenTaskInterval = this.getConfig().getOpenToHalfOpenTaskInterval();
        this.vertx.cancelTimer(this.openToHalfOpenTimerId);
        if (openToHalfOpenTaskEnabled) {
            this.log.info("About to register periodic open to half-open task execution every " + this.getConfig().getOpenToHalfOpenTaskInterval() + "ms");
            this.openToHalfOpenTimerId = this.vertx.setPeriodic((long)openToHalfOpenTaskInterval, event -> {
                String token = this.createToken(OPEN_TO_HALF_OPEN_TASK_LOCK);
                this.acquireLock(OPEN_TO_HALF_OPEN_TASK_LOCK, token, this.getLockExpiry(openToHalfOpenTaskInterval)).setHandler(lockEvent -> {
                    if (lockEvent.succeeded()) {
                        if (((Boolean)lockEvent.result()).booleanValue()) {
                            this.setOpenCircuitsToHalfOpen().setHandler(event1 -> {
                                if (event1.succeeded()) {
                                    if ((Long)event1.result() > 0L) {
                                        this.log.info("Successfully changed " + event1.result() + " circuits from state open to state half-open");
                                    } else {
                                        this.log.debug("No open circuits to change state to half-open");
                                    }
                                } else {
                                    this.log.error(event1.cause().getMessage());
                                }
                                this.releaseLock(OPEN_TO_HALF_OPEN_TASK_LOCK, token);
                            });
                        }
                    } else {
                        this.log.error("Could not acquire lock 'openToHalfOpenTask'. Message: " + lockEvent.cause().getMessage());
                    }
                });
            });
        } else {
            this.log.info("Not going to register periodic open to half-open task execution");
        }
    }

    private void registerUnlockQueuesTask() {
        boolean unlockQueuesTaskEnabled = this.getConfig().isUnlockQueuesTaskEnabled();
        int unlockQueuesTaskInterval = this.getConfig().getUnlockQueuesTaskInterval();
        this.vertx.cancelTimer(this.unlockQueuesTimerId);
        if (unlockQueuesTaskEnabled) {
            this.log.info("About to register periodic queues unlock task execution every " + unlockQueuesTaskInterval + "ms");
            this.unlockQueuesTimerId = this.vertx.setPeriodic((long)unlockQueuesTaskInterval, event -> {
                String token = this.createToken(UNLOCK_QUEUES_TASK_LOCK);
                this.acquireLock(UNLOCK_QUEUES_TASK_LOCK, token, this.getLockExpiry(unlockQueuesTaskInterval)).setHandler(lockEvent -> {
                    if (lockEvent.succeeded()) {
                        if (((Boolean)lockEvent.result()).booleanValue()) {
                            this.unlockNextQueue().setHandler(event1 -> {
                                if (event1.succeeded()) {
                                    if (event1.result() == null) {
                                        this.log.debug("No locked queues to unlock");
                                    } else {
                                        this.log.info("Successfully unlocked queue '" + (String)event1.result() + "'");
                                    }
                                } else {
                                    this.log.error("Unable to unlock queue '" + event1.cause().getMessage() + "'");
                                }
                                this.releaseLock(UNLOCK_QUEUES_TASK_LOCK, token);
                            });
                        }
                    } else {
                        this.log.error("Could not acquire lock 'unlockQueuesTask'. Message: " + lockEvent.cause().getMessage());
                    }
                });
            });
        } else {
            this.log.info("Not going to register periodic queues unlock task execution");
        }
    }

    private void registerUnlockSampleQueuesTask() {
        boolean unlockSampleQueuesTaskEnabled = this.getConfig().isUnlockSampleQueuesTaskEnabled();
        int unlockSampleQueuesTaskInterval = this.getConfig().getUnlockSampleQueuesTaskInterval();
        this.vertx.cancelTimer(this.unlockSampleQueuesTimerId);
        if (unlockSampleQueuesTaskEnabled) {
            this.log.info("About to register periodic unlock sample queues task execution every " + unlockSampleQueuesTaskInterval + "ms");
            this.unlockSampleQueuesTimerId = this.vertx.setPeriodic((long)unlockSampleQueuesTaskInterval, event -> {
                String token = this.createToken(UNLOCK_SAMPLE_QUEUES_TASK_LOCK);
                this.acquireLock(UNLOCK_SAMPLE_QUEUES_TASK_LOCK, token, this.getLockExpiry(unlockSampleQueuesTaskInterval)).setHandler(lockEvent -> {
                    if (lockEvent.succeeded()) {
                        if (((Boolean)lockEvent.result()).booleanValue()) {
                            this.unlockSampleQueues().setHandler(event1 -> {
                                if (event1.succeeded()) {
                                    if ((Long)event1.result() == 0L) {
                                        this.log.debug("No sample queues to unlock");
                                    } else {
                                        this.log.info("Successfully unlocked " + event1.result() + " sample queues");
                                    }
                                } else {
                                    this.log.error(event1.cause().getMessage());
                                }
                                this.releaseLock(UNLOCK_SAMPLE_QUEUES_TASK_LOCK, token);
                            });
                        }
                    } else {
                        this.log.error("Could not acquire lock 'unlockSampleQueuesTask'. Message: " + lockEvent.cause().getMessage());
                    }
                });
            });
        } else {
            this.log.info("Not going to register periodic unlock sample queues task execution");
        }
    }

    public void rulesChanged(List<Rule> rules) {
        this.log.info("rules have changed, renew rule to circuit mapping");
        List<PatternAndCircuitHash> removedEntries = this.ruleToCircuitMapping.updateRulePatternToCircuitMapping(rules);
        this.log.info(removedEntries.size() + " mappings have been removed with the update");
        removedEntries.forEach(this::closeAndRemoveCircuit);
    }

    public void refresh() {
        this.log.info("Circuit breaker configuration values have changed. Check periodic tasks");
        this.registerPeriodicTasks();
    }

    @Override
    public boolean isCircuitCheckEnabled() {
        return this.configResourceManager.getConfigurationResource().isCircuitCheckEnabled();
    }

    @Override
    public boolean isStatisticsUpdateEnabled() {
        return this.configResourceManager.getConfigurationResource().isStatisticsUpdateEnabled();
    }

    @Override
    public Future<QueueCircuitState> handleQueuedRequest(String queueName, HttpRequest queuedRequest) {
        Future future = Future.future();
        PatternAndCircuitHash patternAndCircuitHash = this.getPatternAndCircuitHashFromRequest(queuedRequest);
        if (patternAndCircuitHash != null) {
            this.queueCircuitBreakerStorage.getQueueCircuitState(patternAndCircuitHash).setHandler(event -> {
                if (event.failed()) {
                    future.fail(event.cause());
                } else {
                    future.complete(event.result());
                    if (QueueCircuitState.OPEN == event.result()) {
                        this.lockQueueSync(queueName, queuedRequest);
                    }
                }
            });
        } else {
            this.failWithNoRuleToCircuitMappingMessage(future, queueName, queuedRequest);
        }
        return future;
    }

    @Override
    public Future<Void> updateStatistics(String queueName, HttpRequest queuedRequest, QueueResponseType queueResponseType) {
        Future future = Future.future();
        String requestId = this.getRequestUniqueId(queuedRequest);
        long currentTS = System.currentTimeMillis();
        PatternAndCircuitHash patternAndCircuitHash = this.getPatternAndCircuitHashFromRequest(queuedRequest);
        if (patternAndCircuitHash != null) {
            int errorThresholdPercentage = this.getConfig().getErrorThresholdPercentage();
            int entriesMaxAgeMS = this.getConfig().getEntriesMaxAgeMS();
            int minQueueSampleCount = this.getConfig().getMinQueueSampleCount();
            int maxQueueSampleCount = this.getConfig().getMaxQueueSampleCount();
            this.queueCircuitBreakerStorage.updateStatistics(patternAndCircuitHash, requestId, currentTS, errorThresholdPercentage, entriesMaxAgeMS, minQueueSampleCount, maxQueueSampleCount, queueResponseType).setHandler(event -> {
                if (event.failed()) {
                    future.fail(event.cause());
                } else {
                    if (UpdateStatisticsResult.OPENED == event.result()) {
                        this.log.warn("circuit '" + patternAndCircuitHash.getPattern().pattern() + "' has been opened");
                        this.lockQueueSync(queueName, queuedRequest);
                    }
                    future.complete();
                }
            });
        } else {
            this.failWithNoRuleToCircuitMappingMessage(future, queueName, queuedRequest);
        }
        return future;
    }

    @Override
    public Future<Void> closeCircuit(HttpRequest queuedRequest) {
        Future future = Future.future();
        PatternAndCircuitHash patternAndCircuitHash = this.getPatternAndCircuitHashFromRequest(queuedRequest);
        if (patternAndCircuitHash != null) {
            this.log.info("About to close circuit " + patternAndCircuitHash.getPattern().pattern());
            this.queueCircuitBreakerStorage.closeCircuit(patternAndCircuitHash).setHandler(event -> {
                if (event.failed()) {
                    future.fail(event.cause());
                    return;
                }
                this.log.info("circuit '" + patternAndCircuitHash.getPattern().pattern() + "' has been closed");
                future.complete();
            });
        } else {
            this.failWithNoRuleToCircuitMappingMessage(future, null, queuedRequest);
        }
        return future;
    }

    private void closeAndRemoveCircuit(PatternAndCircuitHash patternAndCircuitHash) {
        this.log.info("circuit " + patternAndCircuitHash.getPattern().pattern() + " has been removed. Closing corresponding circuit");
        this.queueCircuitBreakerStorage.closeAndRemoveCircuit(patternAndCircuitHash).setHandler(event -> {
            if (event.failed()) {
                this.log.error("failed to close circuit " + patternAndCircuitHash.getPattern().pattern());
            }
        });
    }

    @Override
    public Future<Void> closeAllCircuits() {
        this.log.info("About to close all circuits");
        return this.queueCircuitBreakerStorage.closeAllCircuits();
    }

    @Override
    public Future<Void> reOpenCircuit(HttpRequest queuedRequest) {
        Future future = Future.future();
        PatternAndCircuitHash patternAndCircuitHash = this.getPatternAndCircuitHashFromRequest(queuedRequest);
        if (patternAndCircuitHash != null) {
            this.log.info("About to reopen circuit " + patternAndCircuitHash.getPattern().pattern());
            this.queueCircuitBreakerStorage.reOpenCircuit(patternAndCircuitHash).setHandler(event -> {
                if (event.failed()) {
                    future.fail(event.cause());
                    return;
                }
                this.log.info("circuit '" + patternAndCircuitHash.getPattern().pattern() + "' has been reopened");
                future.complete();
            });
        } else {
            this.failWithNoRuleToCircuitMappingMessage(future, null, queuedRequest);
        }
        return future;
    }

    @Override
    public Future<Void> lockQueue(String queueName, HttpRequest queuedRequest) {
        Future future = Future.future();
        PatternAndCircuitHash patternAndCircuitHash = this.getPatternAndCircuitHashFromRequest(queuedRequest);
        if (patternAndCircuitHash != null) {
            this.queueCircuitBreakerStorage.lockQueue(queueName, patternAndCircuitHash).setHandler(event -> {
                if (event.failed()) {
                    future.fail(event.cause());
                    return;
                }
                this.vertx.eventBus().send(this.redisquesAddress, (Object)RedisquesAPI.buildPutLockOperation((String)queueName, (String)"queue_circuit_breaker"), reply -> {
                    if (reply.failed()) {
                        future.fail(reply.cause());
                        return;
                    }
                    if ("ok".equals(((JsonObject)((Message)reply.result()).body()).getString("status"))) {
                        this.log.info("locked queue '" + queueName + "' because the circuit '" + patternAndCircuitHash.getPattern().pattern() + "' is open");
                        future.complete();
                    } else {
                        future.fail("failed to lock queue '" + queueName + "'. Queue should have been locked, because the circuit '" + patternAndCircuitHash.getPattern().pattern() + "' is open");
                    }
                });
            });
        } else {
            this.failWithNoRuleToCircuitMappingMessage(future, queueName, queuedRequest);
        }
        return future;
    }

    @Override
    public Future<String> unlockNextQueue() {
        this.log.debug("About to unlock the next queue");
        Future future = Future.future();
        this.queueCircuitBreakerStorage.popQueueToUnlock().setHandler(event -> {
            if (event.failed()) {
                future.fail(event.cause().getMessage());
                return;
            }
            String queueToUnlock = (String)event.result();
            if (queueToUnlock != null) {
                this.unlockQueue(queueToUnlock).setHandler(event1 -> {
                    if (event1.failed()) {
                        future.fail(event1.cause().getMessage());
                        return;
                    }
                    future.complete(event1.result());
                });
            } else {
                future.complete(null);
            }
        });
        return future;
    }

    private void logQueueUnlockError(String queueToUnlock, String errorMessage) {
        this.log.error("Error during unlock of queue '" + queueToUnlock + "'. This queue has been removed from database " + "but not from redisques. This queue must be unlocked manually! Message: " + errorMessage);
    }

    @Override
    public Future<Long> setOpenCircuitsToHalfOpen() {
        return this.queueCircuitBreakerStorage.setOpenCircuitsToHalfOpen();
    }

    @Override
    public Future<Long> unlockSampleQueues() {
        this.log.info("About to unlock a sample queue for each circuit");
        Future future = Future.future();
        this.queueCircuitBreakerStorage.unlockSampleQueues().setHandler(event -> {
            if (event.failed()) {
                future.fail(event.cause().getMessage());
                return;
            }
            List queuesToUnlock = (List)event.result();
            if (queuesToUnlock == null || queuesToUnlock.isEmpty()) {
                future.complete((Object)0L);
                return;
            }
            AtomicInteger futureCounter = new AtomicInteger(queuesToUnlock.size());
            ArrayList failedFutures = new ArrayList();
            for (String queueToUnlock : queuesToUnlock) {
                this.log.info("About to unlock sample queue '" + queueToUnlock + "'");
                this.unlockQueue(queueToUnlock).setHandler(event1 -> {
                    futureCounter.decrementAndGet();
                    if (event1.failed()) {
                        failedFutures.add(event1.cause().getMessage());
                    }
                    if (futureCounter.get() == 0) {
                        if (failedFutures.size() > 0) {
                            future.fail("The following queues could not be unlocked: " + failedFutures);
                        } else {
                            future.complete((Object)queuesToUnlock.size());
                        }
                    }
                });
            }
        });
        return future;
    }

    @Override
    public Future<String> unlockQueue(String queueName) {
        this.log.info("About to unlock queue '" + queueName + "'");
        Future future = Future.future();
        this.vertx.eventBus().send(this.redisquesAddress, (Object)RedisquesAPI.buildDeleteLockOperation((String)queueName), reply -> {
            if (reply.failed()) {
                this.logQueueUnlockError(queueName, reply.cause().getMessage());
                future.fail(queueName);
                return;
            }
            if ("ok".equals(((JsonObject)((Message)reply.result()).body()).getString("status"))) {
                future.complete((Object)queueName);
            } else {
                this.logQueueUnlockError(queueName, "Got reply with status value '" + ((JsonObject)((Message)reply.result()).body()).getString("status") + "'");
                future.fail(queueName);
            }
        });
        return future;
    }

    private void lockQueueSync(String queueName, HttpRequest queuedRequest) {
        this.lockQueue(queueName, queuedRequest).setHandler(event -> {
            if (event.failed()) {
                this.log.warn(event.cause().getMessage());
            }
        });
    }

    private void failWithNoRuleToCircuitMappingMessage(Future future, String queueName, HttpRequest request) {
        if (queueName == null) {
            future.fail("no rule to circuit mapping found for uri " + request.getUri());
        } else {
            future.fail("no rule to circuit mapping found for queue '" + queueName + "' and uri " + request.getUri());
        }
    }

    private PatternAndCircuitHash getPatternAndCircuitHashFromRequest(HttpRequest request) {
        return this.ruleToCircuitMapping.getCircuitFromRequestUri(request.getUri());
    }

    private String getRequestUniqueId(HttpRequest request) {
        String unique = request.getHeaders().get("x-rp-unique_id");
        if (unique == null) {
            unique = request.getHeaders().get("x-rp-unique-id");
        }
        if (unique == null) {
            this.log.warn("request to " + request.getUri() + " has no unique-id header. Using request uri instead");
            unique = request.getUri();
        }
        return unique;
    }

    private QueueCircuitBreakerConfigurationResource getConfig() {
        return this.configResourceManager.getConfigurationResource();
    }
}

