/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.queue.expiry;

import io.vertx.core.MultiMap;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.http.HttpServerRequest;
import java.util.Optional;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.http.HttpRequest;

public final class ExpiryCheckHandler {
    public static final String SERVER_TIMESTAMP_HEADER = "X-Server-Timestamp";
    public static final String EXPIRE_AFTER_HEADER = "X-Expire-After";
    public static final String QUEUE_EXPIRE_AFTER_HEADER = "x-queue-expire-after";
    private static Logger log = LoggerFactory.getLogger(ExpiryCheckHandler.class);
    private static DateTimeFormatter dfISO8601 = ISODateTimeFormat.dateTime().withZone(DateTimeZone.forID((String)"Europe/Zurich"));
    private static DateTimeFormatter dfISO8601Parser = ISODateTimeFormat.dateTimeParser().withZone(DateTimeZone.forID((String)"Europe/Zurich"));
    private static DateTimeFormatter isoDateTimeParser = ISODateTimeFormat.dateTimeParser();

    private ExpiryCheckHandler() {
    }

    public static void updateServerTimestampHeader(HttpRequest request) {
        if (request.getHeaders() == null) {
            request.setHeaders((MultiMap)new CaseInsensitiveHeaders());
        }
        ExpiryCheckHandler.updateServerTimestampHeader(request.getHeaders());
    }

    public static void updateServerTimestampHeader(HttpServerRequest request) {
        ExpiryCheckHandler.updateServerTimestampHeader(request.headers());
    }

    public static void updateServerTimestampHeader(MultiMap headers) {
        String serverTimestamp = headers.get(SERVER_TIMESTAMP_HEADER);
        if (serverTimestamp == null) {
            String nowAsISO = dfISO8601.print((ReadableInstant)Instant.now());
            log.debug("Setting X-Server-Timestamp value to " + nowAsISO + "  since header " + SERVER_TIMESTAMP_HEADER + " is not defined");
            headers.set(SERVER_TIMESTAMP_HEADER, nowAsISO);
        } else {
            String updatedTimestamp = ExpiryCheckHandler.localizeTimestamp(serverTimestamp);
            if (!updatedTimestamp.equals(serverTimestamp)) {
                log.debug("UpdatingX-Server-Timestamp value from " + serverTimestamp + "  to " + updatedTimestamp);
                headers.remove(SERVER_TIMESTAMP_HEADER);
                headers.set(SERVER_TIMESTAMP_HEADER, updatedTimestamp);
            }
        }
    }

    public static Integer getExpireAfter(MultiMap headers) {
        try {
            Integer ans = ExpiryCheckHandler.getExpireValue(headers.get(EXPIRE_AFTER_HEADER));
            return ans != null && ans == -1 ? null : ans;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Optional<Integer> getExpireAfterConcerningCaseOfCorruptHeaderAndInfinite(MultiMap headers) {
        try {
            Integer expireValue = ExpiryCheckHandler.getExpireValue(headers.get(EXPIRE_AFTER_HEADER));
            return Optional.ofNullable(expireValue);
        }
        catch (NumberFormatException e) {
            log.warn("Conceal exception (because we're not allowed to throw by design): " + e.getClass().getSimpleName() + ": " + e.getMessage());
            return Optional.empty();
        }
    }

    public static Integer getQueueExpireAfter(MultiMap headers) {
        try {
            Integer ans = ExpiryCheckHandler.getExpireValue(headers.get(QUEUE_EXPIRE_AFTER_HEADER));
            return ans != null && ans == -1 ? null : ans;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Integer getExpireValue(String expirationTimeout) throws NumberFormatException {
        Integer ans;
        if (expirationTimeout == null) {
            ans = null;
        } else {
            ans = Integer.parseInt(expirationTimeout);
            if (ans < -1) {
                throw new NumberFormatException("Values less than -1 aren't valid expireAfter values.");
            }
        }
        return ans;
    }

    public static boolean isExpired(HttpRequest request) {
        return ExpiryCheckHandler.isExpired(request.getHeaders());
    }

    public static boolean isExpired(HttpServerRequest request) {
        return ExpiryCheckHandler.isExpired(request.headers());
    }

    public static boolean isExpired(MultiMap headers) {
        if (headers != null) {
            Integer queueExpireAfter = ExpiryCheckHandler.getQueueExpireAfter(headers);
            Integer expireAfter = ExpiryCheckHandler.getExpireAfter(headers);
            String serverTimestamp = headers.get(SERVER_TIMESTAMP_HEADER);
            if (queueExpireAfter != null) {
                expireAfter = queueExpireAfter;
            }
            if (serverTimestamp != null && expireAfter != null) {
                LocalDateTime timestamp = ExpiryCheckHandler.parseDateTime(serverTimestamp);
                LocalDateTime expirationTime = ExpiryCheckHandler.getExpirationTime(timestamp, (int)expireAfter);
                LocalDateTime now = ExpiryCheckHandler.getActualTime();
                log.debug(" > isExpired - timestamp " + timestamp + " | expirationTime " + expirationTime + " | now " + now);
                return expirationTime.isBefore((ReadablePartial)now);
            }
        }
        return false;
    }

    public static boolean isExpired(MultiMap headers, Long timestamp) {
        if (headers != null && timestamp != null) {
            Integer queueExpireAfter = ExpiryCheckHandler.getQueueExpireAfter(headers);
            Integer expireAfter = ExpiryCheckHandler.getExpireAfter(headers);
            if (queueExpireAfter != null) {
                expireAfter = queueExpireAfter;
            }
            if (expireAfter != null) {
                long expiredSince = System.currentTimeMillis() - (timestamp + (long)expireAfter.intValue() * 1000L);
                if (expiredSince > 0L) {
                    log.debug(" > isExpired - Request expired since {} milliseconds.", (Object)expiredSince);
                    return true;
                }
                log.debug(" > isExpired - Request not expired (would expire in {} milliseconds).", (Object)(-expiredSince));
                return false;
            }
        }
        return false;
    }

    public static LocalDateTime getActualTime() {
        return dfISO8601Parser.parseLocalDateTime(dfISO8601.print((ReadableInstant)Instant.now()));
    }

    public static LocalDateTime getExpirationTime(int expireAfter) {
        return ExpiryCheckHandler.getExpirationTime(ExpiryCheckHandler.getActualTime(), expireAfter);
    }

    public static LocalDateTime getExpirationTime(String serverTimestamp, int expireAfter) {
        return ExpiryCheckHandler.getExpirationTime(ExpiryCheckHandler.parseDateTime(serverTimestamp), expireAfter);
    }

    public static Optional<String> getExpirationTimeAsString(int expireAfter) {
        String expirationTime = expireAfter == -1 ? null : ExpiryCheckHandler.printDateTime(ExpiryCheckHandler.getExpirationTime(expireAfter));
        return Optional.ofNullable(expirationTime);
    }

    public static LocalDateTime parseDateTime(String datetime) {
        return dfISO8601Parser.parseLocalDateTime(ExpiryCheckHandler.localizeTimestamp(datetime));
    }

    public static String printDateTime(LocalDateTime datetime) {
        return dfISO8601.print((ReadablePartial)datetime);
    }

    private static LocalDateTime getExpirationTime(LocalDateTime timestamp, int expireAfter) {
        LocalDateTime expirationTime = timestamp.plusSeconds(expireAfter);
        log.debug("getExpirationTime: " + expirationTime);
        return expirationTime;
    }

    public static void setQueueExpireAfter(HttpRequest request, int queueExpireAfter) {
        if (request.getHeaders() == null) {
            request.setHeaders((MultiMap)new CaseInsensitiveHeaders());
        }
        ExpiryCheckHandler.setFieldValue(request.getHeaders(), QUEUE_EXPIRE_AFTER_HEADER, queueExpireAfter);
    }

    public static void setExpireAfter(HttpRequest request, int expireAfter) {
        if (request.getHeaders() == null) {
            request.setHeaders((MultiMap)new CaseInsensitiveHeaders());
        }
        ExpiryCheckHandler.setFieldValue(request.getHeaders(), EXPIRE_AFTER_HEADER, expireAfter);
    }

    public static void setQueueExpireAfter(HttpServerRequest request, int queueExpireAfter) {
        ExpiryCheckHandler.setFieldValue(request.headers(), QUEUE_EXPIRE_AFTER_HEADER, queueExpireAfter);
    }

    public static void setExpireAfter(HttpServerRequest request, int expireAfter) {
        ExpiryCheckHandler.setFieldValue(request.headers(), EXPIRE_AFTER_HEADER, expireAfter);
    }

    public static void setQueueExpireAfter(MultiMap headers, int queueExpireAfter) {
        ExpiryCheckHandler.setFieldValue(headers, QUEUE_EXPIRE_AFTER_HEADER, queueExpireAfter);
    }

    public static void setExpireAfter(MultiMap headers, int expireAfter) {
        ExpiryCheckHandler.setFieldValue(headers, EXPIRE_AFTER_HEADER, expireAfter);
    }

    private static void setFieldValue(MultiMap headers, String field, int expireValue) {
        if (headers.get(field) != null) {
            headers.remove(field);
        }
        headers.set(field, String.valueOf(expireValue));
    }

    private static String localizeTimestamp(String timestamp) {
        String localizedTimestamp = timestamp;
        if (localizedTimestamp != null && localizedTimestamp.toUpperCase().endsWith("Z")) {
            try {
                DateTime dt = isoDateTimeParser.parseDateTime(localizedTimestamp);
                localizedTimestamp = dfISO8601.print((ReadableInstant)dt);
            }
            catch (IllegalArgumentException e) {
                log.warn("Could not parse: " + localizedTimestamp);
            }
        }
        return localizedTimestamp;
    }
}

