/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.queue.queuing.circuitbreaker.lua;

import io.vertx.core.Future;
import io.vertx.redis.RedisClient;
import java.util.List;
import org.slf4j.Logger;
import org.swisspush.gateleen.core.lua.LuaScriptState;
import org.swisspush.gateleen.core.lua.RedisCommand;

public class CloseCircuitRedisCommand
implements RedisCommand {
    private LuaScriptState luaScriptState;
    private List<String> keys;
    private List<String> arguments;
    private Future<Void> future;
    private RedisClient redisClient;
    private Logger log;

    public CloseCircuitRedisCommand(LuaScriptState luaScriptState, List<String> keys, List<String> arguments, RedisClient redisClient, Logger log, Future<Void> future) {
        this.luaScriptState = luaScriptState;
        this.keys = keys;
        this.arguments = arguments;
        this.redisClient = redisClient;
        this.log = log;
        this.future = future;
    }

    public void exec(int executionCounter) {
        this.redisClient.evalsha(this.luaScriptState.getSha(), this.keys, this.arguments, event -> {
            if (event.succeeded()) {
                this.future.complete();
            } else {
                String message = event.cause().getMessage();
                if (message != null && message.startsWith("NOSCRIPT")) {
                    this.log.warn("CloseCircuitRedisCommand script couldn't be found, reload it");
                    this.log.warn("amount the script got loaded: " + String.valueOf(executionCounter));
                    if (executionCounter > 10) {
                        this.future.fail("amount the script got loaded is higher than 10, we abort");
                    } else {
                        this.luaScriptState.loadLuaScript((RedisCommand)new CloseCircuitRedisCommand(this.luaScriptState, this.keys, this.arguments, this.redisClient, this.log, this.future), executionCounter);
                    }
                } else {
                    this.future.fail("CloseCircuitRedisCommand request failed with message: " + message);
                }
            }
        });
    }
}

