/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.queue.queuing.circuitbreaker.lua;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.redis.RedisClient;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.swisspush.gateleen.core.lua.LuaScriptState;
import org.swisspush.gateleen.core.lua.RedisCommand;

public class UnlockSampleQueuesRedisCommand
implements RedisCommand {
    private LuaScriptState luaScriptState;
    private List<String> keys;
    private List<String> arguments;
    private Future<List<String>> future;
    private RedisClient redisClient;
    private Logger log;

    public UnlockSampleQueuesRedisCommand(LuaScriptState luaScriptState, List<String> keys, List<String> arguments, RedisClient redisClient, Logger log, Future<List<String>> future) {
        this.luaScriptState = luaScriptState;
        this.keys = keys;
        this.arguments = arguments;
        this.redisClient = redisClient;
        this.log = log;
        this.future = future;
    }

    public void exec(int executionCounter) {
        this.redisClient.evalsha(this.luaScriptState.getSha(), this.keys, this.arguments, event -> {
            if (event.succeeded()) {
                JsonArray result = (JsonArray)event.result();
                this.future.complete(new ArrayList(result.getList()));
            } else {
                String message = event.cause().getMessage();
                if (message != null && message.startsWith("NOSCRIPT")) {
                    this.log.warn("UnlockSampleQueuesRedisCommand script couldn't be found, reload it");
                    this.log.warn("amount the script got loaded: " + String.valueOf(executionCounter));
                    if (executionCounter > 10) {
                        this.future.fail("amount the script got loaded is higher than 10, we abort");
                    } else {
                        this.luaScriptState.loadLuaScript((RedisCommand)new UnlockSampleQueuesRedisCommand(this.luaScriptState, this.keys, this.arguments, this.redisClient, this.log, this.future), executionCounter);
                    }
                } else {
                    this.future.fail("UnlockSampleQueuesRedisCommand request failed with message: " + message);
                }
            }
        });
    }
}

