/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.queue.queuing.circuitbreaker.impl;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.RedisClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.lua.LuaScript;
import org.swisspush.gateleen.core.lua.LuaScriptState;
import org.swisspush.gateleen.core.util.StringUtils;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.QueueCircuitBreakerStorage;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.lua.CloseCircuitRedisCommand;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.lua.GetAllCircuitsRedisCommand;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.lua.HalfOpenCircuitRedisCommand;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.lua.QueueCircuitBreakerLuaScripts;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.lua.ReOpenCircuitRedisCommand;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.lua.UnlockSampleQueuesRedisCommand;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.lua.UpdateStatsRedisCommand;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.util.PatternAndCircuitHash;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.util.QueueCircuitState;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.util.QueueResponseType;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.util.UpdateStatisticsResult;

public class RedisQueueCircuitBreakerStorage
implements QueueCircuitBreakerStorage {
    private RedisClient redisClient;
    private Logger log = LoggerFactory.getLogger(RedisQueueCircuitBreakerStorage.class);
    public static final String STORAGE_PREFIX = "gateleen.queue-circuit-breaker:";
    public static final String STORAGE_INFOS_SUFFIX = ":infos";
    public static final String STORAGE_QUEUES_SUFFIX = ":queues";
    public static final String STORAGE_ALL_CIRCUITS = "gateleen.queue-circuit-breaker:all-circuits";
    public static final String STORAGE_HALFOPEN_CIRCUITS = "gateleen.queue-circuit-breaker:half-open-circuits";
    public static final String STORAGE_OPEN_CIRCUITS = "gateleen.queue-circuit-breaker:open-circuits";
    public static final String STORAGE_QUEUES_TO_UNLOCK = "gateleen.queue-circuit-breaker:queues-to-unlock";
    public static final String FIELD_STATE = "state";
    public static final String FIELD_FAILRATIO = "failRatio";
    public static final String FIELD_CIRCUIT = "circuit";
    private LuaScriptState openCircuitLuaScriptState;
    private LuaScriptState closeCircuitLuaScriptState;
    private LuaScriptState reOpenCircuitLuaScriptState;
    private LuaScriptState halfOpenCircuitLuaScriptState;
    private LuaScriptState unlockSampleQueuesLuaScriptState;
    private LuaScriptState getAllCircuitsLuaScriptState;

    public RedisQueueCircuitBreakerStorage(RedisClient redisClient) {
        this.redisClient = redisClient;
        this.openCircuitLuaScriptState = new LuaScriptState((LuaScript)QueueCircuitBreakerLuaScripts.UPDATE_CIRCUIT, redisClient, false);
        this.closeCircuitLuaScriptState = new LuaScriptState((LuaScript)QueueCircuitBreakerLuaScripts.CLOSE_CIRCUIT, redisClient, false);
        this.reOpenCircuitLuaScriptState = new LuaScriptState((LuaScript)QueueCircuitBreakerLuaScripts.REOPEN_CIRCUIT, redisClient, false);
        this.halfOpenCircuitLuaScriptState = new LuaScriptState((LuaScript)QueueCircuitBreakerLuaScripts.HALFOPEN_CIRCUITS, redisClient, false);
        this.unlockSampleQueuesLuaScriptState = new LuaScriptState((LuaScript)QueueCircuitBreakerLuaScripts.UNLOCK_SAMPLES, redisClient, false);
        this.getAllCircuitsLuaScriptState = new LuaScriptState((LuaScript)QueueCircuitBreakerLuaScripts.ALL_CIRCUITS, redisClient, false);
    }

    @Override
    public Future<QueueCircuitState> getQueueCircuitState(PatternAndCircuitHash patternAndCircuitHash) {
        Future future = Future.future();
        this.redisClient.hget(this.buildInfosKey(patternAndCircuitHash.getCircuitHash()), FIELD_STATE, event -> {
            if (event.failed()) {
                future.fail(event.cause());
            } else {
                String stateAsString = (String)event.result();
                if (StringUtils.isEmpty((CharSequence)stateAsString)) {
                    this.log.info("No status information found for circuit {}. Using default value {}", (Object)patternAndCircuitHash.getPattern().pattern(), (Object)QueueCircuitState.CLOSED);
                }
                future.complete((Object)QueueCircuitState.fromString(stateAsString, QueueCircuitState.CLOSED));
            }
        });
        return future;
    }

    @Override
    public Future<QueueCircuitState> getQueueCircuitState(String circuitHash) {
        Future future = Future.future();
        this.redisClient.hget(this.buildInfosKey(circuitHash), FIELD_STATE, event -> {
            if (event.failed()) {
                future.fail(event.cause());
            } else {
                String stateAsString = (String)event.result();
                if (StringUtils.isEmpty((CharSequence)stateAsString)) {
                    this.log.info("No status information found for circuit {}. Using default value {}", (Object)circuitHash, (Object)QueueCircuitState.CLOSED);
                }
                future.complete((Object)QueueCircuitState.fromString(stateAsString, QueueCircuitState.CLOSED));
            }
        });
        return future;
    }

    @Override
    public Future<JsonObject> getQueueCircuitInformation(String circuitHash) {
        Future future = Future.future();
        List<String> fields = Arrays.asList(FIELD_STATE, FIELD_FAILRATIO, FIELD_CIRCUIT);
        this.redisClient.hmget(this.buildInfosKey(circuitHash), fields, event -> {
            if (event.failed()) {
                future.fail(event.cause());
            } else {
                try {
                    QueueCircuitState state = QueueCircuitState.fromString(((JsonArray)event.result()).getString(0), QueueCircuitState.CLOSED);
                    String failRatioStr = ((JsonArray)event.result()).getString(1);
                    String circuit = ((JsonArray)event.result()).getString(2);
                    JsonObject result = new JsonObject();
                    result.put("status", state.name().toLowerCase());
                    JsonObject info = new JsonObject();
                    if (failRatioStr != null) {
                        info.put(FIELD_FAILRATIO, Integer.valueOf(failRatioStr));
                    }
                    if (circuit != null) {
                        info.put(FIELD_CIRCUIT, circuit);
                    }
                    result.put("info", info);
                    future.complete((Object)result);
                }
                catch (Exception e) {
                    future.fail((Throwable)e);
                }
            }
        });
        return future;
    }

    @Override
    public Future<JsonObject> getAllCircuits() {
        Future future = Future.future();
        List<String> keys = Collections.singletonList(STORAGE_ALL_CIRCUITS);
        List<String> arguments = Arrays.asList(STORAGE_PREFIX, STORAGE_INFOS_SUFFIX);
        GetAllCircuitsRedisCommand cmd = new GetAllCircuitsRedisCommand(this.getAllCircuitsLuaScriptState, keys, arguments, this.redisClient, this.log, (Future<JsonObject>)future);
        cmd.exec(0);
        return future;
    }

    @Override
    public Future<UpdateStatisticsResult> updateStatistics(PatternAndCircuitHash patternAndCircuitHash, String uniqueRequestID, long timestamp, int errorThresholdPercentage, long entriesMaxAgeMS, long minQueueSampleCount, long maxQueueSampleCount, QueueResponseType queueResponseType) {
        Future future = Future.future();
        String circuitHash = patternAndCircuitHash.getCircuitHash();
        List<String> keys = Arrays.asList(this.buildInfosKey(circuitHash), this.buildStatsKey(circuitHash, QueueResponseType.SUCCESS), this.buildStatsKey(circuitHash, QueueResponseType.FAILURE), this.buildStatsKey(circuitHash, queueResponseType), STORAGE_OPEN_CIRCUITS, STORAGE_ALL_CIRCUITS);
        List<String> arguments = Arrays.asList(uniqueRequestID, patternAndCircuitHash.getPattern().pattern(), patternAndCircuitHash.getCircuitHash(), String.valueOf(timestamp), String.valueOf(errorThresholdPercentage), String.valueOf(entriesMaxAgeMS), String.valueOf(minQueueSampleCount), String.valueOf(maxQueueSampleCount));
        UpdateStatsRedisCommand cmd = new UpdateStatsRedisCommand(this.openCircuitLuaScriptState, keys, arguments, this.redisClient, this.log, (Future<UpdateStatisticsResult>)future);
        cmd.exec(0);
        return future;
    }

    @Override
    public Future<Void> lockQueue(String queueName, PatternAndCircuitHash patternAndCircuitHash) {
        Future future = Future.future();
        this.redisClient.zadd(this.buildQueuesKey(patternAndCircuitHash.getCircuitHash()), (double)System.currentTimeMillis(), queueName, event -> {
            if (event.failed()) {
                future.fail(event.cause().getMessage());
                return;
            }
            future.complete();
        });
        return future;
    }

    @Override
    public Future<String> popQueueToUnlock() {
        Future future = Future.future();
        this.redisClient.lpop(STORAGE_QUEUES_TO_UNLOCK, event -> {
            if (event.failed()) {
                future.fail(event.cause().getMessage());
                return;
            }
            future.complete(event.result());
        });
        return future;
    }

    @Override
    public Future<Void> closeCircuit(PatternAndCircuitHash patternAndCircuitHash) {
        return this.closeCircuit(patternAndCircuitHash.getCircuitHash(), false);
    }

    @Override
    public Future<Void> closeAndRemoveCircuit(PatternAndCircuitHash patternAndCircuitHash) {
        return this.closeCircuit(patternAndCircuitHash.getCircuitHash(), true);
    }

    private Future<Void> closeCircuit(String circuitHash, boolean circuitRemoved) {
        Future future = Future.future();
        List<String> keys = Arrays.asList(this.buildInfosKey(circuitHash), this.buildStatsKey(circuitHash, QueueResponseType.SUCCESS), this.buildStatsKey(circuitHash, QueueResponseType.FAILURE), this.buildQueuesKey(circuitHash), STORAGE_ALL_CIRCUITS, STORAGE_HALFOPEN_CIRCUITS, STORAGE_OPEN_CIRCUITS, STORAGE_QUEUES_TO_UNLOCK);
        List<String> arguments = Arrays.asList(circuitHash, String.valueOf(circuitRemoved));
        CloseCircuitRedisCommand cmd = new CloseCircuitRedisCommand(this.closeCircuitLuaScriptState, keys, arguments, this.redisClient, this.log, (Future<Void>)future);
        cmd.exec(0);
        return future;
    }

    @Override
    public Future<Void> closeAllCircuits() {
        Future future = Future.future();
        Future<Void> closeOpenCircuitsFuture = this.closeCircuitsByKey(STORAGE_OPEN_CIRCUITS);
        Future<Void> closeHalfOpenCircuitsFuture = this.closeCircuitsByKey(STORAGE_HALFOPEN_CIRCUITS);
        CompositeFuture.all(closeOpenCircuitsFuture, closeHalfOpenCircuitsFuture).setHandler(event -> {
            if (event.succeeded()) {
                future.complete();
            } else {
                future.fail(event.cause().getMessage());
            }
        });
        return future;
    }

    private Future<Void> closeCircuitsByKey(String key) {
        Future future = Future.future();
        this.redisClient.smembers(key, event -> {
            if (event.succeeded()) {
                ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
                List openCircuits = ((JsonArray)event.result()).getList();
                for (Object circuit : openCircuits) {
                    futures.add(this.closeCircuit((String)circuit, false));
                }
                if (futures.size() == 0) {
                    future.complete();
                } else {
                    CompositeFuture.all(futures).setHandler(event1 -> {
                        if (event1.succeeded()) {
                            future.complete();
                        } else {
                            future.fail(event1.cause().getMessage());
                        }
                    });
                }
            } else {
                future.fail(event.cause().getMessage());
            }
        });
        return future;
    }

    @Override
    public Future<Void> reOpenCircuit(PatternAndCircuitHash patternAndCircuitHash) {
        Future future = Future.future();
        String circuitHash = patternAndCircuitHash.getCircuitHash();
        List<String> keys = Arrays.asList(this.buildInfosKey(circuitHash), STORAGE_HALFOPEN_CIRCUITS, STORAGE_OPEN_CIRCUITS);
        List<String> arguments = Collections.singletonList(circuitHash);
        ReOpenCircuitRedisCommand cmd = new ReOpenCircuitRedisCommand(this.reOpenCircuitLuaScriptState, keys, arguments, this.redisClient, this.log, (Future<Void>)future);
        cmd.exec(0);
        return future;
    }

    @Override
    public Future<Long> setOpenCircuitsToHalfOpen() {
        Future future = Future.future();
        List<String> keys = Arrays.asList(STORAGE_HALFOPEN_CIRCUITS, STORAGE_OPEN_CIRCUITS);
        List<String> arguments = Arrays.asList(STORAGE_PREFIX, STORAGE_INFOS_SUFFIX);
        HalfOpenCircuitRedisCommand cmd = new HalfOpenCircuitRedisCommand(this.halfOpenCircuitLuaScriptState, keys, arguments, this.redisClient, this.log, (Future<Long>)future);
        cmd.exec(0);
        return future;
    }

    @Override
    public Future<List<String>> unlockSampleQueues() {
        Future future = Future.future();
        List<String> keys = Collections.singletonList(STORAGE_HALFOPEN_CIRCUITS);
        List<String> arguments = Arrays.asList(STORAGE_PREFIX, STORAGE_QUEUES_SUFFIX, String.valueOf(System.currentTimeMillis()));
        UnlockSampleQueuesRedisCommand cmd = new UnlockSampleQueuesRedisCommand(this.unlockSampleQueuesLuaScriptState, keys, arguments, this.redisClient, this.log, (Future<List<String>>)future);
        cmd.exec(0);
        return future;
    }

    private String buildInfosKey(String circuitHash) {
        return STORAGE_PREFIX + circuitHash + STORAGE_INFOS_SUFFIX;
    }

    private String buildQueuesKey(String circuitHash) {
        return STORAGE_PREFIX + circuitHash + STORAGE_QUEUES_SUFFIX;
    }

    private String buildStatsKey(String circuitHash, QueueResponseType queueResponseType) {
        return STORAGE_PREFIX + circuitHash + queueResponseType.getKeySuffix();
    }
}

