/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.queue.expiry;

import io.vertx.core.MultiMap;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.http.HttpServerRequest;
import java.util.Optional;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.http.HttpRequest;

public final class ExpiryCheckHandler {
    public static final String SERVER_TIMESTAMP_HEADER = "X-Server-Timestamp";
    public static final String EXPIRE_AFTER_HEADER = "X-Expire-After";
    public static final String QUEUE_EXPIRE_AFTER_HEADER = "x-queue-expire-after";
    private static Logger log = LoggerFactory.getLogger(ExpiryCheckHandler.class);
    private static DateTimeFormatter dfISO8601 = ISODateTimeFormat.dateTime().withZone(DateTimeZone.forID((String)"Europe/Zurich"));
    private static DateTimeFormatter dfISO8601Parser = ISODateTimeFormat.dateTimeParser().withZone(DateTimeZone.forID((String)"Europe/Zurich"));

    private ExpiryCheckHandler() {
    }

    public static void updateServerTimestampHeader(HttpRequest request) {
        if (request.getHeaders() == null) {
            request.setHeaders((MultiMap)new CaseInsensitiveHeaders());
        }
        ExpiryCheckHandler.updateServerTimestampHeader(request.getHeaders());
    }

    public static void updateServerTimestampHeader(MultiMap headers) {
        String serverTimestamp = headers.get(SERVER_TIMESTAMP_HEADER);
        if (serverTimestamp == null) {
            String nowAsISO = dfISO8601.print((ReadableInstant)Instant.now());
            log.debug("Setting {} value to {} since header {} is not defined", new Object[]{SERVER_TIMESTAMP_HEADER, nowAsISO, SERVER_TIMESTAMP_HEADER});
            headers.set(SERVER_TIMESTAMP_HEADER, nowAsISO);
        } else {
            headers.remove(SERVER_TIMESTAMP_HEADER);
            headers.set(SERVER_TIMESTAMP_HEADER, ExpiryCheckHandler.printDateTime(DateTime.now()));
        }
    }

    public static Integer getExpireAfter(MultiMap headers) {
        try {
            Integer ans = ExpiryCheckHandler.getExpireValue(headers.get(EXPIRE_AFTER_HEADER));
            return ans != null && ans == -1 ? null : ans;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Optional<Integer> getExpireAfterConcerningCaseOfCorruptHeaderAndInfinite(MultiMap headers) {
        try {
            Integer expireValue = ExpiryCheckHandler.getExpireValue(headers.get(EXPIRE_AFTER_HEADER));
            return Optional.ofNullable(expireValue);
        }
        catch (NumberFormatException e) {
            log.warn("Conceal exception (because we're not allowed to throw by design): {}: {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            return Optional.empty();
        }
    }

    public static Integer getQueueExpireAfter(MultiMap headers) {
        try {
            Integer ans = ExpiryCheckHandler.getExpireValue(headers.get(QUEUE_EXPIRE_AFTER_HEADER));
            return ans != null && ans == -1 ? null : ans;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Integer getExpireValue(String expirationTimeout) throws NumberFormatException {
        Integer ans;
        if (expirationTimeout == null) {
            ans = null;
        } else {
            ans = Integer.parseInt(expirationTimeout);
            if (ans < -1) {
                throw new NumberFormatException("Values less than -1 aren't valid expireAfter values.");
            }
        }
        return ans;
    }

    public static boolean isExpired(MultiMap headers, Long timestamp) {
        if (headers != null && timestamp != null) {
            Integer queueExpireAfter = ExpiryCheckHandler.getQueueExpireAfter(headers);
            Integer expireAfter = ExpiryCheckHandler.getExpireAfter(headers);
            if (queueExpireAfter != null) {
                expireAfter = queueExpireAfter;
            }
            if (expireAfter != null) {
                long expiredSince = System.currentTimeMillis() - (timestamp + (long)expireAfter.intValue() * 1000L);
                if (expiredSince > 0L) {
                    log.debug(" > isExpired - Request expired since {} milliseconds.", (Object)expiredSince);
                    return true;
                }
                log.debug(" > isExpired - Request not expired (would expire in {} milliseconds).", (Object)(-expiredSince));
                return false;
            }
        }
        return false;
    }

    public static DateTime getExpirationTime(int expireAfter) {
        return ExpiryCheckHandler.getExpirationTime(DateTime.now(), expireAfter);
    }

    public static Optional<String> getExpirationTimeAsString(int expireAfter) {
        String expirationTime = expireAfter == -1 ? null : ExpiryCheckHandler.printDateTime(ExpiryCheckHandler.getExpirationTime(expireAfter));
        return Optional.ofNullable(expirationTime);
    }

    public static DateTime parseDateTime(String datetime) {
        return dfISO8601Parser.parseDateTime(datetime);
    }

    public static String printDateTime(DateTime datetime) {
        return dfISO8601.print((ReadableInstant)datetime);
    }

    private static DateTime getExpirationTime(DateTime timestamp, int expireAfter) {
        DateTime expirationTime = timestamp.plusSeconds(expireAfter);
        log.debug("getExpirationTime: {}", (Object)expirationTime);
        return expirationTime;
    }

    public static void setExpireAfter(HttpServerRequest request, int expireAfter) {
        ExpiryCheckHandler.setFieldValue(request.headers(), EXPIRE_AFTER_HEADER, expireAfter);
    }

    public static void setQueueExpireAfter(MultiMap headers, int queueExpireAfter) {
        ExpiryCheckHandler.setFieldValue(headers, QUEUE_EXPIRE_AFTER_HEADER, queueExpireAfter);
    }

    private static void setFieldValue(MultiMap headers, String field, int expireValue) {
        if (headers.get(field) != null) {
            headers.remove(field);
        }
        headers.set(field, String.valueOf(expireValue));
    }
}

