/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.queue.queuing.circuitbreaker.lua;

import io.vertx.core.Promise;
import io.vertx.redis.client.RedisAPI;
import java.util.List;
import org.slf4j.Logger;
import org.swisspush.gateleen.core.lua.LuaScriptState;
import org.swisspush.gateleen.core.lua.RedisCommand;
import org.swisspush.gateleen.core.util.RedisUtils;

public class CloseCircuitRedisCommand
implements RedisCommand {
    private LuaScriptState luaScriptState;
    private List<String> keys;
    private List<String> arguments;
    private Promise<Void> promise;
    private RedisAPI redisAPI;
    private Logger log;

    public CloseCircuitRedisCommand(LuaScriptState luaScriptState, List<String> keys, List<String> arguments, RedisAPI redisAPI, Logger log, Promise<Void> promise) {
        this.luaScriptState = luaScriptState;
        this.keys = keys;
        this.arguments = arguments;
        this.redisAPI = redisAPI;
        this.log = log;
        this.promise = promise;
    }

    public void exec(int executionCounter) {
        List args = RedisUtils.toPayload((Object[])new Object[]{this.luaScriptState.getSha(), this.keys.size(), this.keys, this.arguments});
        this.redisAPI.evalsha(args, event -> {
            if (event.succeeded()) {
                this.promise.complete();
            } else {
                String message = event.cause().getMessage();
                if (message != null && message.startsWith("NOSCRIPT")) {
                    this.log.warn("CloseCircuitRedisCommand script couldn't be found, reload it");
                    this.log.warn("amount the script got loaded: " + String.valueOf(executionCounter));
                    if (executionCounter > 10) {
                        this.promise.fail("amount the script got loaded is higher than 10, we abort");
                    } else {
                        this.luaScriptState.loadLuaScript((RedisCommand)new CloseCircuitRedisCommand(this.luaScriptState, this.keys, this.arguments, this.redisAPI, this.log, this.promise), executionCounter);
                    }
                } else {
                    this.promise.fail("CloseCircuitRedisCommand request failed with message: " + message);
                }
            }
        });
    }
}

