/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.queue.queuing.circuitbreaker.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.util.HashCodeGenerator;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.util.PatternAndCircuitHash;
import org.swisspush.gateleen.routing.Rule;

public class QueueCircuitBreakerRulePatternToCircuitMapping {
    private Logger log = LoggerFactory.getLogger(QueueCircuitBreakerRulePatternToCircuitMapping.class);
    private List<PatternAndCircuitHash> rulePatternToCircuitMapping = new ArrayList<PatternAndCircuitHash>();

    public List<PatternAndCircuitHash> updateRulePatternToCircuitMapping(List<Rule> rules) {
        ArrayList<PatternAndCircuitHash> originalPatternAndCircuitHashes = new ArrayList<PatternAndCircuitHash>(this.rulePatternToCircuitMapping);
        this.log.debug("clearing rule pattern to circuit mapping values");
        this.rulePatternToCircuitMapping.clear();
        this.log.debug("new rule pattern to circuit mapping values are:");
        for (Rule rule : rules) {
            PatternAndCircuitHash patternAndCircuitHash = this.getPatternAndCircuitHashFromRule(rule);
            if (patternAndCircuitHash != null) {
                this.log.debug(patternAndCircuitHash.toString());
                this.rulePatternToCircuitMapping.add(patternAndCircuitHash);
                continue;
            }
            this.log.error("rule pattern and circuitHash could not be retrieved from rule " + rule.getUrlPattern());
        }
        return this.getRemovedPatternAndCircuitHashes(originalPatternAndCircuitHashes, this.rulePatternToCircuitMapping);
    }

    private List<PatternAndCircuitHash> getRemovedPatternAndCircuitHashes(List<PatternAndCircuitHash> currentPatternAndCircuitHashes, List<PatternAndCircuitHash> newPatternAndCircuitHashes) {
        currentPatternAndCircuitHashes.removeAll(newPatternAndCircuitHashes);
        return currentPatternAndCircuitHashes;
    }

    public PatternAndCircuitHash getCircuitFromRequestUri(String requestUri) {
        for (PatternAndCircuitHash mapping : this.rulePatternToCircuitMapping) {
            if (!mapping.getPattern().matcher(requestUri).matches()) continue;
            return mapping;
        }
        return null;
    }

    private PatternAndCircuitHash getPatternAndCircuitHashFromRule(Rule rule) {
        try {
            Pattern pattern = Pattern.compile(rule.getUrlPattern());
            String circuitHash = HashCodeGenerator.createHashCode((String)rule.getUrlPattern());
            return new PatternAndCircuitHash(pattern, circuitHash);
        }
        catch (Exception e) {
            this.log.error("Could not compile the regex:" + rule.getUrlPattern() + " to a pattern.");
            return null;
        }
    }
}

