/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.queue.queuing;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.redis.client.RedisAPI;
import org.swisspush.gateleen.core.util.Address;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.monitoring.MonitoringHandler;
import org.swisspush.gateleen.queue.duplicate.DuplicateCheckHandler;
import org.swisspush.gateleen.queue.queuing.QueueClient;
import org.swisspush.gateleen.queue.queuing.RequestQueue;
import org.swisspush.redisques.util.RedisquesAPI;

public class QueuingHandler
implements Handler<Buffer> {
    public static final String QUEUE_HEADER = "x-queue";
    public static final String DUPLICATE_CHECK_HEADER = "x-duplicate-check";
    private RequestQueue requestQueue;
    private HttpServerRequest request;
    private Vertx vertx;
    private RedisAPI redisAPI;

    public static boolean isQueued(HttpServerRequest request) {
        String queue = request.headers().get(QUEUE_HEADER);
        return HttpMethod.GET != request.method() && queue != null && !queue.trim().isEmpty();
    }

    public QueuingHandler(Vertx vertx, RedisAPI redisAPI, HttpServerRequest request, MonitoringHandler monitoringHandler) {
        this(vertx, redisAPI, request, new QueueClient(vertx, monitoringHandler));
    }

    public QueuingHandler(Vertx vertx, RedisAPI redisAPI, HttpServerRequest request, RequestQueue requestQueue) {
        this.request = request;
        this.vertx = vertx;
        this.redisAPI = redisAPI;
        this.requestQueue = requestQueue;
    }

    public void handle(Buffer buffer) {
        String queue = this.request.headers().get(QUEUE_HEADER);
        MultiMap headers = this.request.headers();
        headers.remove(QUEUE_HEADER);
        if (headers.names().contains(DUPLICATE_CHECK_HEADER)) {
            DuplicateCheckHandler.checkDuplicateRequest(this.redisAPI, this.request.uri(), buffer, headers.get(DUPLICATE_CHECK_HEADER), (Handler<Boolean>)((Handler)requestIsDuplicate -> {
                if (requestIsDuplicate.booleanValue()) {
                    this.request.response().setStatusCode(StatusCode.ACCEPTED.getStatusCode());
                    this.request.response().setStatusMessage(StatusCode.ACCEPTED.getStatusMessage());
                    this.request.response().end();
                } else {
                    this.requestQueue.enqueue(this.request, headers, buffer, queue);
                }
            }));
        } else {
            this.requestQueue.enqueue(this.request, headers, buffer, queue);
        }
    }

    @Deprecated
    public static void cleanup(Vertx vertx) {
        vertx.eventBus().request(Address.redisquesAddress(), (Object)RedisquesAPI.buildCheckOperation());
    }
}

