/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.queue.duplicate;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.redis.client.RedisAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.util.HashCodeGenerator;

public final class DuplicateCheckHandler {
    private static final String REDIS_KEY_TEMPLATE = "{{history:%s-%s}}";
    private static final String DEFAULT_REDIS_ENTRY_VALUE = "1";
    private static final int DEFAULT_TTL = 60;
    private static Logger log = LoggerFactory.getLogger(DuplicateCheckHandler.class);

    private DuplicateCheckHandler() {
    }

    public static void checkDuplicateRequest(RedisAPI redisAPI, String uri, Buffer buffer, String ttl, Handler<Boolean> callback) {
        Integer timeToLive = DuplicateCheckHandler.parseTimeToLive(ttl);
        String redisKey = DuplicateCheckHandler.getRedisKey(uri, HashCodeGenerator.createHashCode((String)uri, (String)buffer.toString()));
        DuplicateCheckHandler.handleStorage(redisAPI, redisKey, timeToLive, callback);
    }

    private static Integer parseTimeToLive(String ttl) {
        Integer timeToLive;
        try {
            timeToLive = Integer.parseInt(ttl);
        }
        catch (NumberFormatException e) {
            timeToLive = 60;
            log.error("Can't parse value '{}' for time to live. Should be a number. Using default value '{}'", (Object)ttl, (Object)60);
        }
        return timeToLive;
    }

    private static String getRedisKey(String uri, String hash) {
        return String.format(REDIS_KEY_TEMPLATE, uri, hash);
    }

    private static void handleStorage(RedisAPI redisAPI, String redisKey, int ttl, Handler<Boolean> callback) {
        redisAPI.get(redisKey, reply -> {
            if (reply.failed()) {
                log.error("get command for redisKey '{}' resulted in cause {}", (Object)redisKey, (Object)DuplicateCheckHandler.logCause(reply));
                return;
            }
            if (!DEFAULT_REDIS_ENTRY_VALUE.equals(reply.result())) {
                redisAPI.setnx(redisKey, DEFAULT_REDIS_ENTRY_VALUE, setnxReply -> {
                    if (setnxReply.failed()) {
                        log.error("set command for redisKey '{}' resulted in cause {}", (Object)redisKey, (Object)DuplicateCheckHandler.logCause(setnxReply));
                        return;
                    }
                    redisAPI.expire(redisKey, String.valueOf(ttl), expireReply -> {
                        if (expireReply.failed()) {
                            log.error("expire command for redisKey '{}' resulted in cause {}", (Object)redisKey, (Object)DuplicateCheckHandler.logCause(expireReply));
                        }
                    });
                });
                callback.handle((Object)Boolean.FALSE);
            } else {
                log.info("received a duplicate request for redisKey: {}", (Object)redisKey);
                callback.handle((Object)Boolean.TRUE);
            }
        });
    }

    private static String logCause(AsyncResult result) {
        if (result.cause() != null) {
            return result.cause().getMessage();
        }
        return null;
    }
}

