/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.queue.queuing.circuitbreaker.api;

import io.vertx.core.json.JsonObject;

public class QueueCircuitBreakerAPI {
    public static final String OK = "ok";
    public static final String ERROR = "error";
    public static final String STATUS = "status";
    public static final String VALUE = "value";
    public static final String MESSAGE = "message";
    public static final String OPERATION = "operation";
    public static final String PAYLOAD = "payload";
    public static final String CIRCUIT_HASH = "circuit";

    private static JsonObject buildOperation(Operation operation) {
        JsonObject op = new JsonObject();
        op.put(OPERATION, (Object)operation.name());
        return op;
    }

    private static JsonObject buildOperation(Operation operation, JsonObject payload) {
        JsonObject op = QueueCircuitBreakerAPI.buildOperation(operation);
        op.put(PAYLOAD, (Object)payload);
        return op;
    }

    public static JsonObject buildGetCircuitInformationOperation(String circuitHash) {
        return QueueCircuitBreakerAPI.buildOperation(Operation.getCircuitInformation, new JsonObject().put(CIRCUIT_HASH, (Object)circuitHash));
    }

    public static JsonObject buildGetCircuitStatusOperation(String circuitHash) {
        return QueueCircuitBreakerAPI.buildOperation(Operation.getCircuitStatus, new JsonObject().put(CIRCUIT_HASH, (Object)circuitHash));
    }

    public static JsonObject buildCloseCircuitOperation(String circuitHash) {
        return QueueCircuitBreakerAPI.buildOperation(Operation.closeCircuit, new JsonObject().put(CIRCUIT_HASH, (Object)circuitHash));
    }

    public static JsonObject buildCloseAllCircuitsOperation() {
        return QueueCircuitBreakerAPI.buildOperation(Operation.closeAllCircuits);
    }

    public static JsonObject buildGetAllCircuitsOperation() {
        return QueueCircuitBreakerAPI.buildOperation(Operation.getAllCircuits);
    }

    public static enum Operation {
        getAllCircuits,
        getCircuitInformation,
        getCircuitStatus,
        closeCircuit,
        closeAllCircuits;


        public static Operation fromString(String op) {
            for (Operation operation : Operation.values()) {
                if (!operation.name().equalsIgnoreCase(op)) continue;
                return operation;
            }
            return null;
        }
    }
}

