/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.queue.queuing.circuitbreaker.impl;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.client.RedisAPI;
import io.vertx.redis.client.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.lua.LuaScript;
import org.swisspush.gateleen.core.lua.LuaScriptState;
import org.swisspush.gateleen.core.util.StringUtils;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.QueueCircuitBreakerStorage;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.lua.CloseCircuitRedisCommand;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.lua.GetAllCircuitsRedisCommand;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.lua.HalfOpenCircuitRedisCommand;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.lua.QueueCircuitBreakerLuaScripts;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.lua.ReOpenCircuitRedisCommand;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.lua.UnlockSampleQueuesRedisCommand;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.lua.UpdateStatsRedisCommand;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.util.PatternAndCircuitHash;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.util.QueueCircuitState;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.util.QueueResponseType;
import org.swisspush.gateleen.queue.queuing.circuitbreaker.util.UpdateStatisticsResult;

public class RedisQueueCircuitBreakerStorage
implements QueueCircuitBreakerStorage {
    private RedisAPI redisAPI;
    private Logger log = LoggerFactory.getLogger(RedisQueueCircuitBreakerStorage.class);
    public static final String STORAGE_PREFIX = "gateleen.queue-circuit-breaker:";
    public static final String STORAGE_INFOS_SUFFIX = ":infos";
    public static final String STORAGE_QUEUES_SUFFIX = ":queues";
    public static final String STORAGE_ALL_CIRCUITS = "gateleen.queue-circuit-breaker:all-circuits";
    public static final String STORAGE_HALFOPEN_CIRCUITS = "gateleen.queue-circuit-breaker:half-open-circuits";
    public static final String STORAGE_OPEN_CIRCUITS = "gateleen.queue-circuit-breaker:open-circuits";
    public static final String STORAGE_QUEUES_TO_UNLOCK = "gateleen.queue-circuit-breaker:queues-to-unlock";
    public static final String FIELD_STATE = "state";
    public static final String FIELD_FAILRATIO = "failRatio";
    public static final String FIELD_CIRCUIT = "circuit";
    private LuaScriptState openCircuitLuaScriptState;
    private LuaScriptState closeCircuitLuaScriptState;
    private LuaScriptState reOpenCircuitLuaScriptState;
    private LuaScriptState halfOpenCircuitLuaScriptState;
    private LuaScriptState unlockSampleQueuesLuaScriptState;
    private LuaScriptState getAllCircuitsLuaScriptState;

    public RedisQueueCircuitBreakerStorage(RedisAPI redisAPI) {
        this.redisAPI = redisAPI;
        this.openCircuitLuaScriptState = new LuaScriptState((LuaScript)QueueCircuitBreakerLuaScripts.UPDATE_CIRCUIT, redisAPI, false);
        this.closeCircuitLuaScriptState = new LuaScriptState((LuaScript)QueueCircuitBreakerLuaScripts.CLOSE_CIRCUIT, redisAPI, false);
        this.reOpenCircuitLuaScriptState = new LuaScriptState((LuaScript)QueueCircuitBreakerLuaScripts.REOPEN_CIRCUIT, redisAPI, false);
        this.halfOpenCircuitLuaScriptState = new LuaScriptState((LuaScript)QueueCircuitBreakerLuaScripts.HALFOPEN_CIRCUITS, redisAPI, false);
        this.unlockSampleQueuesLuaScriptState = new LuaScriptState((LuaScript)QueueCircuitBreakerLuaScripts.UNLOCK_SAMPLES, redisAPI, false);
        this.getAllCircuitsLuaScriptState = new LuaScriptState((LuaScript)QueueCircuitBreakerLuaScripts.ALL_CIRCUITS, redisAPI, false);
    }

    @Override
    public Future<QueueCircuitState> getQueueCircuitState(PatternAndCircuitHash patternAndCircuitHash) {
        Promise promise = Promise.promise();
        this.redisAPI.hget(this.buildInfosKey(patternAndCircuitHash.getCircuitHash()), FIELD_STATE, event -> {
            if (event.failed()) {
                promise.fail(event.cause());
            } else {
                String stateAsString = Objects.toString(event.result(), "");
                if (StringUtils.isEmpty((CharSequence)stateAsString)) {
                    this.log.info("No status information found for circuit {}. Using default value {}", (Object)patternAndCircuitHash.getPattern().pattern(), (Object)QueueCircuitState.CLOSED);
                }
                promise.complete((Object)QueueCircuitState.fromString(stateAsString, QueueCircuitState.CLOSED));
            }
        });
        return promise.future();
    }

    @Override
    public Future<QueueCircuitState> getQueueCircuitState(String circuitHash) {
        Promise promise = Promise.promise();
        this.redisAPI.hget(this.buildInfosKey(circuitHash), FIELD_STATE, event -> {
            if (event.failed()) {
                promise.fail(event.cause());
            } else {
                String stateAsString = Objects.toString(event.result(), "");
                if (StringUtils.isEmpty((CharSequence)stateAsString)) {
                    this.log.info("No status information found for circuit {}. Using default value {}", (Object)circuitHash, (Object)QueueCircuitState.CLOSED);
                }
                promise.complete((Object)QueueCircuitState.fromString(stateAsString, QueueCircuitState.CLOSED));
            }
        });
        return promise.future();
    }

    @Override
    public Future<JsonObject> getQueueCircuitInformation(String circuitHash) {
        Promise promise = Promise.promise();
        this.redisAPI.hmget(Arrays.asList(this.buildInfosKey(circuitHash), FIELD_STATE, FIELD_FAILRATIO, FIELD_CIRCUIT), event -> {
            if (event.failed()) {
                promise.fail(event.cause());
            } else {
                try {
                    QueueCircuitState state = QueueCircuitState.fromString(Objects.toString(((Response)event.result()).get(0), null), QueueCircuitState.CLOSED);
                    String failRatioStr = Objects.toString(((Response)event.result()).get(1), null);
                    String circuit = Objects.toString(((Response)event.result()).get(2), null);
                    JsonObject result = new JsonObject();
                    result.put("status", (Object)state.name().toLowerCase());
                    JsonObject info = new JsonObject();
                    if (failRatioStr != null) {
                        info.put(FIELD_FAILRATIO, (Object)Integer.valueOf(failRatioStr));
                    }
                    if (circuit != null) {
                        info.put(FIELD_CIRCUIT, (Object)circuit);
                    }
                    result.put("info", (Object)info);
                    promise.complete((Object)result);
                }
                catch (Exception e) {
                    promise.fail((Throwable)e);
                }
            }
        });
        return promise.future();
    }

    @Override
    public Future<JsonObject> getAllCircuits() {
        Promise promise = Promise.promise();
        List<String> keys = Collections.singletonList(STORAGE_ALL_CIRCUITS);
        List<String> arguments = Arrays.asList(STORAGE_PREFIX, STORAGE_INFOS_SUFFIX);
        GetAllCircuitsRedisCommand cmd = new GetAllCircuitsRedisCommand(this.getAllCircuitsLuaScriptState, keys, arguments, this.redisAPI, this.log, (Promise<JsonObject>)promise);
        cmd.exec(0);
        return promise.future();
    }

    @Override
    public Future<UpdateStatisticsResult> updateStatistics(PatternAndCircuitHash patternAndCircuitHash, String uniqueRequestID, long timestamp, int errorThresholdPercentage, long entriesMaxAgeMS, long minQueueSampleCount, long maxQueueSampleCount, QueueResponseType queueResponseType) {
        Promise promise = Promise.promise();
        String circuitHash = patternAndCircuitHash.getCircuitHash();
        List<String> keys = Arrays.asList(this.buildInfosKey(circuitHash), this.buildStatsKey(circuitHash, QueueResponseType.SUCCESS), this.buildStatsKey(circuitHash, QueueResponseType.FAILURE), this.buildStatsKey(circuitHash, queueResponseType), STORAGE_OPEN_CIRCUITS, STORAGE_ALL_CIRCUITS);
        List<String> arguments = Arrays.asList(uniqueRequestID, patternAndCircuitHash.getPattern().pattern(), patternAndCircuitHash.getCircuitHash(), String.valueOf(timestamp), String.valueOf(errorThresholdPercentage), String.valueOf(entriesMaxAgeMS), String.valueOf(minQueueSampleCount), String.valueOf(maxQueueSampleCount));
        UpdateStatsRedisCommand cmd = new UpdateStatsRedisCommand(this.openCircuitLuaScriptState, keys, arguments, this.redisAPI, this.log, (Promise<UpdateStatisticsResult>)promise);
        cmd.exec(0);
        return promise.future();
    }

    @Override
    public Future<Void> lockQueue(String queueName, PatternAndCircuitHash patternAndCircuitHash) {
        Promise promise = Promise.promise();
        this.redisAPI.zadd(Arrays.asList(this.buildQueuesKey(patternAndCircuitHash.getCircuitHash()), String.valueOf(System.currentTimeMillis()), queueName), event -> {
            if (event.failed()) {
                promise.fail(event.cause().getMessage());
                return;
            }
            promise.complete();
        });
        return promise.future();
    }

    @Override
    public Future<String> popQueueToUnlock() {
        Promise promise = Promise.promise();
        this.redisAPI.lpop(Collections.singletonList(STORAGE_QUEUES_TO_UNLOCK), event -> {
            if (event.failed()) {
                promise.fail(event.cause().getMessage());
                return;
            }
            promise.complete((Object)Objects.toString(event.result(), null));
        });
        return promise.future();
    }

    @Override
    public Future<Void> closeCircuit(PatternAndCircuitHash patternAndCircuitHash) {
        return this.closeCircuit(patternAndCircuitHash.getCircuitHash(), false);
    }

    @Override
    public Future<Void> closeAndRemoveCircuit(PatternAndCircuitHash patternAndCircuitHash) {
        return this.closeCircuit(patternAndCircuitHash.getCircuitHash(), true);
    }

    private Future<Void> closeCircuit(String circuitHash, boolean circuitRemoved) {
        Promise promise = Promise.promise();
        List<String> keys = Arrays.asList(this.buildInfosKey(circuitHash), this.buildStatsKey(circuitHash, QueueResponseType.SUCCESS), this.buildStatsKey(circuitHash, QueueResponseType.FAILURE), this.buildQueuesKey(circuitHash), STORAGE_ALL_CIRCUITS, STORAGE_HALFOPEN_CIRCUITS, STORAGE_OPEN_CIRCUITS, STORAGE_QUEUES_TO_UNLOCK);
        List<String> arguments = Arrays.asList(circuitHash, String.valueOf(circuitRemoved));
        CloseCircuitRedisCommand cmd = new CloseCircuitRedisCommand(this.closeCircuitLuaScriptState, keys, arguments, this.redisAPI, this.log, (Promise<Void>)promise);
        cmd.exec(0);
        return promise.future();
    }

    @Override
    public Future<Void> closeAllCircuits() {
        Promise promise = Promise.promise();
        Future<Void> closeOpenCircuitsFuture = this.closeCircuitsByKey(STORAGE_OPEN_CIRCUITS);
        Future<Void> closeHalfOpenCircuitsFuture = this.closeCircuitsByKey(STORAGE_HALFOPEN_CIRCUITS);
        CompositeFuture.all(closeOpenCircuitsFuture, closeHalfOpenCircuitsFuture).onComplete(event -> {
            if (event.succeeded()) {
                promise.complete();
            } else {
                promise.fail(event.cause().getMessage());
            }
        });
        return promise.future();
    }

    private Future<Void> closeCircuitsByKey(String key) {
        Promise promise = Promise.promise();
        this.redisAPI.smembers(key, event -> {
            if (event.succeeded()) {
                ArrayList<Future<Void>> promises = new ArrayList<Future<Void>>();
                for (Response circuit : (Response)event.result()) {
                    promises.add(this.closeCircuit(circuit.toString(), false));
                }
                if (promises.size() == 0) {
                    promise.complete();
                } else {
                    CompositeFuture.all(promises).onComplete(event1 -> {
                        if (event1.succeeded()) {
                            promise.complete();
                        } else {
                            promise.fail(event1.cause().getMessage());
                        }
                    });
                }
            } else {
                promise.fail(event.cause().getMessage());
            }
        });
        return promise.future();
    }

    @Override
    public Future<Void> reOpenCircuit(PatternAndCircuitHash patternAndCircuitHash) {
        Promise promise = Promise.promise();
        String circuitHash = patternAndCircuitHash.getCircuitHash();
        List<String> keys = Arrays.asList(this.buildInfosKey(circuitHash), STORAGE_HALFOPEN_CIRCUITS, STORAGE_OPEN_CIRCUITS);
        List<String> arguments = Collections.singletonList(circuitHash);
        ReOpenCircuitRedisCommand cmd = new ReOpenCircuitRedisCommand(this.reOpenCircuitLuaScriptState, keys, arguments, this.redisAPI, this.log, (Promise<Void>)promise);
        cmd.exec(0);
        return promise.future();
    }

    @Override
    public Future<Long> setOpenCircuitsToHalfOpen() {
        Promise promise = Promise.promise();
        List<String> keys = Arrays.asList(STORAGE_HALFOPEN_CIRCUITS, STORAGE_OPEN_CIRCUITS);
        List<String> arguments = Arrays.asList(STORAGE_PREFIX, STORAGE_INFOS_SUFFIX);
        HalfOpenCircuitRedisCommand cmd = new HalfOpenCircuitRedisCommand(this.halfOpenCircuitLuaScriptState, keys, arguments, this.redisAPI, this.log, (Promise<Long>)promise);
        cmd.exec(0);
        return promise.future();
    }

    @Override
    public Future<Response> unlockSampleQueues() {
        Promise promise = Promise.promise();
        List<String> keys = Collections.singletonList(STORAGE_HALFOPEN_CIRCUITS);
        List<String> arguments = Arrays.asList(STORAGE_PREFIX, STORAGE_QUEUES_SUFFIX, String.valueOf(System.currentTimeMillis()));
        UnlockSampleQueuesRedisCommand cmd = new UnlockSampleQueuesRedisCommand(this.unlockSampleQueuesLuaScriptState, keys, arguments, this.redisAPI, this.log, (Promise<Response>)promise);
        cmd.exec(0);
        return promise.future();
    }

    private String buildInfosKey(String circuitHash) {
        return STORAGE_PREFIX + circuitHash + STORAGE_INFOS_SUFFIX;
    }

    private String buildQueuesKey(String circuitHash) {
        return STORAGE_PREFIX + circuitHash + STORAGE_QUEUES_SUFFIX;
    }

    private String buildStatsKey(String circuitHash, QueueResponseType queueResponseType) {
        return STORAGE_PREFIX + circuitHash + queueResponseType.getKeySuffix();
    }
}

