/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.queue.queuing.circuitbreaker.lua;

import io.vertx.core.Promise;
import io.vertx.redis.client.Response;
import java.util.List;
import org.slf4j.Logger;
import org.swisspush.gateleen.core.lua.LuaScriptState;
import org.swisspush.gateleen.core.lua.RedisCommand;
import org.swisspush.gateleen.core.redis.RedisProvider;
import org.swisspush.gateleen.core.util.RedisUtils;

public class HalfOpenCircuitRedisCommand
implements RedisCommand {
    private final LuaScriptState luaScriptState;
    private final List<String> keys;
    private final List<String> arguments;
    private final Promise<Long> promise;
    private final RedisProvider redisProvider;
    private final Logger log;

    public HalfOpenCircuitRedisCommand(LuaScriptState luaScriptState, List<String> keys, List<String> arguments, RedisProvider redisProvider, Logger log, Promise<Long> promise) {
        this.luaScriptState = luaScriptState;
        this.keys = keys;
        this.arguments = arguments;
        this.redisProvider = redisProvider;
        this.log = log;
        this.promise = promise;
    }

    public void exec(int executionCounter) {
        List args = RedisUtils.toPayload((Object[])new Object[]{this.luaScriptState.getSha(), this.keys.size(), this.keys, this.arguments});
        this.redisProvider.redis().onSuccess(redisAPI -> redisAPI.evalsha(args, event -> {
            if (event.succeeded()) {
                this.promise.complete((Object)((Response)event.result()).toLong());
            } else {
                String message = event.cause().getMessage();
                if (message != null && message.startsWith("NOSCRIPT")) {
                    this.log.warn("HalfOpenCircuitRedisCommand script couldn't be found, reload it");
                    this.log.warn("amount the script got loaded: " + executionCounter);
                    if (executionCounter > 10) {
                        this.promise.fail("amount the script got loaded is higher than 10, we abort");
                    } else {
                        this.luaScriptState.loadLuaScript((RedisCommand)new HalfOpenCircuitRedisCommand(this.luaScriptState, this.keys, this.arguments, this.redisProvider, this.log, this.promise), executionCounter);
                    }
                } else {
                    this.promise.fail("HalfOpenCircuitRedisCommand request failed with message: " + message);
                }
            }
        })).onFailure(throwable -> this.promise.fail("Redis: HalfOpenCircuitRedisCommand request failed with message: " + throwable.getMessage()));
    }
}

